/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-11-05 15:49:50 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=7267 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=69424 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=2093 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_dokan_announcement` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `post_id` bigint(11) NOT NULL,
  `status` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_dokan_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) DEFAULT NULL,
  `seller_id` bigint(20) DEFAULT NULL,
  `order_total` float(11,2) DEFAULT NULL,
  `net_amount` float(11,2) DEFAULT NULL,
  `order_status` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `seller_id` (`seller_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_dokan_refund` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `seller_id` bigint(20) NOT NULL,
  `refund_amount` float NOT NULL,
  `refund_reason` text DEFAULT NULL,
  `item_qtys` varchar(50) DEFAULT NULL,
  `item_totals` varchar(50) DEFAULT NULL,
  `item_tax_totals` varchar(50) DEFAULT NULL,
  `restock_items` varchar(10) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` int(1) NOT NULL,
  `method` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_dokan_withdraw` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `amount` float NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` int(1) NOT NULL,
  `method` varchar(30) NOT NULL,
  `note` text NOT NULL,
  `ip` varchar(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_ewwwio_images` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `image_md5` varchar(55) DEFAULT NULL,
  `results` varchar(55) NOT NULL,
  `gallery` varchar(30) DEFAULT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `updates` int(5) unsigned DEFAULT NULL,
  `updated` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE current_timestamp(),
  `trace` blob DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `path_image_size` (`path`(255),`image_size`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=178931 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=13037 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=6808 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  `advanced` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  `advanced` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_revslider_settings` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `general` text NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=534 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=50248 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=201 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(250)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `gross_total` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `total_sales` double NOT NULL DEFAULT 0,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(191),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_ir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text1` text CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `text2` text CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` longtext NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=1373 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type` (`location_type`),
  KEY `location_type_code` (`location_type`,`location_code`(90))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type` (`location_type`),
  KEY `location_type_code` (`location_type`,`location_code`(90))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(191)),
  KEY `tax_rate_class` (`tax_rate_class`(191)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("7017", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-03-23 21:14:01", "2023-03-23 21:14:01", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1679606041;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1679606041;}", "5", "1", "2023-03-23 21:14:17", "2023-03-24 00:44:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7108", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-06-07 07:12:40", "2023-06-07 07:12:40", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1686121960;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1686121960;}", "5", "1", "2023-06-07 08:31:31", "2023-06-07 12:01:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7080", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-05-13 14:55:18", "2023-05-13 14:55:18", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1683989718;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1683989718;}", "5", "1", "2023-05-13 14:55:51", "2023-05-13 18:25:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7067", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-05-01 15:54:59", "2023-05-01 15:54:59", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1682956499;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1682956499;}", "5", "1", "2023-05-01 15:56:09", "2023-05-01 19:26:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7084", "action_scheduler/migration_hook", "failed", "2023-05-13 15:03:39", "2023-05-13 15:03:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1683990219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1683990219;}", "1", "1", "2023-05-13 16:16:35", "2023-05-13 19:46:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7119", "action_scheduler/migration_hook", "failed", "2023-06-15 03:18:43", "2023-06-15 03:18:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1686799123;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1686799123;}", "1", "1", "2023-06-15 03:18:43", "2023-06-15 06:48:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7134", "action_scheduler/migration_hook", "failed", "2023-06-27 17:26:31", "2023-06-27 17:26:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1687886791;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1687886791;}", "1", "1", "2023-06-27 17:27:23", "2023-06-27 20:57:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7141", "action_scheduler/migration_hook", "failed", "2023-06-30 18:32:02", "2023-06-30 18:32:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1688149922;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1688149922;}", "1", "1", "2023-06-30 18:32:59", "2023-06-30 22:02:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7255", "woocommerce_cleanup_draft_orders", "complete", "2023-10-26 23:36:35", "2023-10-26 23:36:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698363395;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698363395;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-27 06:29:53", "2023-10-27 09:59:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7258", "woocommerce_cleanup_draft_orders", "complete", "2023-10-30 16:50:47", "2023-10-30 16:50:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698684647;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698684647;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-30 17:44:13", "2023-10-30 21:14:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7261", "woocommerce_cleanup_draft_orders", "complete", "2023-11-02 18:19:11", "2023-11-02 18:19:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698949151;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698949151;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-11-02 20:46:37", "2023-11-03 00:16:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7237", "woocommerce_cleanup_draft_orders", "complete", "2023-10-06 21:01:50", "2023-10-06 21:01:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696626110;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696626110;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-07 00:23:00", "2023-10-07 03:53:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7238", "woocommerce_cleanup_draft_orders", "complete", "2023-10-08 00:23:00", "2023-10-08 00:23:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696724580;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696724580;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-08 06:39:50", "2023-10-08 10:09:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7245", "woocommerce_cleanup_draft_orders", "complete", "2023-10-16 05:18:12", "2023-10-16 05:18:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697433492;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697433492;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-16 06:35:23", "2023-10-16 10:05:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7262", "woocommerce_cleanup_draft_orders", "complete", "2023-11-03 20:46:37", "2023-11-03 20:46:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699044397;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699044397;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-11-03 22:16:13", "2023-11-04 01:46:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7242", "woocommerce_cleanup_draft_orders", "complete", "2023-10-12 21:11:09", "2023-10-12 21:11:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697145069;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697145069;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-13 01:47:00", "2023-10-13 05:17:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7243", "woocommerce_cleanup_draft_orders", "complete", "2023-10-14 01:47:00", "2023-10-14 01:47:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697248020;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697248020;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-14 04:24:06", "2023-10-14 07:54:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7248", "woocommerce_cleanup_draft_orders", "complete", "2023-10-19 07:33:13", "2023-10-19 07:33:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697700793;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697700793;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-19 08:38:03", "2023-10-19 12:08:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7250", "woocommerce_cleanup_draft_orders", "complete", "2023-10-21 11:39:28", "2023-10-21 11:39:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697888368;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697888368;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-21 11:42:25", "2023-10-21 15:12:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7251", "woocommerce_cleanup_draft_orders", "complete", "2023-10-22 11:42:25", "2023-10-22 11:42:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697974945;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697974945;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-22 13:34:57", "2023-10-22 17:04:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7252", "woocommerce_cleanup_draft_orders", "complete", "2023-10-23 13:34:57", "2023-10-23 13:34:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698068097;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698068097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-23 14:30:27", "2023-10-23 18:00:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7253", "woocommerce_cleanup_draft_orders", "complete", "2023-10-24 14:30:27", "2023-10-24 14:30:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698157827;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698157827;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-24 15:09:15", "2023-10-24 18:39:15", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7254", "woocommerce_cleanup_draft_orders", "complete", "2023-10-25 15:09:15", "2023-10-25 15:09:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698246555;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698246555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-25 23:36:35", "2023-10-26 03:06:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7263", "woocommerce_cleanup_draft_orders", "complete", "2023-11-04 22:16:13", "2023-11-04 22:16:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699136173;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699136173;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-11-04 23:20:43", "2023-11-05 02:50:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7264", "woocommerce_cleanup_draft_orders", "pending", "2023-11-05 23:20:43", "2023-11-05 23:20:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699226443;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699226443;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7236", "woocommerce_cleanup_draft_orders", "complete", "2023-10-05 17:13:58", "2023-10-05 17:13:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696526038;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696526038;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-05 21:01:50", "2023-10-06 00:31:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7239", "woocommerce_cleanup_draft_orders", "complete", "2023-10-09 06:39:50", "2023-10-09 06:39:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696833590;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696833590;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-09 07:48:32", "2023-10-09 11:18:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7240", "woocommerce_cleanup_draft_orders", "complete", "2023-10-10 07:48:32", "2023-10-10 07:48:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696924112;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696924112;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-10 11:54:14", "2023-10-10 15:24:14", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7241", "woocommerce_cleanup_draft_orders", "complete", "2023-10-11 11:54:14", "2023-10-11 11:54:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697025254;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697025254;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-11 21:11:09", "2023-10-12 00:41:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7244", "woocommerce_cleanup_draft_orders", "complete", "2023-10-15 04:24:06", "2023-10-15 04:24:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697343846;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697343846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-15 05:18:12", "2023-10-15 08:48:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7246", "woocommerce_cleanup_draft_orders", "complete", "2023-10-17 06:35:23", "2023-10-17 06:35:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697524523;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697524523;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-17 07:25:34", "2023-10-17 10:55:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7247", "woocommerce_cleanup_draft_orders", "complete", "2023-10-18 07:25:34", "2023-10-18 07:25:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697613934;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697613934;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-18 07:33:13", "2023-10-18 11:03:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7249", "woocommerce_cleanup_draft_orders", "complete", "2023-10-20 08:38:03", "2023-10-20 08:38:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697791083;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697791083;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-20 11:39:28", "2023-10-20 15:09:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7256", "woocommerce_cleanup_draft_orders", "complete", "2023-10-28 06:29:53", "2023-10-28 06:29:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698474593;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698474593;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-28 15:58:04", "2023-10-28 19:28:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7257", "woocommerce_cleanup_draft_orders", "complete", "2023-10-29 15:58:04", "2023-10-29 15:58:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698595084;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698595084;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-29 16:50:47", "2023-10-29 20:20:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7259", "woocommerce_cleanup_draft_orders", "complete", "2023-10-31 17:44:13", "2023-10-31 17:44:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698774253;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698774253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-10-31 18:18:12", "2023-10-31 21:48:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7260", "woocommerce_cleanup_draft_orders", "complete", "2023-11-01 18:18:12", "2023-11-01 18:18:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698862692;s:18:\"\0*\0first_timestamp\";i:1655355672;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698862692;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2023-11-01 18:19:11", "2023-11-01 21:49:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7265", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2023-11-05 15:42:34", "2023-11-05 15:42:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1699198954;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1699198954;}", "2", "1", "2023-11-05 15:43:48", "2023-11-05 19:13:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7266", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2023-11-05 15:42:33", "2023-11-05 15:42:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1699198953;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1699198953;}", "5", "1", "2023-11-05 15:43:48", "2023-11-05 19:13:48", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wc_update_product_lookup_tables");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("1341", "7017", "ایجاد فعالیت", "2023-03-23 21:14:01", "2023-03-23 21:14:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1344", "7017", "عملیات توسط Async Request شروع شد", "2023-03-23 21:14:17", "2023-03-23 21:14:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1345", "7017", "اقدام از طریق Async Request انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-03-23 21:14:17", "2023-03-23 21:14:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1614", "7108", "ایجاد فعالیت", "2023-06-07 07:12:40", "2023-06-07 07:12:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1530", "7080", "ایجاد فعالیت", "2023-05-13 14:55:18", "2023-05-13 14:55:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1489", "7067", "ایجاد فعالیت", "2023-05-01 15:54:59", "2023-05-01 15:54:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1494", "7067", "عملیات توسط Async Request شروع شد", "2023-05-01 15:56:09", "2023-05-01 15:56:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1495", "7067", "اقدام از طریق Async Request انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-05-01 15:56:09", "2023-05-01 15:56:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1533", "7080", "عملیات توسط WP Cron شروع شد", "2023-05-13 14:55:51", "2023-05-13 14:55:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1534", "7080", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-05-13 14:55:51", "2023-05-13 14:55:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1544", "7084", "ایجاد فعالیت", "2023-05-13 15:02:39", "2023-05-13 15:02:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1545", "7084", "عملیات توسط WP Cron شروع شد", "2023-05-13 16:16:35", "2023-05-13 16:16:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1546", "7084", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-05-13 16:16:35", "2023-05-13 16:16:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1617", "7108", "عملیات توسط WP Cron شروع شد", "2023-06-07 08:31:31", "2023-06-07 08:31:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1618", "7108", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-06-07 08:31:31", "2023-06-07 08:31:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1649", "7119", "ایجاد فعالیت", "2023-06-15 03:17:43", "2023-06-15 03:17:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1650", "7119", "عملیات توسط WP Cron شروع شد", "2023-06-15 03:18:43", "2023-06-15 03:18:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1651", "7119", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-06-15 03:18:43", "2023-06-15 03:18:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1694", "7134", "ایجاد فعالیت", "2023-06-27 17:25:31", "2023-06-27 17:25:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1695", "7134", "عملیات توسط WP Cron شروع شد", "2023-06-27 17:27:23", "2023-06-27 17:27:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1696", "7134", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-06-27 17:27:23", "2023-06-27 17:27:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1715", "7141", "ایجاد فعالیت", "2023-06-30 18:31:02", "2023-06-30 18:31:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1716", "7141", "عملیات توسط WP Cron شروع شد", "2023-06-30 18:32:59", "2023-06-30 18:32:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1717", "7141", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-06-30 18:32:59", "2023-06-30 18:32:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2068", "7258", "ایجاد فعالیت", "2023-10-29 16:50:47", "2023-10-29 16:50:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2076", "7260", "عملیات توسط Async Request کامل شد", "2023-11-01 18:19:11", "2023-11-01 18:19:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2005", "7237", "ایجاد فعالیت", "2023-10-05 21:01:50", "2023-10-05 21:01:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2008", "7238", "ایجاد فعالیت", "2023-10-07 00:23:00", "2023-10-07 00:23:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2004", "7236", "عملیات توسط WP Cron کامل شد", "2023-10-05 21:01:50", "2023-10-05 21:01:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2003", "7236", "عملیات توسط WP Cron شروع شد", "2023-10-05 21:01:50", "2023-10-05 21:01:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2029", "7245", "ایجاد فعالیت", "2023-10-15 05:18:12", "2023-10-15 05:18:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2028", "7244", "عملیات توسط WP Cron کامل شد", "2023-10-15 05:18:12", "2023-10-15 05:18:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2027", "7244", "عملیات توسط WP Cron شروع شد", "2023-10-15 05:18:12", "2023-10-15 05:18:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2058", "7254", "عملیات توسط WP Cron کامل شد", "2023-10-25 23:36:35", "2023-10-25 23:36:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2055", "7253", "عملیات توسط WP Cron کامل شد", "2023-10-24 15:09:15", "2023-10-24 15:09:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2057", "7254", "عملیات توسط WP Cron شروع شد", "2023-10-25 23:36:35", "2023-10-25 23:36:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2075", "7260", "عملیات توسط Async Request شروع شد", "2023-11-01 18:19:11", "2023-11-01 18:19:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2007", "7237", "عملیات توسط WP Cron کامل شد", "2023-10-07 00:23:00", "2023-10-07 00:23:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2006", "7237", "عملیات توسط WP Cron شروع شد", "2023-10-07 00:23:00", "2023-10-07 00:23:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2020", "7242", "ایجاد فعالیت", "2023-10-11 21:11:09", "2023-10-11 21:11:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2019", "7241", "عملیات توسط WP Cron کامل شد", "2023-10-11 21:11:09", "2023-10-11 21:11:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2018", "7241", "عملیات توسط WP Cron شروع شد", "2023-10-11 21:11:09", "2023-10-11 21:11:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2023", "7243", "ایجاد فعالیت", "2023-10-13 01:47:00", "2023-10-13 01:47:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2022", "7242", "عملیات توسط WP Cron کامل شد", "2023-10-13 01:47:00", "2023-10-13 01:47:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2021", "7242", "عملیات توسط WP Cron شروع شد", "2023-10-13 01:47:00", "2023-10-13 01:47:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2038", "7248", "ایجاد فعالیت", "2023-10-18 07:33:13", "2023-10-18 07:33:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2037", "7247", "عملیات توسط WP Cron کامل شد", "2023-10-18 07:33:13", "2023-10-18 07:33:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2036", "7247", "عملیات توسط WP Cron شروع شد", "2023-10-18 07:33:13", "2023-10-18 07:33:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2044", "7250", "ایجاد فعالیت", "2023-10-20 11:39:28", "2023-10-20 11:39:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2043", "7249", "عملیات توسط WP Cron کامل شد", "2023-10-20 11:39:28", "2023-10-20 11:39:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2042", "7249", "عملیات توسط WP Cron شروع شد", "2023-10-20 11:39:28", "2023-10-20 11:39:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2047", "7251", "ایجاد فعالیت", "2023-10-21 11:42:25", "2023-10-21 11:42:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2046", "7250", "عملیات توسط WP Cron کامل شد", "2023-10-21 11:42:25", "2023-10-21 11:42:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2045", "7250", "عملیات توسط WP Cron شروع شد", "2023-10-21 11:42:25", "2023-10-21 11:42:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2050", "7252", "ایجاد فعالیت", "2023-10-22 13:34:57", "2023-10-22 13:34:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2049", "7251", "عملیات توسط WP Cron کامل شد", "2023-10-22 13:34:57", "2023-10-22 13:34:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2048", "7251", "عملیات توسط WP Cron شروع شد", "2023-10-22 13:34:57", "2023-10-22 13:34:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2052", "7252", "عملیات توسط Async Request کامل شد", "2023-10-23 14:30:27", "2023-10-23 14:30:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2051", "7252", "عملیات توسط Async Request شروع شد", "2023-10-23 14:30:27", "2023-10-23 14:30:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2054", "7253", "عملیات توسط WP Cron شروع شد", "2023-10-24 15:09:15", "2023-10-24 15:09:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2067", "7257", "عملیات توسط WP Cron کامل شد", "2023-10-29 16:50:47", "2023-10-29 16:50:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2066", "7257", "عملیات توسط WP Cron شروع شد", "2023-10-29 16:50:47", "2023-10-29 16:50:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2080", "7262", "ایجاد فعالیت", "2023-11-02 20:46:37", "2023-11-02 20:46:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2079", "7261", "عملیات توسط WP Cron کامل شد", "2023-11-02 20:46:37", "2023-11-02 20:46:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2078", "7261", "عملیات توسط WP Cron شروع شد", "2023-11-02 20:46:37", "2023-11-02 20:46:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2083", "7263", "ایجاد فعالیت", "2023-11-03 22:16:13", "2023-11-03 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2082", "7262", "عملیات توسط WP Cron کامل شد", "2023-11-03 22:16:13", "2023-11-03 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2081", "7262", "عملیات توسط WP Cron شروع شد", "2023-11-03 22:16:13", "2023-11-03 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2086", "7264", "ایجاد فعالیت", "2023-11-04 23:20:43", "2023-11-04 23:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2085", "7263", "عملیات توسط WP Cron کامل شد", "2023-11-04 23:20:43", "2023-11-04 23:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2084", "7263", "عملیات توسط WP Cron شروع شد", "2023-11-04 23:20:43", "2023-11-04 23:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2002", "7236", "ایجاد فعالیت", "2023-10-04 17:13:58", "2023-10-04 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2009", "7238", "عملیات توسط WP Cron شروع شد", "2023-10-08 06:39:50", "2023-10-08 06:39:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2010", "7238", "عملیات توسط WP Cron کامل شد", "2023-10-08 06:39:50", "2023-10-08 06:39:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2011", "7239", "ایجاد فعالیت", "2023-10-08 06:39:50", "2023-10-08 06:39:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2012", "7239", "عملیات توسط WP Cron شروع شد", "2023-10-09 07:48:32", "2023-10-09 07:48:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2013", "7239", "عملیات توسط WP Cron کامل شد", "2023-10-09 07:48:32", "2023-10-09 07:48:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2014", "7240", "ایجاد فعالیت", "2023-10-09 07:48:32", "2023-10-09 07:48:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2015", "7240", "عملیات توسط WP Cron شروع شد", "2023-10-10 11:54:14", "2023-10-10 11:54:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2016", "7240", "عملیات توسط WP Cron کامل شد", "2023-10-10 11:54:14", "2023-10-10 11:54:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2017", "7241", "ایجاد فعالیت", "2023-10-10 11:54:14", "2023-10-10 11:54:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2024", "7243", "عملیات توسط WP Cron شروع شد", "2023-10-14 04:24:06", "2023-10-14 04:24:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2025", "7243", "عملیات توسط WP Cron کامل شد", "2023-10-14 04:24:06", "2023-10-14 04:24:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2026", "7244", "ایجاد فعالیت", "2023-10-14 04:24:06", "2023-10-14 04:24:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2030", "7245", "عملیات توسط WP Cron شروع شد", "2023-10-16 06:35:23", "2023-10-16 06:35:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2031", "7245", "عملیات توسط WP Cron کامل شد", "2023-10-16 06:35:23", "2023-10-16 06:35:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2032", "7246", "ایجاد فعالیت", "2023-10-16 06:35:23", "2023-10-16 06:35:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2033", "7246", "عملیات توسط WP Cron شروع شد", "2023-10-17 07:25:34", "2023-10-17 07:25:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2034", "7246", "عملیات توسط WP Cron کامل شد", "2023-10-17 07:25:34", "2023-10-17 07:25:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2035", "7247", "ایجاد فعالیت", "2023-10-17 07:25:34", "2023-10-17 07:25:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2039", "7248", "عملیات توسط WP Cron شروع شد", "2023-10-19 08:38:03", "2023-10-19 08:38:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2040", "7248", "عملیات توسط WP Cron کامل شد", "2023-10-19 08:38:03", "2023-10-19 08:38:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2041", "7249", "ایجاد فعالیت", "2023-10-19 08:38:03", "2023-10-19 08:38:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2053", "7253", "ایجاد فعالیت", "2023-10-23 14:30:27", "2023-10-23 14:30:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2056", "7254", "ایجاد فعالیت", "2023-10-24 15:09:15", "2023-10-24 15:09:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2059", "7255", "ایجاد فعالیت", "2023-10-25 23:36:35", "2023-10-25 23:36:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2060", "7255", "عملیات توسط WP Cron شروع شد", "2023-10-27 06:29:53", "2023-10-27 06:29:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2061", "7255", "عملیات توسط WP Cron کامل شد", "2023-10-27 06:29:53", "2023-10-27 06:29:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2062", "7256", "ایجاد فعالیت", "2023-10-27 06:29:53", "2023-10-27 06:29:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2063", "7256", "عملیات توسط WP Cron شروع شد", "2023-10-28 15:58:04", "2023-10-28 15:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2064", "7256", "عملیات توسط WP Cron کامل شد", "2023-10-28 15:58:04", "2023-10-28 15:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2065", "7257", "ایجاد فعالیت", "2023-10-28 15:58:04", "2023-10-28 15:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2069", "7258", "عملیات توسط WP Cron شروع شد", "2023-10-30 17:44:13", "2023-10-30 17:44:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2070", "7258", "عملیات توسط WP Cron کامل شد", "2023-10-30 17:44:13", "2023-10-30 17:44:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2071", "7259", "ایجاد فعالیت", "2023-10-30 17:44:13", "2023-10-30 17:44:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2072", "7259", "عملیات توسط WP Cron شروع شد", "2023-10-31 18:18:11", "2023-10-31 18:18:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2073", "7259", "عملیات توسط WP Cron کامل شد", "2023-10-31 18:18:12", "2023-10-31 18:18:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2074", "7260", "ایجاد فعالیت", "2023-10-31 18:18:12", "2023-10-31 18:18:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2077", "7261", "ایجاد فعالیت", "2023-11-01 18:19:11", "2023-11-01 18:19:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2087", "7265", "ایجاد فعالیت", "2023-11-05 15:42:33", "2023-11-05 15:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2088", "7266", "ایجاد فعالیت", "2023-11-05 15:42:33", "2023-11-05 15:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2089", "7266", "عملیات توسط Async Request شروع شد", "2023-11-05 15:43:48", "2023-11-05 15:43:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2090", "7266", "عملیات توسط Async Request کامل شد", "2023-11-05 15:43:48", "2023-11-05 15:43:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2091", "7265", "عملیات توسط Async Request شروع شد", "2023-11-05 15:43:48", "2023-11-05 15:43:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2092", "7265", "عملیات توسط Async Request کامل شد", "2023-11-05 15:43:48", "2023-11-05 15:43:48");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("5", "3", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("6", "3", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("37", "80", "rating", "3");
INSERT INTO `wp_commentmeta` VALUES("38", "80", "verified", "0");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("3", "6024", "mehdi", "", "", "83.122.79.51", "2018-12-02 16:19:00", "2018-12-02 16:19:00", "محصول بسیار خوبی است .\r\nازتون ممنونم", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.110 Safari/537.36", "review", "0", "3");
INSERT INTO `wp_comments` VALUES("80", "6026", "parsdemo", "info@zephyr.com", "", "37.129.225.32", "2020-08-17 08:02:45", "2020-08-17 04:32:45", "سلام محصول خوبی است.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.125 Safari/537.36", "review", "0", "8");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("6", "20230627_d982d8a7d984d8a8d982d8afd8b1d8", "d7249daa9d99f60c2457_20231105154923", "21", "2023-11-05 15:49:50", "parsdemo", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-11-05 15:49:23\";s:7:\"Version\";s:7:\"1.5.6.1\";s:9:\"VersionWP\";s:5:\"6.3.2\";s:9:\"VersionDB\";s:7:\"10.6.14\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:6;s:4:\"Name\";s:39:\"20230627_d982d8a7d984d8a8d982d8afd8b1d8\";s:4:\"Hash\";s:35:\"d7249daa9d99f60c2457_20231105154923\";s:8:\"NameHash\";s:75:\"20230627_d982d8a7d984d8a8d982d8afd8b1d8_d7249daa9d99f60c2457_20231105154923\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20230627_d982d8a7d984d8a8d982d8afd8b1d8_d7249daa9d99f60c2457_20231105154923_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.4\";s:6:\"WPUser\";s:8:\"parsdemo\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20230627_d982d8a7d984d8a8d982d8afd8b1d8_d7249daa9d99f60c2457_20231105154923_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:61:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2459;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:17077;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-11-05 15:49:23\";s:7:\"Version\";s:7:\"1.5.6.1\";s:9:\"VersionWP\";s:5:\"6.3.2\";s:9:\"VersionDB\";s:7:\"10.6.14\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20230627_d982d8a7d984d8a8d982d8afd8b1d8\";s:4:\"Hash\";s:35:\"d7249daa9d99f60c2457_20231105154923\";s:8:\"NameHash\";s:75:\"20230627_d982d8a7d984d8a8d982d8afd8b1d8_d7249daa9d99f60c2457_20231105154923\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20230627_d982d8a7d984d8a8d982d8afd8b1d8_d7249daa9d99f60c2457_20231105154923_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:75:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20230627_d982d8a7d984d8a8d982d8afd8b1d8_d7249daa9d99f60c2457_20231105154923_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:167:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo/wp-snapshots/tmp/20230627_d982d8a7d984d8a8d982d8afd8b1d8_d7249daa9d99f60c2457_20231105154923_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:70:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo/wp-admin\";i:1;s:73:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo/wp-includes\";i:2;s:82:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:61:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo\";i:1;s:61:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo\";i:2;s:72:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo/wp-content\";i:3;s:80:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo/wp-content/uploads\";i:4;s:80:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo/wp-content/plugins\";i:5;s:83:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo/wp-content/mu-plugins\";i:6;s:79:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:78:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo/wp-snapshots/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://demo.parsplugin.com/upsolo", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://demo.parsplugin.com/upsolo", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "قالب قدرتمند زفایر", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "قالب چندمنظوره", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "info@parsplugin.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("30", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("31", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("32", "active_plugins", "a:13:{i:0;s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:51:\"api-key-for-google-maps/api-key-for-google-maps.php\";i:3;s:48:\"codelights-shortcodes-and-widgets/codelights.php\";i:4;s:36:\"contact-form-7/wp-contact-form-7.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:23:\"gutenberg/gutenberg.php\";i:7;s:27:\"js_composer/js_composer.php\";i:8;s:47:\"regenerate-thumbnails/regenerate-thumbnails.php\";i:9;s:23:\"revslider/revslider.php\";i:10;s:19:\"us-core/us-core.php\";i:11;s:27:\"woocommerce/woocommerce.php\";i:12;s:29:\"wp-parsidate/wp-parsidate.php\";}", "yes");
INSERT INTO `wp_options` VALUES("19440", "widget_us_contacts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("17436", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("33", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("34", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("35", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("36", "gmt_offset", "3.5", "yes");
INSERT INTO `wp_options` VALUES("37", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("38", "recently_edited", "a:3:{i:0;s:96:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo/wp-content/themes/Zephyr/style.css\";i:1;s:100:\"/home/demopars/domains/demo.parsplugin.com/public_html/upsolo/wp-content/themes/Zephyr/functions.php\";i:3;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("39", "template", "Zephyr", "yes");
INSERT INTO `wp_options` VALUES("40", "stylesheet", "Zephyr", "yes");
INSERT INTO `wp_options` VALUES("82970", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("47", "db_version", "55853", "yes");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("72", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:1:{i:0;i:68;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14367", "theme_mods_twentyseventeen", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:3:\"top\";i:30;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1533210867;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:2:{i:0;s:26:\"woocommerce_price_filter-2\";i:1;s:38:\"woocommerce_recently_viewed_products-2\";}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("14665", "theme_switched_via_customizer", "", "yes");
INSERT INTO `wp_options` VALUES("14666", "customize_stashed_theme_mods", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("14667", "woocommerce_maybe_regenerate_images_hash", "f295711100eef51cf7195e603d0739ad", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:2:{s:39:\"us-header-builder/us-header-builder.php\";s:14:\"ushb_uninstall\";s:65:\"remove-google-fonts-references/remove-google-fonts-references.php\";s:29:\"remove_google_fonts_uninstall\";}", "no");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "1546", "yes");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("87", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("90", "initial_db_version", "35700", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_user_roles", "a:9:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:224:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_us_portfolio\";b:1;s:17:\"read_us_portfolio\";b:1;s:19:\"delete_us_portfolio\";b:1;s:18:\"edit_us_portfolios\";b:1;s:25:\"edit_others_us_portfolios\";b:1;s:21:\"publish_us_portfolios\";b:1;s:26:\"read_private_us_portfolios\";b:1;s:20:\"delete_us_portfolios\";b:1;s:28:\"delete_private_us_portfolios\";b:1;s:30:\"delete_published_us_portfolios\";b:1;s:27:\"delete_others_us_portfolios\";b:1;s:26:\"edit_private_us_portfolios\";b:1;s:28:\"edit_published_us_portfolios\";b:1;s:14:\"edit_us_client\";b:1;s:14:\"read_us_client\";b:1;s:16:\"delete_us_client\";b:1;s:15:\"edit_us_clients\";b:1;s:22:\"edit_others_us_clients\";b:1;s:18:\"publish_us_clients\";b:1;s:23:\"read_private_us_clients\";b:1;s:17:\"delete_us_clients\";b:1;s:25:\"delete_private_us_clients\";b:1;s:27:\"delete_published_us_clients\";b:1;s:24:\"delete_others_us_clients\";b:1;s:23:\"edit_private_us_clients\";b:1;s:25:\"edit_published_us_clients\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:24:\"vc_access_rules_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;s:9:\"edit_post\";b:1;s:9:\"read_post\";b:1;s:11:\"delete_post\";b:1;s:19:\"edit_us_testimonial\";b:1;s:19:\"read_us_testimonial\";b:1;s:21:\"delete_us_testimonial\";b:1;s:20:\"edit_us_testimonials\";b:1;s:27:\"edit_others_us_testimonials\";b:1;s:23:\"publish_us_testimonials\";b:1;s:28:\"read_private_us_testimonials\";b:1;s:22:\"delete_us_testimonials\";b:1;s:30:\"delete_private_us_testimonials\";b:1;s:32:\"delete_published_us_testimonials\";b:1;s:29:\"delete_others_us_testimonials\";b:1;s:28:\"edit_private_us_testimonials\";b:1;s:30:\"edit_published_us_testimonials\";b:1;s:14:\"edit_us_footer\";b:1;s:14:\"read_us_footer\";b:1;s:16:\"delete_us_footer\";b:1;s:15:\"edit_us_footers\";b:1;s:22:\"edit_others_us_footers\";b:1;s:18:\"publish_us_footers\";b:1;s:23:\"read_private_us_footers\";b:1;s:17:\"delete_us_footers\";b:1;s:25:\"delete_private_us_footers\";b:1;s:27:\"delete_published_us_footers\";b:1;s:24:\"delete_others_us_footers\";b:1;s:23:\"edit_private_us_footers\";b:1;s:25:\"edit_published_us_footers\";b:1;s:8:\"dokandar\";b:1;s:18:\"edit_us_page_block\";b:1;s:18:\"read_us_page_block\";b:1;s:20:\"delete_us_page_block\";b:1;s:19:\"edit_us_page_blocks\";b:1;s:26:\"edit_others_us_page_blocks\";b:1;s:22:\"publish_us_page_blocks\";b:1;s:27:\"read_private_us_page_blocks\";b:1;s:21:\"delete_us_page_blocks\";b:1;s:29:\"delete_private_us_page_blocks\";b:1;s:31:\"delete_published_us_page_blocks\";b:1;s:28:\"delete_others_us_page_blocks\";b:1;s:27:\"edit_private_us_page_blocks\";b:1;s:29:\"edit_published_us_page_blocks\";b:1;s:10:\"loco_admin\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:39:\"vc_access_rules_post_types/us_portfolio\";b:1;s:36:\"vc_access_rules_post_types/us_footer\";b:1;s:41:\"vc_access_rules_post_types/us_testimonial\";b:1;s:40:\"vc_access_rules_post_types/us_page_block\";b:1;s:46:\"vc_access_rules_post_types/us_content_template\";b:1;s:34:\"vc_access_rules_post_types/product\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:1;s:37:\"vc_access_rules_post_types/attachment\";b:1;s:9:\"edit_page\";b:1;s:9:\"read_page\";b:1;s:11:\"delete_page\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:51:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:39:\"vc_access_rules_post_types/us_portfolio\";b:1;s:36:\"vc_access_rules_post_types/us_footer\";b:1;s:41:\"vc_access_rules_post_types/us_testimonial\";b:1;s:40:\"vc_access_rules_post_types/us_page_block\";b:1;s:46:\"vc_access_rules_post_types/us_content_template\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:27:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:39:\"vc_access_rules_post_types/us_portfolio\";b:1;s:36:\"vc_access_rules_post_types/us_footer\";b:1;s:41:\"vc_access_rules_post_types/us_testimonial\";b:1;s:40:\"vc_access_rules_post_types/us_page_block\";b:1;s:46:\"vc_access_rules_post_types/us_content_template\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:0;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:22:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:39:\"vc_access_rules_post_types/us_portfolio\";b:1;s:36:\"vc_access_rules_post_types/us_footer\";b:1;s:41:\"vc_access_rules_post_types/us_testimonial\";b:1;s:40:\"vc_access_rules_post_types/us_page_block\";b:1;s:46:\"vc_access_rules_post_types/us_content_template\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:0;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:10:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:39:\"vc_access_rules_post_types/us_portfolio\";b:1;s:36:\"vc_access_rules_post_types/us_footer\";b:1;s:41:\"vc_access_rules_post_types/us_testimonial\";b:1;s:40:\"vc_access_rules_post_types/us_page_block\";b:1;s:46:\"vc_access_rules_post_types/us_content_template\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:9:{s:4:\"read\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:39:\"vc_access_rules_post_types/us_portfolio\";b:1;s:36:\"vc_access_rules_post_types/us_footer\";b:1;s:41:\"vc_access_rules_post_types/us_testimonial\";b:1;s:40:\"vc_access_rules_post_types/us_page_block\";b:1;s:46:\"vc_access_rules_post_types/us_content_template\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop Manager\";s:12:\"capabilities\";a:126:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:8:\"dokandar\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:39:\"vc_access_rules_post_types/us_portfolio\";b:1;s:36:\"vc_access_rules_post_types/us_footer\";b:1;s:41:\"vc_access_rules_post_types/us_testimonial\";b:1;s:40:\"vc_access_rules_post_types/us_page_block\";b:1;s:46:\"vc_access_rules_post_types/us_content_template\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:0;}}s:6:\"seller\";a:2:{s:4:\"name\";s:6:\"Vendor\";s:12:\"capabilities\";a:29:{s:4:\"read\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:12:\"delete_posts\";b:1;s:17:\"manage_categories\";b:1;s:17:\"moderate_comments\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:16:\"edit_shop_orders\";b:1;s:8:\"dokandar\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:39:\"vc_access_rules_post_types/us_portfolio\";b:1;s:36:\"vc_access_rules_post_types/us_footer\";b:1;s:41:\"vc_access_rules_post_types/us_testimonial\";b:1;s:40:\"vc_access_rules_post_types/us_page_block\";b:1;s:46:\"vc_access_rules_post_types/us_content_template\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:10:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:39:\"vc_access_rules_post_types/us_portfolio\";b:1;s:36:\"vc_access_rules_post_types/us_footer\";b:1;s:41:\"vc_access_rules_post_types/us_testimonial\";b:1;s:40:\"vc_access_rules_post_types/us_page_block\";b:1;s:46:\"vc_access_rules_post_types/us_content_template\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("92", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("93", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "sidebars_widgets", "a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"default_sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:12:\"shop_sidebar\";a:3:{i:0;s:26:\"woocommerce_price_filter-2\";i:1;s:38:\"woocommerce_recently_viewed_products-2\";i:2;s:11:\"tag_cloud-2\";}s:12:\"footer_first\";a:1:{i:0;s:10:\"us_login-2\";}s:13:\"footer_second\";a:1:{i:0;s:14:\"us_portfolio-2\";}s:12:\"footer_third\";a:1:{i:0;s:12:\"us_socials-2\";}s:13:\"footer_fourth\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("217", "usof_backup_زفایر", "a:2:{s:4:\"time\";s:19:\"2016-07-02 20:30:59\";s:12:\"usof_options\";a:248:{s:9:\"preloader\";s:8:\"disabled\";s:15:\"preloader_image\";s:0:\"\";s:12:\"page_sidebar\";s:4:\"none\";s:17:\"generate_css_file\";i:0;s:10:\"og_enabled\";i:1;s:32:\"enable_unsupported_vc_shortcodes\";i:0;s:11:\"custom_html\";s:0:\"\";s:17:\"responsive_layout\";i:1;s:13:\"canvas_layout\";s:4:\"wide\";s:13:\"color_body_bg\";s:7:\"#e0e0e0\";s:13:\"body_bg_image\";s:0:\"\";s:20:\"body_bg_image_repeat\";s:6:\"repeat\";s:22:\"body_bg_image_position\";s:10:\"top_center\";s:24:\"body_bg_image_attachment\";s:6:\"scroll\";s:18:\"body_bg_image_size\";s:5:\"cover\";s:17:\"site_canvas_width\";i:1300;s:18:\"site_content_width\";i:1140;s:13:\"sidebar_width\";i:25;s:13:\"content_width\";i:70;s:22:\"columns_stacking_width\";i:767;s:21:\"disable_effects_width\";i:900;s:22:\"color_header_middle_bg\";s:7:\"#7049ba\";s:24:\"color_header_middle_text\";s:7:\"#ffffff\";s:30:\"color_header_middle_text_hover\";s:7:\"#ffffff\";s:19:\"color_header_top_bg\";s:7:\"#6039a8\";s:21:\"color_header_top_text\";s:7:\"#c8b8e5\";s:27:\"color_header_top_text_hover\";s:7:\"#ffffff\";s:22:\"color_header_bottom_bg\";s:7:\"#6039a8\";s:24:\"color_header_bottom_text\";s:7:\"#c8b8e5\";s:30:\"color_header_bottom_text_hover\";s:7:\"#ffffff\";s:29:\"color_header_transparent_text\";s:7:\"#ffffff\";s:35:\"color_header_transparent_text_hover\";s:7:\"#ffffff\";s:22:\"color_header_search_bg\";s:7:\"#7049ba\";s:24:\"color_header_search_text\";s:7:\"#ffffff\";s:19:\"color_menu_hover_bg\";s:7:\"#6039a8\";s:21:\"color_menu_hover_text\";s:7:\"#ffffff\";s:22:\"color_menu_active_text\";s:7:\"#ffc670\";s:34:\"color_menu_transparent_active_text\";s:7:\"#ffc670\";s:13:\"color_drop_bg\";s:7:\"#ffffff\";s:15:\"color_drop_text\";s:7:\"#212121\";s:19:\"color_drop_hover_bg\";s:4:\"#eee\";s:21:\"color_drop_hover_text\";s:7:\"#212121\";s:20:\"color_drop_active_bg\";s:7:\"#f7f7f7\";s:22:\"color_drop_active_text\";s:7:\"#7049ba\";s:20:\"color_menu_button_bg\";s:7:\"#ffffff\";s:22:\"color_menu_button_text\";s:7:\"#7049ba\";s:26:\"color_menu_button_hover_bg\";s:7:\"#ffffff\";s:28:\"color_menu_button_hover_text\";s:7:\"#7049ba\";s:16:\"color_content_bg\";s:7:\"#ffffff\";s:20:\"color_content_bg_alt\";s:7:\"#f5f5f5\";s:20:\"color_content_border\";s:7:\"#e0e0e0\";s:21:\"color_content_heading\";s:7:\"#212121\";s:18:\"color_content_text\";s:7:\"#424242\";s:21:\"color_content_primary\";s:7:\"#7049ba\";s:23:\"color_content_secondary\";s:7:\"#ffb03a\";s:19:\"color_content_faded\";s:7:\"#9e9e9e\";s:18:\"color_subfooter_bg\";s:7:\"#212121\";s:22:\"color_subfooter_bg_alt\";s:7:\"#292929\";s:22:\"color_subfooter_border\";s:4:\"#333\";s:20:\"color_subfooter_text\";s:7:\"#757575\";s:23:\"color_subfooter_heading\";s:7:\"#9e9e9e\";s:20:\"color_subfooter_link\";s:7:\"#9e9e9e\";s:26:\"color_subfooter_link_hover\";s:7:\"#ffb03a\";s:15:\"color_footer_bg\";s:4:\"#111\";s:17:\"color_footer_text\";s:7:\"#757575\";s:17:\"color_footer_link\";s:7:\"#9e9e9e\";s:23:\"color_footer_link_hover\";s:7:\"#ffb03a\";s:11:\"color_style\";i:1;s:20:\"change_header_colors\";i:0;s:18:\"change_menu_colors\";i:0;s:21:\"change_content_colors\";i:0;s:23:\"change_subfooter_colors\";i:0;s:20:\"change_footer_colors\";i:0;s:10:\"custom_css\";s:0:\"\";s:13:\"header_layout\";s:8:\"simple_1\";s:13:\"header_sticky\";a:3:{i:0;s:7:\"default\";i:1;s:7:\"tablets\";i:2;s:7:\"mobiles\";}s:18:\"header_transparent\";i:0;s:16:\"header_fullwidth\";i:0;s:17:\"header_top_height\";i:40;s:24:\"header_top_sticky_height\";i:0;s:20:\"header_middle_height\";i:100;s:27:\"header_middle_sticky_height\";i:50;s:20:\"header_bottom_height\";i:50;s:27:\"header_bottom_sticky_height\";i:50;s:17:\"header_main_width\";i:300;s:22:\"header_invert_logo_pos\";i:0;s:18:\"header_search_show\";i:1;s:20:\"header_search_layout\";s:10:\"fullscreen\";s:20:\"header_contacts_show\";i:0;s:21:\"header_contacts_phone\";s:0:\"\";s:21:\"header_contacts_email\";s:0:\"\";s:27:\"header_contacts_custom_icon\";s:0:\"\";s:27:\"header_contacts_custom_text\";s:0:\"\";s:19:\"header_socials_show\";i:0;s:23:\"header_socials_facebook\";s:0:\"\";s:22:\"header_socials_twitter\";s:0:\"\";s:21:\"header_socials_google\";s:0:\"\";s:23:\"header_socials_linkedin\";s:0:\"\";s:22:\"header_socials_youtube\";s:0:\"\";s:20:\"header_socials_vimeo\";s:0:\"\";s:21:\"header_socials_flickr\";s:0:\"\";s:22:\"header_socials_behance\";s:0:\"\";s:24:\"header_socials_instagram\";s:0:\"\";s:19:\"header_socials_xing\";s:0:\"\";s:24:\"header_socials_pinterest\";s:0:\"\";s:20:\"header_socials_skype\";s:0:\"\";s:23:\"header_socials_dribbble\";s:0:\"\";s:17:\"header_socials_vk\";s:0:\"\";s:21:\"header_socials_tumblr\";s:0:\"\";s:25:\"header_socials_soundcloud\";s:0:\"\";s:21:\"header_socials_twitch\";s:0:\"\";s:19:\"header_socials_yelp\";s:0:\"\";s:25:\"header_socials_deviantart\";s:0:\"\";s:25:\"header_socials_foursquare\";s:0:\"\";s:21:\"header_socials_github\";s:0:\"\";s:28:\"header_socials_odnoklassniki\";s:0:\"\";s:21:\"header_socials_s500px\";s:0:\"\";s:20:\"header_socials_houzz\";s:0:\"\";s:21:\"header_socials_medium\";s:0:\"\";s:26:\"header_socials_tripadvisor\";s:0:\"\";s:18:\"header_socials_rss\";s:0:\"\";s:25:\"header_socials_custom_url\";s:0:\"\";s:26:\"header_socials_custom_icon\";s:0:\"\";s:20:\"header_language_show\";i:0;s:22:\"header_language_source\";s:3:\"own\";s:17:\"header_link_title\";s:0:\"\";s:15:\"header_link_qty\";s:1:\"2\";s:19:\"header_link_1_label\";s:0:\"\";s:17:\"header_link_1_url\";s:0:\"\";s:19:\"header_link_2_label\";s:0:\"\";s:17:\"header_link_2_url\";s:0:\"\";s:19:\"header_link_3_label\";s:0:\"\";s:17:\"header_link_3_url\";s:0:\"\";s:19:\"header_link_4_label\";s:0:\"\";s:17:\"header_link_4_url\";s:0:\"\";s:19:\"header_link_5_label\";s:0:\"\";s:17:\"header_link_5_url\";s:0:\"\";s:19:\"header_link_6_label\";s:0:\"\";s:17:\"header_link_6_url\";s:0:\"\";s:19:\"header_link_7_label\";s:0:\"\";s:17:\"header_link_7_url\";s:0:\"\";s:19:\"header_link_8_label\";s:0:\"\";s:17:\"header_link_8_url\";s:0:\"\";s:19:\"header_link_9_label\";s:0:\"\";s:17:\"header_link_9_url\";s:0:\"\";s:9:\"logo_type\";s:4:\"text\";s:9:\"logo_text\";s:4:\"LOGO\";s:14:\"logo_font_size\";i:26;s:22:\"logo_font_size_tablets\";i:24;s:22:\"logo_font_size_mobiles\";i:20;s:10:\"logo_image\";s:0:\"\";s:11:\"logo_height\";i:60;s:18:\"logo_height_sticky\";i:60;s:19:\"logo_height_tablets\";i:40;s:19:\"logo_height_mobiles\";i:30;s:22:\"logo_image_transparent\";s:0:\"\";s:18:\"logo_image_tablets\";s:0:\"\";s:18:\"logo_image_mobiles\";s:0:\"\";s:13:\"menu_fontsize\";i:16;s:12:\"menu_indents\";i:40;s:11:\"menu_height\";i:0;s:20:\"menu_dropdown_effect\";s:7:\"mdesign\";s:17:\"menu_sub_fontsize\";i:15;s:17:\"menu_mobile_width\";i:900;s:19:\"menu_togglable_type\";i:1;s:16:\"titlebar_content\";s:3:\"all\";s:13:\"titlebar_size\";s:5:\"large\";s:14:\"titlebar_color\";s:9:\"alternate\";s:26:\"titlebar_portfolio_content\";s:3:\"all\";s:23:\"titlebar_portfolio_size\";s:5:\"large\";s:24:\"titlebar_portfolio_color\";s:9:\"alternate\";s:24:\"titlebar_archive_content\";s:3:\"all\";s:21:\"titlebar_archive_size\";s:6:\"medium\";s:22:\"titlebar_archive_color\";s:9:\"alternate\";s:15:\"footer_show_top\";i:0;s:14:\"footer_columns\";i:3;s:18:\"footer_show_bottom\";i:1;s:16:\"footer_copyright\";s:18:\"Any text goes here\";s:19:\"heading_font_family\";s:7:\"Rezvan|\";s:11:\"h1_fontsize\";s:2:\"40\";s:18:\"h1_fontsize_mobile\";s:2:\"30\";s:16:\"h1_letterspacing\";s:1:\"0\";s:11:\"h2_fontsize\";s:2:\"34\";s:18:\"h2_fontsize_mobile\";s:2:\"26\";s:16:\"h2_letterspacing\";s:1:\"0\";s:11:\"h3_fontsize\";s:2:\"28\";s:18:\"h3_fontsize_mobile\";s:2:\"22\";s:16:\"h3_letterspacing\";s:1:\"0\";s:11:\"h4_fontsize\";s:2:\"24\";s:18:\"h4_fontsize_mobile\";s:2:\"20\";s:16:\"h4_letterspacing\";s:1:\"0\";s:11:\"h5_fontsize\";s:2:\"20\";s:18:\"h5_fontsize_mobile\";s:2:\"18\";s:16:\"h5_letterspacing\";s:1:\"0\";s:11:\"h6_fontsize\";s:2:\"18\";s:18:\"h6_fontsize_mobile\";s:2:\"16\";s:16:\"h6_letterspacing\";s:1:\"0\";s:16:\"body_font_family\";s:7:\"BYekan|\";s:13:\"body_fontsize\";s:2:\"14\";s:20:\"body_fontsize_mobile\";s:2:\"16\";s:15:\"body_lineheight\";s:2:\"24\";s:22:\"body_lineheight_mobile\";s:2:\"28\";s:16:\"menu_font_family\";s:7:\"BYekan|\";s:11:\"font_subset\";s:5:\"latin\";s:17:\"portfolio_sidebar\";s:4:\"none\";s:18:\"portfolio_comments\";i:0;s:19:\"portfolio_sided_nav\";i:1;s:27:\"portfolio_prevnext_category\";i:0;s:14:\"portfolio_slug\";s:9:\"portfolio\";s:23:\"portfolio_category_slug\";s:18:\"portfolio_category\";s:12:\"post_sidebar\";s:5:\"right\";s:19:\"post_preview_layout\";s:5:\"basic\";s:9:\"post_meta\";a:5:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:4:\"tags\";}s:12:\"post_sharing\";i:0;s:17:\"post_sharing_type\";s:6:\"simple\";s:22:\"post_sharing_providers\";a:3:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:5:\"gplus\";}s:15:\"post_author_box\";i:0;s:8:\"post_nav\";i:0;s:17:\"post_nav_category\";i:0;s:12:\"post_related\";i:1;s:19:\"post_related_layout\";s:7:\"compact\";s:12:\"blog_sidebar\";s:5:\"right\";s:11:\"blog_layout\";s:7:\"classic\";s:9:\"blog_cols\";s:1:\"1\";s:17:\"blog_content_type\";s:7:\"excerpt\";s:9:\"blog_meta\";a:6:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:4:\"tags\";i:5;s:9:\"read_more\";}s:15:\"blog_pagination\";s:7:\"regular\";s:15:\"archive_sidebar\";s:5:\"right\";s:14:\"archive_layout\";s:11:\"smallcircle\";s:12:\"archive_cols\";s:1:\"1\";s:20:\"archive_content_type\";s:7:\"excerpt\";s:12:\"archive_meta\";a:4:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:8:\"comments\";i:3;s:4:\"tags\";}s:18:\"archive_pagination\";s:7:\"regular\";s:14:\"search_sidebar\";s:5:\"right\";s:13:\"search_layout\";s:7:\"compact\";s:11:\"search_cols\";s:1:\"1\";s:19:\"search_content_type\";s:7:\"excerpt\";s:11:\"search_meta\";a:1:{i:0;s:4:\"date\";}s:17:\"search_pagination\";s:7:\"regular\";s:14:\"excerpt_length\";s:2:\"55\";s:21:\"shop_titlebar_content\";s:4:\"hide\";s:12:\"shop_sidebar\";s:5:\"right\";s:15:\"product_sidebar\";s:5:\"right\";s:18:\"shop_listing_style\";s:1:\"2\";s:12:\"shop_columns\";s:1:\"3\";s:19:\"product_related_qty\";s:1:\"3\";s:13:\"forum_sidebar\";s:5:\"right\";s:8:\"of_reset\";s:0:\"\";}}", "no");
INSERT INTO `wp_options` VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_tag_cloud", "a:2:{i:2;a:3:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "cron", "a:27:{i:1699199371;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1699199813;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1699202043;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1699202553;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1699202678;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1699202712;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1699202755;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1699203723;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1699209753;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699212793;a:1:{s:29:\"akismet_schedule_cron_recheck\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1699218000;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699220553;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1699230877;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1699253695;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699260509;a:1:{s:24:\"akismet_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699266600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1699271078;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699271813;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699274209;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699279758;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699284205;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699285363;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699701059;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1699773708;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1700236115;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1700495013;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("178889", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"8gIF4eCY+rDFZ;y,xjGz6xQSeCP,RnCKVAmBu+yff;t9\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 301.16000000000003,\n    \"siteNumFiles\": 19536,\n    \"siteDbSizeMB\": 8.4499999999999993,\n    \"siteDbNumTables\": 70\n}", "yes");
INSERT INTO `wp_options` VALUES("178890", "duplicator_notifications", "a:4:{s:6:\"update\";i:1699198909;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("178915", "woocommerce_attribute_lookup_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("178906", "_transient_timeout__woocommerce_upload_directory_status", "1699285353", "no");
INSERT INTO `wp_options` VALUES("178907", "_transient__woocommerce_upload_directory_status", "protected", "no");
INSERT INTO `wp_options` VALUES("178887", "_transient_timeout_us_update_theme_data_Zephyr", "1699209706", "no");
INSERT INTO `wp_options` VALUES("178888", "_transient_us_update_theme_data_Zephyr", "O:8:\"stdClass\":3:{s:7:\"success\";i:1;s:7:\"message\";a:0:{}s:4:\"data\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("156", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("330", "ewww_image_optimizer_jpegtran_copy", "1", "yes");
INSERT INTO `wp_options` VALUES("331", "ewww_image_optimizer_jpg_level", "10", "yes");
INSERT INTO `wp_options` VALUES("332", "ewww_image_optimizer_png_level", "10", "yes");
INSERT INTO `wp_options` VALUES("333", "ewww_image_optimizer_gif_level", "10", "yes");
INSERT INTO `wp_options` VALUES("334", "ewww_image_optimizer_pdf_level", "0", "yes");
INSERT INTO `wp_options` VALUES("206", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("115", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:19:\"info@parsplugin.com\";s:7:\"version\";s:5:\"6.3.2\";s:9:\"timestamp\";i:1697161637;}", "no");
INSERT INTO `wp_options` VALUES("187", "revslider-static-css", ".tp-caption.Twitter-Content a,\n.tp-caption.Twitter-Content a:visited { color: #0084B4 !important; }\n.tp-caption.Twitter-Content a:hover { color: #0084B4 !important; text-decoration: underline !important; }", "yes");
INSERT INTO `wp_options` VALUES("13488", "woocommerce_store_address", "", "yes");
INSERT INTO `wp_options` VALUES("13489", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_options` VALUES("13490", "woocommerce_store_city", "", "yes");
INSERT INTO `wp_options` VALUES("13491", "woocommerce_store_postcode", "", "yes");
INSERT INTO `wp_options` VALUES("713", "woocommerce_default_country", "IR:THR", "yes");
INSERT INTO `wp_options` VALUES("714", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("715", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("142", "theme_mods_twentysixteen", "a:2:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1545812993;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:26:\"woocommerce_price_filter-2\";i:1;s:38:\"woocommerce_recently_viewed_products-2\";i:2;s:11:\"tag_cloud-2\";}s:9:\"sidebar-3\";a:0:{}}}s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:30;}}", "yes");
INSERT INTO `wp_options` VALUES("143", "current_theme", "Zephyr", "yes");
INSERT INTO `wp_options` VALUES("144", "theme_mods_Zephyr", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:12:\"us_main_menu\";i:30;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1545812934;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"default_sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:12:\"shop_sidebar\";a:3:{i:0;s:26:\"woocommerce_price_filter-2\";i:1;s:38:\"woocommerce_recently_viewed_products-2\";i:2;s:11:\"tag_cloud-2\";}s:12:\"footer_first\";a:1:{i:0;s:10:\"us_login-2\";}s:13:\"footer_second\";a:1:{i:0;s:14:\"us_portfolio-2\";}s:12:\"footer_third\";a:1:{i:0;s:12:\"us_socials-2\";}s:13:\"footer_fourth\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("145", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("146", "us_db_version", "8.19", "yes");
INSERT INTO `wp_options` VALUES("147", "usof_options_Zephyr", "a:651:{s:13:\"canvas_layout\";s:4:\"wide\";s:13:\"color_body_bg\";s:7:\"#e0e0e0\";s:13:\"body_bg_image\";s:0:\"\";s:21:\"wrapper_body_bg_start\";s:0:\"\";s:18:\"body_bg_image_size\";s:7:\"initial\";s:20:\"body_bg_image_repeat\";s:6:\"repeat\";s:22:\"body_bg_image_position\";s:10:\"top center\";s:24:\"body_bg_image_attachment\";s:1:\"1\";s:19:\"wrapper_body_bg_end\";s:0:\"\";s:17:\"site_canvas_width\";s:6:\"1300px\";s:18:\"site_content_width\";s:6:\"1140px\";s:13:\"sidebar_width\";s:6:\"27.66%\";s:10:\"row_height\";s:6:\"medium\";s:17:\"row_height_custom\";s:5:\"5vmax\";s:18:\"text_bottom_indent\";s:6:\"1.5rem\";s:13:\"footer_reveal\";s:1:\"1\";s:21:\"disable_effects_width\";s:5:\"900px\";s:22:\"columns_stacking_width\";s:5:\"768px\";s:18:\"laptops_breakpoint\";s:6:\"1280px\";s:18:\"tablets_breakpoint\";s:6:\"1024px\";s:18:\"mobiles_breakpoint\";s:5:\"600px\";s:19:\"layout_head_message\";s:0:\"\";s:4:\"body\";a:5:{s:11:\"font-family\";s:25:\"iranyekanwebregular_FaNum\";s:9:\"font-size\";s:119:\"%7B%22default%22%3A%2214px%22%2C%22laptops%22%3A%2214px%22%2C%22tablets%22%3A%2214px%22%2C%22mobiles%22%3A%2215px%22%7D\";s:11:\"line-height\";s:119:\"%7B%22default%22%3A%2224px%22%2C%22laptops%22%3A%2224px%22%2C%22tablets%22%3A%2224px%22%2C%22mobiles%22%3A%2226px%22%7D\";s:11:\"font-weight\";i:400;s:16:\"bold-font-weight\";i:700;}s:2:\"h1\";a:11:{s:11:\"font-family\";s:25:\"iranyekanwebregular_FaNum\";s:9:\"font-size\";s:119:\"%7B%22default%22%3A%2238px%22%2C%22laptops%22%3A%2238px%22%2C%22tablets%22%3A%2238px%22%2C%22mobiles%22%3A%2230px%22%7D\";s:11:\"line-height\";d:1.3999999999999999;s:11:\"font-weight\";s:3:\"400\";s:16:\"bold-font-weight\";i:700;s:14:\"text-transform\";s:4:\"none\";s:10:\"font-style\";s:6:\"normal\";s:14:\"letter-spacing\";s:7:\"-0.01em\";s:13:\"margin-bottom\";s:6:\"1.5rem\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";a:0:{}}s:2:\"h2\";a:11:{s:11:\"font-family\";s:25:\"iranyekanwebregular_FaNum\";s:9:\"font-size\";s:119:\"%7B%22default%22%3A%2233px%22%2C%22laptops%22%3A%2233px%22%2C%22tablets%22%3A%2233px%22%2C%22mobiles%22%3A%2226px%22%7D\";s:11:\"line-height\";d:1.3999999999999999;s:11:\"font-weight\";s:21:\"var(--h1-font-weight)\";s:16:\"bold-font-weight\";s:26:\"var(--h1-bold-font-weight)\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:7:\"-0.05em\";s:13:\"margin-bottom\";s:6:\"1.5rem\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";a:0:{}}s:2:\"h3\";a:11:{s:11:\"font-family\";s:25:\"iranyekanwebregular_FaNum\";s:9:\"font-size\";s:119:\"%7B%22default%22%3A%2226px%22%2C%22laptops%22%3A%2226px%22%2C%22tablets%22%3A%2226px%22%2C%22mobiles%22%3A%2222px%22%7D\";s:11:\"line-height\";d:1.3999999999999999;s:11:\"font-weight\";s:3:\"100\";s:16:\"bold-font-weight\";s:26:\"var(--h1-bold-font-weight)\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:6:\"1.5rem\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";a:0:{}}s:2:\"h4\";a:11:{s:11:\"font-family\";s:25:\"iranyekanwebregular_FaNum\";s:9:\"font-size\";s:119:\"%7B%22default%22%3A%2224px%22%2C%22laptops%22%3A%2224px%22%2C%22tablets%22%3A%2224px%22%2C%22mobiles%22%3A%2220px%22%7D\";s:11:\"line-height\";s:4:\"1.38\";s:11:\"font-weight\";s:21:\"var(--h1-font-weight)\";s:16:\"bold-font-weight\";s:26:\"var(--h1-bold-font-weight)\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:6:\"1.5rem\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";a:0:{}}s:2:\"h5\";a:11:{s:11:\"font-family\";s:25:\"iranyekanwebregular_FaNum\";s:9:\"font-size\";s:119:\"%7B%22default%22%3A%2220px%22%2C%22laptops%22%3A%2220px%22%2C%22tablets%22%3A%2220px%22%2C%22mobiles%22%3A%2218px%22%7D\";s:11:\"line-height\";d:1.3999999999999999;s:11:\"font-weight\";s:21:\"var(--h1-font-weight)\";s:16:\"bold-font-weight\";s:26:\"var(--h1-bold-font-weight)\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:7:\"-0.04em\";s:13:\"margin-bottom\";s:6:\"1.5rem\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";a:0:{}}s:2:\"h6\";a:11:{s:11:\"font-family\";s:25:\"iranyekanwebregular_FaNum\";s:9:\"font-size\";s:119:\"%7B%22default%22%3A%2218px%22%2C%22laptops%22%3A%2218px%22%2C%22tablets%22%3A%2218px%22%2C%22mobiles%22%3A%2216px%22%7D\";s:11:\"line-height\";d:1.3999999999999999;s:11:\"font-weight\";s:21:\"var(--h1-font-weight)\";s:16:\"bold-font-weight\";s:26:\"var(--h1-bold-font-weight)\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:6:\"1.5rem\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";a:0:{}}s:23:\"typography_head_message\";s:0:\"\";s:14:\"h_typography_3\";s:0:\"\";s:11:\"custom_font\";a:1:{i:0;a:1:{s:11:\"font_family\";s:23:\"IRANSansWebFaNum_Light|\";}}s:14:\"h_typography_4\";s:0:\"\";s:14:\"uploaded_fonts\";s:0:\"\";s:14:\"h_typography_5\";s:0:\"\";s:12:\"font_display\";s:4:\"swap\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_mode_alert\";s:0:\"\";s:16:\"maintenance_page\";i:1146;s:15:\"maintenance_503\";s:1:\"0\";s:9:\"site_icon\";s:1:\"0\";s:10:\"dark_theme\";s:2:\"19\";s:9:\"preloader\";s:1:\"1\";s:15:\"preloader_image\";s:0:\"\";s:15:\"img_placeholder\";s:90:\"http://demo.parsplugin.com/upsolo/wp-content/plugins/us-core/assets/images/placeholder.svg\";s:13:\"ripple_effect\";b:1;s:15:\"rounded_corners\";i:1;s:15:\"links_underline\";i:0;s:22:\"keyboard_accessibility\";i:0;s:11:\"back_to_top\";s:1:\"1\";s:25:\"wrapper_back_to_top_start\";s:0:\"\";s:17:\"back_to_top_style\";s:0:\"\";s:16:\"back_to_top_icon\";s:26:\"material|keyboard_arrow_up\";s:15:\"back_to_top_pos\";s:5:\"right\";s:17:\"back_to_top_color\";s:15:\"rgba(0,0,0,0.3)\";s:19:\"back_to_top_display\";s:5:\"100vh\";s:23:\"wrapper_back_to_top_end\";s:0:\"\";s:22:\"smooth_scroll_duration\";s:6:\"1000ms\";s:13:\"cookie_notice\";i:0;s:20:\"wrapper_cookie_start\";s:0:\"\";s:14:\"cookie_message\";s:106:\"This website uses cookies to improve your experience. If you continue to use this site, you agree with it.\";s:14:\"cookie_privacy\";a:0:{}s:18:\"cookie_message_pos\";s:6:\"bottom\";s:16:\"cookie_btn_label\";s:2:\"Ok\";s:16:\"cookie_btn_style\";s:1:\"1\";s:18:\"wrapper_cookie_end\";s:0:\"\";s:23:\"block_third_party_files\";i:0;s:11:\"search_page\";s:7:\"default\";s:28:\"exclude_post_types_in_search\";a:0:{}s:8:\"page_404\";s:7:\"default\";s:10:\"h_defaults\";s:0:\"\";s:9:\"header_id\";i:6101;s:11:\"titlebar_id\";s:0:\"\";s:10:\"content_id\";s:0:\"\";s:10:\"sidebar_id\";s:0:\"\";s:11:\"sidebar_pos\";s:5:\"right\";s:9:\"footer_id\";i:5961;s:6:\"h_post\";s:0:\"\";s:14:\"header_post_id\";i:6101;s:16:\"titlebar_post_id\";s:0:\"\";s:15:\"content_post_id\";s:12:\"__defaults__\";s:15:\"sidebar_post_id\";s:15:\"default_sidebar\";s:16:\"sidebar_post_pos\";s:5:\"right\";s:14:\"footer_post_id\";s:12:\"__defaults__\";s:18:\"h_archive_defaults\";s:0:\"\";s:17:\"header_archive_id\";i:6101;s:19:\"titlebar_archive_id\";s:0:\"\";s:18:\"content_archive_id\";s:0:\"\";s:18:\"sidebar_archive_id\";s:15:\"default_sidebar\";s:19:\"sidebar_archive_pos\";s:5:\"right\";s:17:\"footer_archive_id\";s:0:\"\";s:14:\"h_tax_category\";s:0:\"\";s:22:\"header_tax_category_id\";s:12:\"__defaults__\";s:24:\"titlebar_tax_category_id\";s:12:\"__defaults__\";s:23:\"content_tax_category_id\";s:12:\"__defaults__\";s:23:\"sidebar_tax_category_id\";s:12:\"__defaults__\";s:24:\"sidebar_tax_category_pos\";s:5:\"right\";s:22:\"footer_tax_category_id\";s:12:\"__defaults__\";s:14:\"h_tax_post_tag\";s:0:\"\";s:22:\"header_tax_post_tag_id\";s:12:\"__defaults__\";s:24:\"titlebar_tax_post_tag_id\";s:12:\"__defaults__\";s:23:\"content_tax_post_tag_id\";s:12:\"__defaults__\";s:23:\"sidebar_tax_post_tag_id\";s:12:\"__defaults__\";s:24:\"sidebar_tax_post_tag_pos\";s:5:\"right\";s:22:\"footer_tax_post_tag_id\";s:12:\"__defaults__\";s:17:\"h_tax_post_format\";s:0:\"\";s:25:\"header_tax_post_format_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_post_format_id\";s:12:\"__defaults__\";s:26:\"content_tax_post_format_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_post_format_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_post_format_pos\";s:5:\"right\";s:25:\"footer_tax_post_format_id\";s:12:\"__defaults__\";s:9:\"h_authors\";s:0:\"\";s:16:\"header_author_id\";s:12:\"__defaults__\";s:18:\"titlebar_author_id\";s:12:\"__defaults__\";s:17:\"content_author_id\";s:12:\"__defaults__\";s:17:\"sidebar_author_id\";s:12:\"__defaults__\";s:18:\"sidebar_author_pos\";s:5:\"right\";s:16:\"footer_author_id\";s:12:\"__defaults__\";s:19:\"color_header_top_bg\";s:7:\"#6039a8\";s:21:\"color_header_top_text\";s:7:\"#c8b8e5\";s:27:\"color_header_top_text_hover\";s:7:\"#ffffff\";s:22:\"color_header_middle_bg\";s:7:\"#7049ba\";s:24:\"color_header_middle_text\";s:7:\"#ffffff\";s:30:\"color_header_middle_text_hover\";s:7:\"#ffffff\";s:29:\"color_header_transparent_text\";s:7:\"#ffffff\";s:35:\"color_header_transparent_text_hover\";s:7:\"#ffffff\";s:20:\"color_chrome_toolbar\";s:0:\"\";s:16:\"color_content_bg\";s:7:\"#ffffff\";s:20:\"color_content_bg_alt\";s:7:\"#f5f5f5\";s:20:\"color_content_border\";s:7:\"#e0e0e0\";s:21:\"color_content_heading\";s:7:\"#212121\";s:18:\"color_content_text\";s:7:\"#424242\";s:18:\"color_content_link\";s:7:\"#7049ba\";s:24:\"color_content_link_hover\";s:7:\"#ffb03a\";s:21:\"color_content_primary\";s:7:\"#7049ba\";s:23:\"color_content_secondary\";s:7:\"#ffb03a\";s:19:\"color_content_faded\";s:7:\"#9e9e9e\";s:21:\"color_content_overlay\";s:16:\"rgba(0,0,0,0.75)\";s:20:\"color_alt_content_bg\";s:7:\"#f5f5f5\";s:24:\"color_alt_content_bg_alt\";s:7:\"#ffffff\";s:24:\"color_alt_content_border\";s:7:\"#e0e0e0\";s:25:\"color_alt_content_heading\";s:7:\"#212121\";s:22:\"color_alt_content_text\";s:7:\"#424242\";s:22:\"color_alt_content_link\";s:7:\"#7049ba\";s:28:\"color_alt_content_link_hover\";s:7:\"#ffb03a\";s:25:\"color_alt_content_primary\";s:7:\"#7049ba\";s:27:\"color_alt_content_secondary\";s:7:\"#ffb03a\";s:23:\"color_alt_content_faded\";s:7:\"#9e9e9e\";s:25:\"color_alt_content_overlay\";s:53:\"linear-gradient(135deg,#e95095,rgba(233,80,149,0.75))\";s:15:\"color_footer_bg\";s:7:\"#111111\";s:19:\"color_footer_bg_alt\";s:7:\"#212121\";s:19:\"color_footer_border\";s:7:\"#333333\";s:20:\"color_footer_heading\";s:0:\"\";s:17:\"color_footer_text\";s:7:\"#757575\";s:17:\"color_footer_link\";s:7:\"#9e9e9e\";s:23:\"color_footer_link_hover\";s:7:\"#ffb03a\";s:18:\"color_subfooter_bg\";s:7:\"#212121\";s:22:\"color_subfooter_bg_alt\";s:7:\"#292929\";s:22:\"color_subfooter_border\";s:7:\"#333333\";s:23:\"color_subfooter_heading\";s:0:\"\";s:20:\"color_subfooter_text\";s:7:\"#757575\";s:20:\"color_subfooter_link\";s:7:\"#9e9e9e\";s:26:\"color_subfooter_link_hover\";s:7:\"#ffb03a\";s:12:\"style_scheme\";i:0;s:26:\"change_header_colors_start\";s:0:\"\";s:10:\"h_colors_1\";s:0:\"\";s:27:\"color_header_transparent_bg\";s:11:\"transparent\";s:24:\"change_header_colors_end\";s:0:\"\";s:30:\"change_header_alt_colors_start\";s:0:\"\";s:10:\"h_colors_2\";s:0:\"\";s:31:\"color_header_top_transparent_bg\";s:15:\"rgba(0,0,0,0.2)\";s:33:\"color_header_top_transparent_text\";s:22:\"rgba(255,255,255,0.66)\";s:39:\"color_header_top_transparent_text_hover\";s:4:\"#fff\";s:28:\"change_header_alt_colors_end\";s:0:\"\";s:27:\"change_content_colors_start\";s:0:\"\";s:10:\"h_colors_3\";s:0:\"\";s:25:\"change_content_colors_end\";s:0:\"\";s:31:\"change_alt_content_colors_start\";s:0:\"\";s:10:\"h_colors_4\";s:0:\"\";s:29:\"change_alt_content_colors_end\";s:0:\"\";s:26:\"change_footer_colors_start\";s:0:\"\";s:10:\"h_colors_6\";s:0:\"\";s:24:\"change_footer_colors_end\";s:0:\"\";s:29:\"change_subfooter_colors_start\";s:0:\"\";s:10:\"h_colors_5\";s:0:\"\";s:27:\"change_subfooter_colors_end\";s:0:\"\";s:7:\"buttons\";a:31:{i:0;a:22:{s:13:\"_migrated_key\";s:14:\"default_raised\";s:2:\"id\";i:1;s:4:\"name\";s:14:\"Default Button\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#7049ba\";s:14:\"color_bg_hover\";s:7:\"#ffb03a\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:1;a:22:{s:13:\"_migrated_key\";s:12:\"light_raised\";s:2:\"id\";i:2;s:4:\"name\";s:5:\"Light\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#e0e0e0\";s:14:\"color_bg_hover\";s:7:\"#e0e0e0\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#424242\";s:16:\"color_text_hover\";s:7:\"#424242\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:2;a:22:{s:13:\"_migrated_key\";s:13:\"grid_1_raised\";s:2:\"id\";i:3;s:4:\"name\";s:13:\"Grid Layout 1\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:4:\"#fff\";s:14:\"color_bg_hover\";s:4:\"#fff\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:4:\"#222\";s:16:\"color_text_hover\";s:4:\"#222\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:3;a:22:{s:13:\"_migrated_key\";s:13:\"grid_2_raised\";s:2:\"id\";i:4;s:4:\"name\";s:13:\"Grid Layout 2\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:4:\"#fff\";s:14:\"color_bg_hover\";s:4:\"#fff\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:4:\"#222\";s:16:\"color_text_hover\";s:4:\"#222\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:4;a:22:{s:13:\"_migrated_key\";s:13:\"grid_3_raised\";s:2:\"id\";i:5;s:4:\"name\";s:13:\"Grid Layout 3\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:4:\"#fff\";s:14:\"color_bg_hover\";s:4:\"#fff\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:4:\"#222\";s:16:\"color_text_hover\";s:4:\"#222\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:5;a:22:{s:13:\"_migrated_key\";s:13:\"grid_4_raised\";s:2:\"id\";i:6;s:4:\"name\";s:13:\"Grid Layout 4\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:4:\"#fff\";s:14:\"color_bg_hover\";s:4:\"#fff\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:4:\"#222\";s:16:\"color_text_hover\";s:4:\"#222\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:6;a:22:{s:13:\"_migrated_key\";s:12:\"white_raised\";s:2:\"id\";i:7;s:4:\"name\";s:5:\"White\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#ffffff\";s:14:\"color_bg_hover\";s:7:\"#ffffff\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#222222\";s:16:\"color_text_hover\";s:7:\"#222222\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:7;a:22:{s:13:\"_migrated_key\";s:15:\"loadmore_raised\";s:2:\"id\";i:8;s:4:\"name\";s:16:\"Load More Button\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#f5f5f5\";s:14:\"color_bg_hover\";s:7:\"#e0e0e0\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#424242\";s:16:\"color_text_hover\";s:7:\"#424242\";s:6:\"height\";s:5:\"1.2em\";s:5:\"width\";s:5:\"1.2em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"700\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:3:\"0em\";s:11:\"shadow_blur\";s:3:\"0em\";s:21:\"shadow_hover_offset_v\";s:3:\"0em\";s:17:\"shadow_hover_blur\";s:3:\"0em\";}i:8;a:22:{s:13:\"_migrated_key\";s:16:\"secondary_raised\";s:2:\"id\";i:9;s:4:\"name\";s:9:\"Secondary\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#ffb03a\";s:14:\"color_bg_hover\";s:7:\"#ffb03a\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:9;a:22:{s:13:\"_migrated_key\";s:14:\"primary_raised\";s:2:\"id\";i:10;s:4:\"name\";s:7:\"Primary\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#7049ba\";s:14:\"color_bg_hover\";s:7:\"#7049ba\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:10;a:22:{s:13:\"_migrated_key\";s:15:\"contrast_raised\";s:2:\"id\";i:11;s:4:\"name\";s:8:\"Contrast\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#424242\";s:14:\"color_bg_hover\";s:7:\"#424242\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:11;a:22:{s:13:\"_migrated_key\";s:15:\"white_alt2_flat\";s:2:\"id\";i:12;s:4:\"name\";s:22:\"White Alternate 2 Flat\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:22:\"rgba(255,255,255,0.12)\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:3:\"0em\";s:11:\"shadow_blur\";s:3:\"0em\";s:21:\"shadow_hover_offset_v\";s:3:\"0em\";s:17:\"shadow_hover_blur\";s:3:\"0em\";}i:12;a:22:{s:13:\"_migrated_key\";s:10:\"white_flat\";s:2:\"id\";i:13;s:4:\"name\";s:10:\"White Flat\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:7:\"#f5f5f5\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:3:\"0em\";s:11:\"shadow_blur\";s:3:\"0em\";s:21:\"shadow_hover_offset_v\";s:3:\"0em\";s:17:\"shadow_hover_blur\";s:3:\"0em\";}i:13;a:22:{s:13:\"_migrated_key\";s:12:\"black_raised\";s:2:\"id\";i:14;s:4:\"name\";s:5:\"Black\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#000000\";s:14:\"color_bg_hover\";s:7:\"#000000\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:14;a:22:{s:13:\"_migrated_key\";s:12:\"primary_flat\";s:2:\"id\";i:15;s:4:\"name\";s:12:\"Primary Flat\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:7:\"#f5f5f5\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#7049ba\";s:16:\"color_text_hover\";s:7:\"#7049ba\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:3:\"0em\";s:11:\"shadow_blur\";s:3:\"0em\";s:21:\"shadow_hover_offset_v\";s:3:\"0em\";s:17:\"shadow_hover_blur\";s:3:\"0em\";}i:15;a:22:{s:13:\"_migrated_key\";s:14:\"secondary_flat\";s:2:\"id\";i:16;s:4:\"name\";s:14:\"Secondary Flat\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:7:\"#f5f5f5\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffb03a\";s:16:\"color_text_hover\";s:7:\"#ffb03a\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:3:\"0em\";s:11:\"shadow_blur\";s:3:\"0em\";s:21:\"shadow_hover_offset_v\";s:3:\"0em\";s:17:\"shadow_hover_blur\";s:3:\"0em\";}i:16;a:22:{s:13:\"_migrated_key\";s:13:\"contrast_flat\";s:2:\"id\";i:17;s:4:\"name\";s:13:\"Contrast Flat\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:7:\"#f5f5f5\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"inherit\";s:16:\"color_text_hover\";s:7:\"inherit\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:3:\"0em\";s:11:\"shadow_blur\";s:3:\"0em\";s:21:\"shadow_hover_offset_v\";s:3:\"0em\";s:17:\"shadow_hover_blur\";s:3:\"0em\";}i:17;a:22:{s:13:\"_migrated_key\";s:10:\"light_flat\";s:2:\"id\";i:18;s:4:\"name\";s:10:\"Light Flat\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:7:\"#f5f5f5\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#9e9e9e\";s:16:\"color_text_hover\";s:7:\"#9e9e9e\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:3:\"0em\";s:11:\"shadow_blur\";s:3:\"0em\";s:21:\"shadow_hover_offset_v\";s:3:\"0em\";s:17:\"shadow_hover_blur\";s:3:\"0em\";}i:18;a:22:{s:13:\"_migrated_key\";s:10:\"black_flat\";s:2:\"id\";i:19;s:4:\"name\";s:10:\"Black Flat\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:7:\"#f5f5f5\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#000000\";s:16:\"color_text_hover\";s:7:\"#000000\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:3:\"0em\";s:11:\"shadow_blur\";s:3:\"0em\";s:21:\"shadow_hover_offset_v\";s:3:\"0em\";s:17:\"shadow_hover_blur\";s:3:\"0em\";}i:19;a:22:{s:13:\"_migrated_key\";s:27:\"custom_42d69b_ffeb8c_raised\";s:2:\"id\";i:20;s:4:\"name\";s:8:\"Custom 1\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#42d69b\";s:14:\"color_bg_hover\";s:7:\"#42d69b\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffeb8c\";s:16:\"color_text_hover\";s:7:\"#ffeb8c\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:20;a:22:{s:13:\"_migrated_key\";s:27:\"custom_ffe772_725439_raised\";s:2:\"id\";i:21;s:4:\"name\";s:8:\"Custom 2\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#ffe772\";s:14:\"color_bg_hover\";s:7:\"#ffe772\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#725439\";s:16:\"color_text_hover\";s:7:\"#725439\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:21;a:22:{s:13:\"_migrated_key\";s:27:\"custom_21aad3_ffffff_raised\";s:2:\"id\";i:22;s:4:\"name\";s:8:\"Custom 3\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#21aad3\";s:14:\"color_bg_hover\";s:7:\"#21aad3\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:22;a:22:{s:13:\"_migrated_key\";s:27:\"custom_f43838_ffebce_raised\";s:2:\"id\";i:23;s:4:\"name\";s:8:\"Custom 4\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#f43838\";s:14:\"color_bg_hover\";s:7:\"#f43838\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffebce\";s:16:\"color_text_hover\";s:7:\"#ffebce\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:23;a:22:{s:13:\"_migrated_key\";s:27:\"custom_e1eded_1e73be_raised\";s:2:\"id\";i:24;s:4:\"name\";s:8:\"Custom 5\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#e1eded\";s:14:\"color_bg_hover\";s:7:\"#e1eded\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#1e73be\";s:16:\"color_text_hover\";s:7:\"#1e73be\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:24;a:22:{s:13:\"_migrated_key\";s:27:\"custom_2f7c08_bfe874_raised\";s:2:\"id\";i:25;s:4:\"name\";s:8:\"Custom 6\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#2f7c08\";s:14:\"color_bg_hover\";s:7:\"#2f7c08\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#bfe874\";s:16:\"color_text_hover\";s:7:\"#bfe874\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:5:\"0.1em\";s:11:\"shadow_blur\";s:5:\"0.2em\";s:21:\"shadow_hover_offset_v\";s:6:\"0.25em\";s:17:\"shadow_hover_blur\";s:5:\"0.5em\";}i:25;a:22:{s:13:\"_migrated_key\";s:19:\"custom__99d369_flat\";s:2:\"id\";i:26;s:4:\"name\";s:13:\"Custom 7 Flat\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:7:\"#f5f5f5\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#99d369\";s:16:\"color_text_hover\";s:7:\"#99d369\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:3:\"0em\";s:11:\"shadow_blur\";s:3:\"0em\";s:21:\"shadow_hover_offset_v\";s:3:\"0em\";s:17:\"shadow_hover_blur\";s:3:\"0em\";}i:26;a:22:{s:13:\"_migrated_key\";s:25:\"custom_edf3f9_23cde0_flat\";s:2:\"id\";i:27;s:4:\"name\";s:13:\"Custom 8 Flat\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#edf3f9\";s:14:\"color_bg_hover\";s:7:\"#edf3f9\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#23cde0\";s:16:\"color_text_hover\";s:7:\"#23cde0\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:3:\"0em\";s:11:\"shadow_blur\";s:3:\"0em\";s:21:\"shadow_hover_offset_v\";s:3:\"0em\";s:17:\"shadow_hover_blur\";s:3:\"0em\";}i:27;a:22:{s:13:\"_migrated_key\";s:19:\"custom__d33bbc_flat\";s:2:\"id\";i:28;s:4:\"name\";s:13:\"Custom 9 Flat\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:7:\"#f5f5f5\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#d33bbc\";s:16:\"color_text_hover\";s:7:\"#d33bbc\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:3:\"0em\";s:11:\"shadow_blur\";s:3:\"0em\";s:21:\"shadow_hover_offset_v\";s:3:\"0em\";s:17:\"shadow_hover_blur\";s:3:\"0em\";}i:28;a:22:{s:13:\"_migrated_key\";s:25:\"custom_fff8e0_ffb200_flat\";s:2:\"id\";i:29;s:4:\"name\";s:14:\"Custom 10 Flat\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#fff8e0\";s:14:\"color_bg_hover\";s:7:\"#fff8e0\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffb200\";s:16:\"color_text_hover\";s:7:\"#ffb200\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:3:\"0em\";s:11:\"shadow_blur\";s:3:\"0em\";s:21:\"shadow_hover_offset_v\";s:3:\"0em\";s:17:\"shadow_hover_blur\";s:3:\"0em\";}i:29;a:22:{s:13:\"_migrated_key\";s:19:\"custom__6761cc_flat\";s:2:\"id\";i:30;s:4:\"name\";s:14:\"Custom 11 Flat\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:7:\"#f5f5f5\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#6761cc\";s:16:\"color_text_hover\";s:7:\"#6761cc\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:3:\"0em\";s:11:\"shadow_blur\";s:3:\"0em\";s:21:\"shadow_hover_offset_v\";s:3:\"0em\";s:17:\"shadow_hover_blur\";s:3:\"0em\";}i:30;a:22:{s:13:\"_migrated_key\";s:25:\"custom_7edd8e_ffffff_flat\";s:2:\"id\";i:31;s:4:\"name\";s:14:\"Custom 12 Flat\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#7edd8e\";s:14:\"color_bg_hover\";s:7:\"#7edd8e\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:6:\"height\";s:5:\"0.8em\";s:5:\"width\";s:5:\"1.5em\";s:4:\"font\";s:4:\"body\";s:10:\"text_style\";a:1:{i:0;s:9:\"uppercase\";}s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"2px\";s:15:\"shadow_offset_v\";s:3:\"0em\";s:11:\"shadow_blur\";s:3:\"0em\";s:21:\"shadow_hover_offset_v\";s:3:\"0em\";s:17:\"shadow_hover_blur\";s:3:\"0em\";}}s:12:\"input_fields\";a:1:{i:0;a:26:{s:8:\"color_bg\";s:11:\"transparent\";s:14:\"color_bg_focus\";s:0:\"\";s:12:\"color_border\";s:7:\"#e0e0e0\";s:18:\"color_border_focus\";s:7:\"#7049ba\";s:10:\"color_text\";s:7:\"inherit\";s:16:\"color_text_focus\";s:0:\"\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_focus\";s:7:\"#7049ba\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"1px\";s:12:\"shadow_inset\";a:1:{i:0;s:1:\"1\";}s:21:\"shadow_focus_offset_h\";s:3:\"0px\";s:21:\"shadow_focus_offset_v\";s:3:\"0px\";s:17:\"shadow_focus_blur\";s:3:\"0px\";s:19:\"shadow_focus_spread\";s:3:\"1px\";s:18:\"shadow_focus_inset\";a:1:{i:0;s:1:\"1\";}s:4:\"font\";s:0:\"\";s:9:\"font_size\";s:4:\"1rem\";s:11:\"font_weight\";s:3:\"400\";s:14:\"letter_spacing\";s:3:\"0em\";s:6:\"height\";s:3:\"3em\";s:7:\"padding\";s:3:\"1em\";s:13:\"border_radius\";s:5:\"0.2em\";s:12:\"border_width\";s:3:\"1px\";}}s:26:\"portfolio_breadcrumbs_page\";s:0:\"\";s:14:\"portfolio_slug\";s:9:\"portfolio\";s:23:\"portfolio_category_slug\";s:18:\"portfolio_category\";s:18:\"portfolio_tag_slug\";s:13:\"portfolio_tag\";s:16:\"portfolio_rename\";i:0;s:20:\"portfolio_label_name\";s:21:\"نمونه کارها\";s:29:\"portfolio_label_singular_name\";s:30:\"برگه نمونه کارها\";s:23:\"portfolio_label_add_new\";s:43:\"افزودن برگه نمونه کارها\";s:25:\"portfolio_label_edit_item\";s:43:\"ویرایش برگه نمونه کارها\";s:24:\"portfolio_label_category\";s:37:\"دسته های نمونه کارها\";s:19:\"portfolio_label_tag\";s:39:\"برچسب های نمونه کارها\";s:6:\"h_more\";s:0:\"\";s:12:\"shop_catalog\";s:1:\"0\";s:22:\"shop_primary_btn_style\";s:1:\"1\";s:24:\"shop_secondary_btn_style\";s:1:\"2\";s:15:\"product_gallery\";s:6:\"slider\";s:29:\"wrapper_product_gallery_start\";s:0:\"\";s:26:\"product_gallery_thumbs_pos\";s:6:\"bottom\";s:27:\"product_gallery_thumbs_cols\";s:1:\"4\";s:28:\"product_gallery_thumbs_width\";s:4:\"6rem\";s:26:\"product_gallery_thumbs_gap\";s:3:\"0px\";s:23:\"product_gallery_options\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"zoom\";i:2;s:8:\"lightbox\";}s:27:\"wrapper_product_gallery_end\";s:0:\"\";s:9:\"h_product\";s:0:\"\";s:17:\"header_product_id\";s:12:\"__defaults__\";s:19:\"titlebar_product_id\";s:0:\"\";s:18:\"content_product_id\";s:0:\"\";s:18:\"sidebar_product_id\";s:12:\"__defaults__\";s:19:\"sidebar_product_pos\";s:5:\"right\";s:17:\"footer_product_id\";s:12:\"__defaults__\";s:6:\"h_shop\";s:0:\"\";s:14:\"header_shop_id\";i:6101;s:16:\"titlebar_shop_id\";s:0:\"\";s:15:\"content_shop_id\";s:0:\"\";s:18:\"wrapper_shop_start\";s:0:\"\";s:12:\"shop_columns\";s:1:\"4\";s:16:\"wrapper_shop_end\";s:0:\"\";s:15:\"sidebar_shop_id\";s:12:\"__defaults__\";s:16:\"sidebar_shop_pos\";s:5:\"right\";s:14:\"footer_shop_id\";s:12:\"__defaults__\";s:13:\"h_shop_search\";s:0:\"\";s:21:\"header_shop_search_id\";s:12:\"__defaults__\";s:23:\"titlebar_shop_search_id\";s:12:\"__defaults__\";s:22:\"content_shop_search_id\";s:12:\"__defaults__\";s:22:\"sidebar_shop_search_id\";s:12:\"__defaults__\";s:23:\"sidebar_shop_search_pos\";s:5:\"right\";s:21:\"footer_shop_search_id\";s:12:\"__defaults__\";s:7:\"h_order\";s:0:\"\";s:16:\"content_order_id\";s:0:\"\";s:6:\"h_cart\";s:0:\"\";s:9:\"shop_cart\";s:7:\"compact\";s:19:\"product_related_qty\";s:1:\"4\";s:15:\"used_icons_info\";s:0:\"\";s:9:\"h_icons_2\";s:0:\"\";s:9:\"icons_fas\";s:7:\"default\";s:21:\"icons_fas_custom_font\";s:0:\"\";s:9:\"icons_far\";s:7:\"default\";s:21:\"icons_far_custom_font\";s:0:\"\";s:9:\"icons_fab\";s:7:\"default\";s:21:\"icons_fab_custom_font\";s:0:\"\";s:14:\"icons_material\";s:7:\"default\";s:26:\"icons_material_custom_font\";s:0:\"\";s:18:\"fallback_icon_font\";i:1;s:13:\"img_size_info\";s:0:\"\";s:13:\"h_image_sizes\";s:0:\"\";s:8:\"img_size\";a:4:{i:0;a:3:{s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"400\";s:4:\"crop\";a:1:{i:0;s:4:\"crop\";}}i:1;a:3:{s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:4:\"crop\";a:1:{i:0;s:4:\"crop\";}}i:2;a:3:{s:5:\"width\";s:3:\"600\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";a:0:{}}i:3;a:3:{s:5:\"width\";s:3:\"768\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";a:0:{}}}s:14:\"h_more_options\";s:0:\"\";s:24:\"big_image_size_threshold\";s:6:\"2560px\";s:20:\"delete_unused_images\";i:0;s:12:\"h_advanced_1\";s:0:\"\";s:12:\"live_builder\";i:1;s:17:\"section_templates\";i:1;s:19:\"grid_columns_layout\";i:0;s:12:\"block_editor\";i:1;s:23:\"enable_sidebar_titlebar\";b:1;s:31:\"enable_page_blocks_for_sidebars\";i:0;s:16:\"enable_portfolio\";s:1:\"1\";s:19:\"enable_testimonials\";s:1:\"1\";s:14:\"media_category\";s:0:\"\";s:10:\"og_enabled\";s:1:\"1\";s:13:\"schema_markup\";i:1;s:28:\"templates_access_for_editors\";i:0;s:12:\"h_advanced_2\";s:0:\"\";s:13:\"gmaps_api_key\";s:0:\"\";s:15:\"facebook_app_id\";s:0:\"\";s:22:\"grid_filter_url_prefix\";s:0:\"\";s:21:\"grid_order_url_prefix\";s:0:\"\";s:12:\"h_advanced_3\";s:0:\"\";s:17:\"keep_url_protocol\";b:1;s:22:\"disable_jquery_migrate\";s:1:\"1\";s:13:\"jquery_footer\";s:1:\"1\";s:12:\"ajax_load_js\";s:1:\"1\";s:16:\"disable_extra_vc\";s:1:\"0\";s:15:\"optimize_assets\";s:1:\"0\";s:21:\"optimize_assets_alert\";s:0:\"\";s:21:\"optimize_assets_start\";s:0:\"\";s:6:\"assets\";a:53:{s:12:\"font-awesome\";i:1;s:9:\"actionbox\";i:1;s:9:\"animation\";i:1;s:7:\"buttons\";i:1;s:8:\"carousel\";i:1;s:6:\"charts\";i:1;s:7:\"columns\";i:1;s:8:\"comments\";i:1;s:8:\"contacts\";i:1;s:7:\"counter\";i:1;s:8:\"dropdown\";i:1;s:5:\"forms\";i:1;s:7:\"flipbox\";i:1;s:5:\"gmaps\";i:1;s:4:\"grid\";i:1;s:11:\"grid_filter\";i:1;s:14:\"grid_templates\";i:1;s:15:\"grid_pagination\";i:1;s:10:\"grid_popup\";i:1;s:6:\"header\";i:1;s:12:\"hor_parallax\";i:1;s:8:\"hwrapper\";i:1;s:7:\"iconbox\";i:1;s:5:\"image\";i:1;s:13:\"image_gallery\";i:1;s:12:\"image_slider\";i:1;s:7:\"ibanner\";i:0;s:5:\"itext\";i:1;s:14:\"magnific_popup\";i:1;s:4:\"menu\";i:1;s:7:\"message\";i:1;s:5:\"lmaps\";i:1;s:8:\"scroller\";i:1;s:6:\"person\";i:1;s:9:\"preloader\";i:1;s:5:\"print\";i:1;s:5:\"popup\";i:1;s:13:\"post_elements\";i:1;s:15:\"post_navigation\";i:1;s:7:\"pricing\";i:1;s:7:\"progbar\";i:1;s:6:\"scroll\";i:1;s:6:\"search\";i:1;s:9:\"separator\";i:1;s:7:\"sharing\";i:1;s:11:\"simple_menu\";i:1;s:7:\"socials\";i:1;s:4:\"tabs\";i:1;s:4:\"text\";i:1;s:5:\"video\";i:1;s:12:\"ver_parallax\";i:1;s:8:\"vwrapper\";i:1;s:10:\"wp_widgets\";i:1;}s:19:\"optimize_assets_end\";s:0:\"\";s:18:\"include_gfonts_css\";b:0;s:10:\"custom_css\";s:550:\"\n\n.wpb_text_column:not(:last-child) { margin-bottom: 1.5rem; } /* migration 5.6 fix */ \n.woocommerce .comment-form-rating .stars {\n    float: left;\n    direction: ltr;\n}\n\n\n.w-form-row::before, .w-form-row > i{\n    right: 0 !important;\n}\n\n.w-form-row-label{\n    \n    right: 0 !important;\n}\n\n\n.widget_search .w-form button {\n    left: 0px !important;\n    right: 258px !important;\n}\n\n\n/*responsive for serach button...*/\n\n@media screen and (max-width: 480px) {\n\n.widget_search .w-form button {\n    left: 0px !important;\n    right: 289px !important;\n}\n\n}\";s:16:\"custom_html_head\";s:0:\"\";s:11:\"custom_html\";s:0:\"\";s:8:\"of_reset\";s:0:\"\";s:9:\"of_backup\";s:0:\"\";s:11:\"of_transfer\";s:0:\"\";s:11:\"white_label\";i:0;s:22:\"white_label_theme_name\";s:0:\"\";s:28:\"white_label_theme_screenshot\";s:0:\"\";s:22:\"white_label_theme_icon\";s:0:\"\";s:22:\"white_label_login_icon\";s:0:\"\";s:11:\"h_portfolio\";s:0:\"\";s:19:\"header_portfolio_id\";i:6101;s:21:\"titlebar_portfolio_id\";i:6162;s:20:\"content_portfolio_id\";s:12:\"__defaults__\";s:20:\"sidebar_portfolio_id\";s:12:\"__defaults__\";s:21:\"sidebar_portfolio_pos\";s:5:\"right\";s:19:\"footer_portfolio_id\";s:12:\"__defaults__\";s:27:\"h_tax_us_portfolio_category\";s:0:\"\";s:35:\"header_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:37:\"titlebar_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:36:\"content_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:36:\"sidebar_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:37:\"sidebar_tax_us_portfolio_category_pos\";s:5:\"right\";s:35:\"footer_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:22:\"h_tax_us_portfolio_tag\";s:0:\"\";s:30:\"header_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:32:\"titlebar_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:31:\"content_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:31:\"sidebar_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:32:\"sidebar_tax_us_portfolio_tag_pos\";s:5:\"right\";s:30:\"footer_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:16:\"h1_letterspacing\";s:7:\"-0.01em\";s:16:\"h2_letterspacing\";s:7:\"-0.05em\";s:16:\"h3_letterspacing\";s:3:\"0em\";s:16:\"h4_letterspacing\";s:3:\"0em\";s:16:\"h5_letterspacing\";s:7:\"-0.04em\";s:16:\"h6_letterspacing\";s:3:\"0em\";s:17:\"h_tax_product_cat\";s:0:\"\";s:25:\"header_tax_product_cat_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_product_cat_id\";s:12:\"__defaults__\";s:26:\"content_tax_product_cat_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_product_cat_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_product_cat_pos\";s:5:\"right\";s:25:\"footer_tax_product_cat_id\";s:12:\"__defaults__\";s:17:\"h_tax_product_tag\";s:0:\"\";s:25:\"header_tax_product_tag_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_product_tag_id\";s:12:\"__defaults__\";s:26:\"content_tax_product_tag_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_product_tag_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_product_tag_pos\";s:5:\"right\";s:25:\"footer_tax_product_tag_id\";s:12:\"__defaults__\";s:28:\"h_tax_product_shipping_class\";s:0:\"\";s:36:\"header_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:38:\"titlebar_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:37:\"content_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:37:\"sidebar_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:38:\"sidebar_tax_product_shipping_class_pos\";s:5:\"right\";s:36:\"footer_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:17:\"responsive_layout\";s:1:\"1\";s:11:\"color_style\";s:1:\"1\";s:16:\"schema_faqs_page\";s:0:\"\";s:9:\"lazy_load\";b:0;s:17:\"use_modern_jquery\";b:0;s:22:\"color_header_bottom_bg\";s:7:\"#6039a8\";s:24:\"color_header_bottom_text\";s:7:\"#c8b8e5\";s:30:\"color_header_bottom_text_hover\";s:7:\"#ffffff\";s:22:\"color_header_search_bg\";s:7:\"#7049ba\";s:24:\"color_header_search_text\";s:7:\"#ffffff\";s:32:\"color_menu_transparent_active_bg\";s:11:\"transparent\";s:34:\"color_menu_transparent_active_text\";s:7:\"#ffc670\";s:19:\"color_menu_hover_bg\";s:7:\"#6039a8\";s:21:\"color_menu_hover_text\";s:7:\"#ffffff\";s:20:\"color_menu_active_bg\";s:0:\"\";s:22:\"color_menu_active_text\";s:7:\"#ffc670\";s:20:\"color_menu_button_bg\";s:7:\"#ffffff\";s:22:\"color_menu_button_text\";s:7:\"#7049ba\";s:26:\"color_menu_button_hover_bg\";s:7:\"#ffffff\";s:28:\"color_menu_button_hover_text\";s:7:\"#7049ba\";s:13:\"color_drop_bg\";s:7:\"#ffffff\";s:15:\"color_drop_text\";s:7:\"#212121\";s:19:\"color_drop_hover_bg\";s:7:\"#eeeeee\";s:21:\"color_drop_hover_text\";s:7:\"#212121\";s:20:\"color_drop_active_bg\";s:7:\"#f7f7f7\";s:22:\"color_drop_active_text\";s:7:\"#7049ba\";s:15:\"paste_from_demo\";i:1;s:14:\"lazyload_fonts\";s:1:\"1\";s:15:\"remove_protocol\";b:1;s:13:\"content_width\";s:3:\"68%\";s:13:\"header_layout\";s:10:\"extended_1\";s:13:\"header_sticky\";a:3:{i:0;s:7:\"default\";i:1;s:7:\"tablets\";i:2;s:7:\"mobiles\";}s:18:\"header_transparent\";s:1:\"0\";s:16:\"header_fullwidth\";s:1:\"0\";s:17:\"header_top_height\";s:4:\"40px\";s:24:\"header_top_sticky_height\";s:3:\"0px\";s:20:\"header_middle_height\";s:5:\"100px\";s:27:\"header_middle_sticky_height\";s:4:\"50px\";s:20:\"header_bottom_height\";s:4:\"40px\";s:27:\"header_bottom_sticky_height\";s:4:\"40px\";s:17:\"header_main_width\";s:5:\"300px\";s:22:\"header_invert_logo_pos\";s:1:\"0\";s:18:\"header_search_show\";s:1:\"1\";s:20:\"header_search_layout\";s:10:\"fullscreen\";s:20:\"header_contacts_show\";s:1:\"1\";s:21:\"header_contacts_phone\";s:10:\"0912000000\";s:21:\"header_contacts_email\";s:13:\"info@test.com\";s:9:\"logo_type\";s:4:\"text\";s:9:\"logo_text\";s:27:\"<strong>زفایر</strong>\";s:14:\"logo_font_size\";s:4:\"27px\";s:22:\"logo_font_size_tablets\";s:4:\"24px\";s:22:\"logo_font_size_mobiles\";s:4:\"20px\";s:10:\"logo_image\";s:0:\"\";s:11:\"logo_height\";s:4:\"30px\";s:18:\"logo_height_sticky\";s:4:\"30px\";s:19:\"logo_height_tablets\";s:4:\"30px\";s:19:\"logo_height_mobiles\";s:4:\"30px\";s:11:\"menu_source\";s:18:\"zephyr-header-menu\";s:13:\"menu_fontsize\";s:4:\"16px\";s:12:\"menu_indents\";s:4:\"40px\";s:11:\"menu_height\";s:1:\"0\";s:17:\"menu_sub_fontsize\";s:4:\"15px\";s:17:\"menu_mobile_width\";s:6:\"1000px\";s:19:\"menu_togglable_type\";s:1:\"1\";s:11:\"font_subset\";s:5:\"latin\";s:18:\"shop_listing_style\";s:6:\"modern\";s:11:\"shop_layout\";s:12:\"blog_compact\";s:14:\"shop_items_gap\";s:6:\"1.5rem\";s:20:\"shop_overriding_link\";s:4:\"none\";s:16:\"shop_popup_width\";s:0:\"\";s:17:\"shop_popup_arrows\";b:1;s:13:\"shop_elements\";a:3:{i:0;s:10:\"shop_title\";i:1;s:13:\"product_title\";i:2;s:11:\"breadcrumbs\";}s:16:\"header_search_id\";s:12:\"__defaults__\";s:18:\"titlebar_search_id\";s:12:\"__defaults__\";s:17:\"sidebar_search_id\";s:15:\"default_sidebar\";s:18:\"sidebar_search_pos\";s:5:\"right\";s:16:\"footer_search_id\";s:12:\"__defaults__\";s:14:\"header_blog_id\";s:12:\"__defaults__\";s:16:\"titlebar_blog_id\";s:0:\"\";s:15:\"sidebar_blog_id\";s:15:\"default_sidebar\";s:16:\"sidebar_blog_pos\";s:5:\"right\";s:14:\"footer_blog_id\";s:12:\"__defaults__\";s:19:\"heading_font_family\";s:24:\"IRANSansWeb_FaNum_Light|\";s:18:\"portfolio_comments\";s:1:\"0\";s:13:\"portfolio_nav\";s:1:\"1\";s:20:\"portfolio_nav_invert\";s:1:\"1\";s:22:\"portfolio_nav_category\";s:1:\"0\";s:12:\"cpt_as_posts\";a:0:{}s:19:\"post_preview_layout\";s:5:\"basic\";s:21:\"post_preview_img_size\";s:5:\"large\";s:9:\"post_meta\";a:5:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:4:\"tags\";}s:12:\"post_sharing\";s:1:\"1\";s:22:\"post_sharing_providers\";a:7:{i:0;s:5:\"email\";i:1;s:8:\"facebook\";i:2;s:7:\"twitter\";i:3;s:5:\"gplus\";i:4;s:8:\"linkedin\";i:5;s:9:\"pinterest\";i:6;s:2:\"vk\";}s:17:\"post_sharing_type\";s:5:\"solid\";s:15:\"post_author_box\";s:1:\"1\";s:8:\"post_nav\";s:1:\"1\";s:15:\"post_nav_layout\";s:7:\"default\";s:15:\"post_nav_invert\";s:1:\"0\";s:17:\"post_nav_category\";s:1:\"0\";s:12:\"post_related\";s:1:\"1\";s:17:\"post_related_type\";s:3:\"tag\";s:18:\"post_related_title\";s:13:\"Related Posts\";s:20:\"post_related_orderby\";s:4:\"rand\";s:19:\"post_related_layout\";i:6160;s:21:\"post_related_img_size\";s:7:\"default\";s:21:\"post_related_quantity\";s:1:\"3\";s:17:\"post_related_cols\";i:3;s:22:\"post_related_items_gap\";s:4:\"1rem\";s:11:\"blog_layout\";i:6157;s:13:\"blog_img_size\";s:7:\"default\";s:9:\"blog_type\";s:4:\"grid\";s:9:\"blog_cols\";s:1:\"1\";s:14:\"blog_items_gap\";s:4:\"5rem\";s:15:\"blog_pagination\";s:7:\"regular\";s:25:\"blog_pagination_btn_style\";s:1:\"1\";s:14:\"archive_layout\";i:6158;s:16:\"archive_img_size\";s:7:\"default\";s:12:\"archive_type\";s:4:\"grid\";s:12:\"archive_cols\";s:1:\"2\";s:17:\"archive_items_gap\";s:6:\"1.5rem\";s:18:\"archive_pagination\";s:4:\"ajax\";s:28:\"archive_pagination_btn_style\";s:1:\"1\";s:13:\"search_layout\";i:6159;s:15:\"search_img_size\";s:7:\"default\";s:11:\"search_type\";s:4:\"grid\";s:11:\"search_cols\";s:1:\"1\";s:16:\"search_items_gap\";s:4:\"1rem\";s:17:\"search_pagination\";s:4:\"ajax\";s:27:\"search_pagination_btn_style\";s:1:\"1\";s:23:\"blog_breakpoint_1_width\";s:4:\"1200\";s:22:\"blog_breakpoint_1_cols\";s:1:\"3\";s:23:\"blog_breakpoint_2_width\";s:3:\"900\";s:22:\"blog_breakpoint_2_cols\";s:1:\"2\";s:23:\"blog_breakpoint_3_width\";s:3:\"600\";s:22:\"blog_breakpoint_3_cols\";s:1:\"1\";s:25:\"header_portfolio_defaults\";i:1;s:20:\"header_post_defaults\";i:1;s:23:\"header_archive_defaults\";i:1;s:20:\"header_shop_defaults\";i:1;s:29:\"shop_remove_title_breadcrumbs\";i:0;s:23:\"header_product_defaults\";i:1;s:25:\"custom_post_types_support\";a:0:{}s:27:\"header_contacts_custom_icon\";s:4:\"lock\";s:27:\"header_contacts_custom_text\";s:80:\"<a href=\'http://zephyr.zephyr.co/pages/login-page//\'>ورود کاربران</a>\";s:19:\"header_socials_show\";s:1:\"1\";s:20:\"header_socials_email\";s:0:\"\";s:23:\"header_socials_facebook\";s:1:\"#\";s:22:\"header_socials_twitter\";s:1:\"#\";s:21:\"header_socials_google\";s:0:\"\";s:23:\"header_socials_linkedin\";s:0:\"\";s:22:\"header_socials_youtube\";s:0:\"\";s:20:\"header_socials_vimeo\";s:0:\"\";s:21:\"header_socials_flickr\";s:0:\"\";s:22:\"header_socials_behance\";s:1:\"#\";s:24:\"header_socials_instagram\";s:1:\"#\";s:19:\"header_socials_xing\";s:0:\"\";s:24:\"header_socials_pinterest\";s:0:\"\";s:20:\"header_socials_skype\";s:0:\"\";s:23:\"header_socials_whatsapp\";s:0:\"\";s:23:\"header_socials_dribbble\";s:0:\"\";s:17:\"header_socials_vk\";s:1:\"#\";s:21:\"header_socials_tumblr\";s:0:\"\";s:25:\"header_socials_soundcloud\";s:1:\"#\";s:21:\"header_socials_twitch\";s:0:\"\";s:19:\"header_socials_yelp\";s:0:\"\";s:25:\"header_socials_deviantart\";s:1:\"#\";s:25:\"header_socials_foursquare\";s:0:\"\";s:21:\"header_socials_github\";s:0:\"\";s:28:\"header_socials_odnoklassniki\";s:0:\"\";s:21:\"header_socials_s500px\";s:0:\"\";s:20:\"header_socials_houzz\";s:0:\"\";s:21:\"header_socials_medium\";s:0:\"\";s:26:\"header_socials_tripadvisor\";s:0:\"\";s:18:\"header_socials_rss\";s:0:\"\";s:25:\"header_socials_custom_url\";s:0:\"\";s:26:\"header_socials_custom_icon\";s:0:\"\";s:20:\"header_language_show\";s:1:\"0\";s:22:\"header_language_source\";s:3:\"own\";s:17:\"header_link_title\";s:7:\"English\";s:15:\"header_link_qty\";s:1:\"3\";s:19:\"header_link_1_label\";s:7:\"Spanish\";s:17:\"header_link_1_url\";s:1:\"#\";s:19:\"header_link_2_label\";s:6:\"German\";s:17:\"header_link_2_url\";s:1:\"#\";s:19:\"header_link_3_label\";s:7:\"Russian\";s:17:\"header_link_3_url\";s:1:\"#\";s:19:\"header_link_4_label\";s:0:\"\";s:17:\"header_link_4_url\";s:0:\"\";s:19:\"header_link_5_label\";s:0:\"\";s:17:\"header_link_5_url\";s:0:\"\";s:19:\"header_link_6_label\";s:0:\"\";s:17:\"header_link_6_url\";s:0:\"\";s:19:\"header_link_7_label\";s:0:\"\";s:17:\"header_link_7_url\";s:0:\"\";s:19:\"header_link_8_label\";s:0:\"\";s:17:\"header_link_8_url\";s:0:\"\";s:19:\"header_link_9_label\";s:0:\"\";s:17:\"header_link_9_url\";s:0:\"\";s:22:\"logo_image_transparent\";s:0:\"\";s:18:\"logo_image_tablets\";s:0:\"\";s:18:\"logo_image_mobiles\";s:0:\"\";s:8:\"titlebar\";s:1:\"1\";s:13:\"titlebar_size\";s:5:\"large\";s:14:\"titlebar_color\";s:9:\"alternate\";s:20:\"titlebar_breadcrumbs\";s:1:\"1\";s:17:\"titlebar_bg_image\";s:0:\"\";s:16:\"titlebar_bg_size\";s:5:\"cover\";s:18:\"titlebar_bg_repeat\";s:6:\"repeat\";s:20:\"titlebar_bg_position\";s:13:\"center center\";s:20:\"titlebar_bg_parallax\";s:4:\"none\";s:22:\"titlebar_overlay_color\";s:0:\"\";s:18:\"titlebar_portfolio\";s:1:\"1\";s:27:\"titlebar_portfolio_defaults\";s:1:\"0\";s:23:\"titlebar_portfolio_size\";s:5:\"large\";s:24:\"titlebar_portfolio_color\";s:9:\"alternate\";s:30:\"titlebar_portfolio_breadcrumbs\";s:1:\"0\";s:27:\"titlebar_portfolio_bg_image\";s:0:\"\";s:26:\"titlebar_portfolio_bg_size\";s:5:\"cover\";s:28:\"titlebar_portfolio_bg_repeat\";s:6:\"repeat\";s:30:\"titlebar_portfolio_bg_position\";s:13:\"center center\";s:30:\"titlebar_portfolio_bg_parallax\";s:4:\"none\";s:32:\"titlebar_portfolio_overlay_color\";s:0:\"\";s:13:\"titlebar_post\";s:1:\"0\";s:22:\"titlebar_post_defaults\";s:1:\"0\";s:19:\"titlebar_post_title\";s:4:\"Blog\";s:18:\"titlebar_post_size\";s:6:\"medium\";s:19:\"titlebar_post_color\";s:9:\"alternate\";s:25:\"titlebar_post_breadcrumbs\";s:1:\"0\";s:22:\"titlebar_post_bg_image\";s:0:\"\";s:21:\"titlebar_post_bg_size\";s:5:\"cover\";s:23:\"titlebar_post_bg_repeat\";s:6:\"repeat\";s:25:\"titlebar_post_bg_position\";s:13:\"center center\";s:25:\"titlebar_post_bg_parallax\";s:4:\"none\";s:27:\"titlebar_post_overlay_color\";s:0:\"\";s:13:\"titlebar_shop\";s:1:\"0\";s:22:\"titlebar_shop_defaults\";s:1:\"1\";s:18:\"titlebar_shop_size\";s:6:\"medium\";s:19:\"titlebar_shop_color\";s:9:\"alternate\";s:25:\"titlebar_shop_breadcrumbs\";s:1:\"0\";s:22:\"titlebar_shop_bg_image\";s:0:\"\";s:21:\"titlebar_shop_bg_size\";s:5:\"cover\";s:23:\"titlebar_shop_bg_repeat\";s:6:\"repeat\";s:25:\"titlebar_shop_bg_position\";s:13:\"center center\";s:25:\"titlebar_shop_bg_parallax\";s:4:\"none\";s:27:\"titlebar_shop_overlay_color\";s:0:\"\";s:7:\"sidebar\";s:1:\"0\";s:17:\"portfolio_sidebar\";s:1:\"0\";s:20:\"portfolio_sidebar_id\";s:15:\"default_sidebar\";s:21:\"portfolio_sidebar_pos\";s:5:\"right\";s:12:\"post_sidebar\";s:1:\"1\";s:15:\"post_sidebar_id\";s:15:\"default_sidebar\";s:16:\"post_sidebar_pos\";s:5:\"right\";s:12:\"blog_sidebar\";s:1:\"1\";s:15:\"blog_sidebar_id\";s:15:\"default_sidebar\";s:16:\"blog_sidebar_pos\";s:5:\"right\";s:15:\"archive_sidebar\";s:1:\"1\";s:18:\"archive_sidebar_id\";s:15:\"default_sidebar\";s:19:\"archive_sidebar_pos\";s:5:\"right\";s:14:\"search_sidebar\";s:1:\"1\";s:17:\"search_sidebar_id\";s:15:\"default_sidebar\";s:18:\"search_sidebar_pos\";s:5:\"right\";s:12:\"shop_sidebar\";s:1:\"0\";s:15:\"shop_sidebar_id\";s:12:\"shop_sidebar\";s:16:\"shop_sidebar_pos\";s:5:\"right\";s:15:\"product_sidebar\";s:1:\"0\";s:18:\"product_sidebar_id\";s:12:\"shop_sidebar\";s:19:\"product_sidebar_pos\";s:5:\"right\";s:13:\"event_sidebar\";i:0;s:16:\"event_sidebar_id\";s:15:\"default_sidebar\";s:17:\"event_sidebar_pos\";s:5:\"right\";s:17:\"forum_sidebar_pos\";s:5:\"right\";s:25:\"footer_portfolio_defaults\";s:1:\"1\";s:20:\"footer_post_defaults\";s:1:\"1\";s:23:\"footer_archive_defaults\";s:1:\"1\";s:20:\"footer_shop_defaults\";s:1:\"1\";s:23:\"footer_product_defaults\";s:1:\"1\";s:16:\"menu_font_family\";s:23:\"IRANSansWebFaNum_Light|\";s:28:\"portfolio_breakpoint_1_width\";s:4:\"1200\";s:27:\"portfolio_breakpoint_1_cols\";s:1:\"3\";s:28:\"portfolio_breakpoint_2_width\";s:3:\"900\";s:27:\"portfolio_breakpoint_2_cols\";s:1:\"2\";s:28:\"portfolio_breakpoint_3_width\";s:3:\"600\";s:27:\"portfolio_breakpoint_3_cols\";s:1:\"1\";s:17:\"blog_content_type\";s:7:\"excerpt\";s:9:\"blog_meta\";a:6:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:4:\"tags\";i:5;s:9:\"read_more\";}s:20:\"archive_content_type\";s:7:\"excerpt\";s:12:\"archive_meta\";a:6:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:4:\"tags\";i:5;s:9:\"read_more\";}s:19:\"search_content_type\";s:7:\"excerpt\";s:11:\"search_meta\";a:1:{i:0;s:4:\"date\";}s:14:\"excerpt_length\";s:2:\"40\";s:12:\"page_sidebar\";s:4:\"none\";s:13:\"footer_layout\";s:7:\"compact\";s:24:\"header_scroll_breakpoint\";s:3:\"100\";s:20:\"menu_dropdown_effect\";s:7:\"mdesign\";s:19:\"portfolio_sided_nav\";s:1:\"1\";s:27:\"portfolio_prevnext_category\";s:1:\"0\";s:13:\"forum_sidebar\";s:5:\"right\";s:16:\"forum_sidebar_id\";s:15:\"default_sidebar\";s:24:\"titlebar_tribe_events_id\";s:0:\"\";s:33:\"header_tax_wp_pattern_category_id\";s:12:\"__defaults__\";s:35:\"titlebar_tax_wp_pattern_category_id\";s:12:\"__defaults__\";s:34:\"content_tax_wp_pattern_category_id\";s:12:\"__defaults__\";s:34:\"sidebar_tax_wp_pattern_category_id\";s:12:\"__defaults__\";s:33:\"footer_tax_wp_pattern_category_id\";s:12:\"__defaults__\";}", "yes");
INSERT INTO `wp_options` VALUES("148", "widget_us_login", "a:2:{i:2;a:5:{s:5:\"title\";s:8:\"ورود\";s:8:\"register\";s:1:\"#\";s:8:\"lostpass\";s:1:\"#\";s:14:\"login_redirect\";s:1:\"#\";s:15:\"logout_redirect\";s:1:\"#\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("149", "widget_us_socials", "a:2:{i:2;a:44:{s:5:\"title\";s:0:\"\";s:4:\"size\";s:4:\"20px\";s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:5:\"brand\";s:5:\"shape\";s:6:\"circle\";s:5:\"hover\";s:4:\"fade\";s:5:\"email\";s:1:\"#\";s:8:\"facebook\";s:1:\"#\";s:7:\"twitter\";s:1:\"#\";s:6:\"google\";s:1:\"#\";s:8:\"linkedin\";s:1:\"#\";s:7:\"youtube\";s:1:\"#\";s:5:\"vimeo\";s:1:\"#\";s:6:\"flickr\";s:1:\"#\";s:7:\"behance\";s:0:\"\";s:9:\"instagram\";s:0:\"\";s:4:\"xing\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:5:\"skype\";s:0:\"\";s:8:\"whatsapp\";s:0:\"\";s:8:\"dribbble\";s:0:\"\";s:2:\"vk\";s:0:\"\";s:6:\"tumblr\";s:0:\"\";s:10:\"soundcloud\";s:0:\"\";s:6:\"twitch\";s:0:\"\";s:4:\"yelp\";s:0:\"\";s:10:\"deviantart\";s:0:\"\";s:10:\"foursquare\";s:0:\"\";s:6:\"github\";s:0:\"\";s:13:\"odnoklassniki\";s:0:\"\";s:6:\"s500px\";s:0:\"\";s:5:\"houzz\";s:0:\"\";s:6:\"medium\";s:0:\"\";s:11:\"tripadvisor\";s:0:\"\";s:3:\"rss\";s:0:\"\";s:7:\"discord\";s:0:\"\";s:4:\"imdb\";s:0:\"\";s:6:\"reddit\";s:0:\"\";s:8:\"telegram\";s:0:\"\";s:6:\"wechat\";s:0:\"\";s:11:\"custom_link\";s:0:\"\";s:12:\"custom_title\";s:0:\"\";s:11:\"custom_icon\";s:0:\"\";s:12:\"custom_color\";s:7:\"#1abc9c\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("150", "widget_us_portfolio", "a:2:{i:2;a:5:{s:5:\"title\";s:0:\"\";s:7:\"columns\";s:1:\"3\";s:5:\"items\";s:1:\"6\";s:7:\"orderby\";s:4:\"date\";s:6:\"layout\";s:17:\"portfolio_compact\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("154", "rewrite_rules", "a:219:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?us_portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?us_portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio_category/([^/]+)/embed/?$\";s:54:\"index.php?us_portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:61:\"index.php?us_portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:43:\"index.php?us_portfolio_category=$matches[1]\";s:54:\"portfolio_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?us_portfolio_tag=$matches[1]&feed=$matches[2]\";s:49:\"portfolio_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?us_portfolio_tag=$matches[1]&feed=$matches[2]\";s:30:\"portfolio_tag/([^/]+)/embed/?$\";s:49:\"index.php?us_portfolio_tag=$matches[1]&embed=true\";s:42:\"portfolio_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?us_portfolio_tag=$matches[1]&paged=$matches[2]\";s:24:\"portfolio_tag/([^/]+)/?$\";s:38:\"index.php?us_portfolio_tag=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:45:\"index.php?us_portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:39:\"index.php?us_portfolio=$matches[1]&tb=1\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?us_portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?us_portfolio=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?us_portfolio=$matches[1]&wc-api=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?us_portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"us_testimonial_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:62:\"index.php?us_testimonial_category=$matches[1]&feed=$matches[2]\";s:59:\"us_testimonial_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:62:\"index.php?us_testimonial_category=$matches[1]&feed=$matches[2]\";s:40:\"us_testimonial_category/([^/]+)/embed/?$\";s:56:\"index.php?us_testimonial_category=$matches[1]&embed=true\";s:52:\"us_testimonial_category/([^/]+)/page/?([0-9]{1,})/?$\";s:63:\"index.php?us_testimonial_category=$matches[1]&paged=$matches[2]\";s:34:\"us_testimonial_category/([^/]+)/?$\";s:45:\"index.php?us_testimonial_category=$matches[1]\";s:60:\"wp_pattern_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?wp_pattern_category=$matches[1]&feed=$matches[2]\";s:55:\"wp_pattern_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?wp_pattern_category=$matches[1]&feed=$matches[2]\";s:36:\"wp_pattern_category/([^/]+)/embed/?$\";s:52:\"index.php?wp_pattern_category=$matches[1]&embed=true\";s:48:\"wp_pattern_category/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?wp_pattern_category=$matches[1]&paged=$matches[2]\";s:30:\"wp_pattern_category/([^/]+)/?$\";s:41:\"index.php?wp_pattern_category=$matches[1]\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:38:\"vc_grid_item/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?vc_grid_item=$matches[1]&wc-api=$matches[3]\";s:44:\"vc_grid_item/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"vc_grid_item/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1546&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("174402", "woocommerce_custom_orders_table_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("170693", "woocommerce_feature_product_block_editor_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("140915", "woocommerce_attribute_lookup_direct_updates", "no", "yes");
INSERT INTO `wp_options` VALUES("14584", "us_theme_options_css", ":root{--color-header-middle-bg:#7049ba;--color-header-middle-bg-grad:#7049ba;--color-header-middle-text:#ffffff;--color-header-middle-text-hover:#ffffff;--color-header-transparent-bg:transparent;--color-header-transparent-bg-grad:transparent;--color-header-transparent-text:#ffffff;--color-header-transparent-text-hover:#ffffff;--color-header-top-bg:#6039a8;--color-header-top-bg-grad:#6039a8;--color-header-top-text:#c8b8e5;--color-header-top-text-hover:#ffffff;--color-header-top-transparent-bg:rgba(0,0,0,0.2);--color-header-top-transparent-bg-grad:rgba(0,0,0,0.2);--color-header-top-transparent-text:rgba(255,255,255,0.66);--color-header-top-transparent-text-hover:#fff;--color-content-bg:#ffffff;--color-content-bg-grad:#ffffff;--color-content-bg-alt:#f5f5f5;--color-content-bg-alt-grad:#f5f5f5;--color-content-border:#e0e0e0;--color-content-heading:#212121;--color-content-heading-grad:#212121;--color-content-text:#424242;--color-content-link:#7049ba;--color-content-link-hover:#ffb03a;--color-content-primary:#7049ba;--color-content-primary-grad:#7049ba;--color-content-secondary:#ffb03a;--color-content-secondary-grad:#ffb03a;--color-content-faded:#9e9e9e;--color-content-overlay:rgba(0,0,0,0.75);--color-content-overlay-grad:rgba(0,0,0,0.75);--color-alt-content-bg:#f5f5f5;--color-alt-content-bg-grad:#f5f5f5;--color-alt-content-bg-alt:#ffffff;--color-alt-content-bg-alt-grad:#ffffff;--color-alt-content-border:#e0e0e0;--color-alt-content-heading:#212121;--color-alt-content-heading-grad:#212121;--color-alt-content-text:#424242;--color-alt-content-link:#7049ba;--color-alt-content-link-hover:#ffb03a;--color-alt-content-primary:#7049ba;--color-alt-content-primary-grad:#7049ba;--color-alt-content-secondary:#ffb03a;--color-alt-content-secondary-grad:#ffb03a;--color-alt-content-faded:#9e9e9e;--color-alt-content-overlay:#e95095;--color-alt-content-overlay-grad:linear-gradient(135deg,#e95095,rgba(233,80,149,0.75));--color-footer-bg:#111111;--color-footer-bg-grad:#111111;--color-footer-bg-alt:#212121;--color-footer-bg-alt-grad:#212121;--color-footer-border:#333333;--color-footer-text:#757575;--color-footer-link:#9e9e9e;--color-footer-link-hover:#ffb03a;--color-subfooter-bg:#212121;--color-subfooter-bg-grad:#212121;--color-subfooter-bg-alt:#292929;--color-subfooter-bg-alt-grad:#292929;--color-subfooter-border:#333333;--color-subfooter-text:#757575;--color-subfooter-link:#9e9e9e;--color-subfooter-link-hover:#ffb03a;--color-content-primary-faded:rgba(112,73,186,0.15);--box-shadow:0 5px 15px rgba(0,0,0,.15);--box-shadow-up:0 -5px 15px rgba(0,0,0,.15);--site-canvas-width:1300px;--site-content-width:1140px;--site-sidebar-width:27.66%;--text-block-margin-bottom:1.5rem;--inputs-font-size:1rem;--inputs-height:3em;--inputs-padding:1em;--inputs-border-width:1px;--inputs-text-color:inherit}@media (prefers-color-scheme:dark){:root{--color-header-middle-bg:#59524c;--color-header-middle-bg-grad:#59524c;--color-header-middle-text:#fff;--color-header-middle-text-hover:#c7a589;--color-chrome-toolbar:#46403c;--color-chrome-toolbar-grad:#46403c;--color-header-top-bg:#46403c;--color-header-top-bg-grad:#46403c;--color-header-top-text:#cdcbc9;--color-header-top-text-hover:#c7a589;--color-header-transparent-text:#fff;--color-header-transparent-text-hover:#fff;--color-content-bg:#f2f1f0;--color-content-bg-grad:#f2f1f0;--color-content-bg-alt:#fff;--color-content-bg-alt-grad:#fff;--color-content-border:#e0dedc;--color-content-heading:#46403c;--color-content-heading-grad:#46403c;--color-content-text:#46403c;--color-content-link:#c7a589;--color-content-link-hover:#9ea476;--color-content-primary:#c7a589;--color-content-primary-grad:#c7a589;--color-content-primary-faded:rgba(199,165,137,0.15);--color-content-secondary:#9ea476;--color-content-secondary-grad:#9ea476;--color-content-faded:#979699;--color-content-overlay:rgba(70,64,60,0.85);--color-content-overlay-grad:rgba(70,64,60,0.85);--color-alt-content-bg:#e5e3e1;--color-alt-content-bg-grad:#e5e3e1;--color-alt-content-bg-alt:#f2f1f0;--color-alt-content-bg-alt-grad:#f2f1f0;--color-alt-content-border:#d6d4d2;--color-alt-content-heading:#46403c;--color-alt-content-heading-grad:#46403c;--color-alt-content-text:#46403c;--color-alt-content-link:#c7a589;--color-alt-content-link-hover:#9ea476;--color-alt-content-primary:#c7a589;--color-alt-content-primary-grad:#c7a589;--color-alt-content-secondary:#9ea476;--color-alt-content-secondary-grad:#9ea476;--color-alt-content-faded:#979699;--color-alt-content-overlay:rgba(199,165,137,0.85);--color-alt-content-overlay-grad:rgba(199,165,137,0.85);--color-subfooter-bg:#59524c;--color-subfooter-bg-grad:#59524c;--color-subfooter-bg-alt:#46403c;--color-subfooter-bg-alt-grad:#46403c;--color-subfooter-border:#69625c;--color-subfooter-text:#b1a9a2;--color-subfooter-link:#ddd6d0;--color-subfooter-link-hover:#fff;--color-footer-bg:#46403c;--color-footer-bg-grad:#46403c;--color-footer-bg-alt:#59524c;--color-footer-bg-alt-grad:#59524c;--color-footer-border:#69625c;--color-footer-text:#98918a;--color-footer-link:#b1a9a2;--color-footer-link-hover:#fff}}.has-content-primary-color{color:var(--color-content-primary)}.has-content-primary-background-color{background:var(--color-content-primary-grad)}.has-content-secondary-color{color:var(--color-content-secondary)}.has-content-secondary-background-color{background:var(--color-content-secondary-grad)}.has-content-heading-color{color:var(--color-content-heading)}.has-content-heading-background-color{background:var(--color-content-heading-grad)}.has-content-text-color{color:var(--color-content-text)}.has-content-text-background-color{background:var(--color-content-text-grad)}.has-content-faded-color{color:var(--color-content-faded)}.has-content-faded-background-color{background:var(--color-content-faded-grad)}.has-content-border-color{color:var(--color-content-border)}.has-content-border-background-color{background:var(--color-content-border-grad)}.has-content-bg-alt-color{color:var(--color-content-bg-alt)}.has-content-bg-alt-background-color{background:var(--color-content-bg-alt-grad)}.has-content-bg-color{color:var(--color-content-bg)}.has-content-bg-background-color{background:var(--color-content-bg-grad)}:root{--font-family:iranyekanwebregular_FaNum;--font-size:14px;--line-height:24px;--font-weight:400;--bold-font-weight:700;--h1-font-family:iranyekanwebregular_FaNum;--h1-font-size:38px;--h1-line-height:1.4;--h1-font-weight:400;--h1-bold-font-weight:700;--h1-text-transform:none;--h1-font-style:normal;--h1-letter-spacing:-0.01em;--h1-margin-bottom:1.5rem;--h2-font-family:iranyekanwebregular_FaNum;--h2-font-size:33px;--h2-line-height:1.4;--h2-font-weight:var(--h1-font-weight);--h2-bold-font-weight:var(--h1-bold-font-weight);--h2-text-transform:var(--h1-text-transform);--h2-font-style:var(--h1-font-style);--h2-letter-spacing:-0.05em;--h2-margin-bottom:1.5rem;--h3-font-family:iranyekanwebregular_FaNum;--h3-font-size:26px;--h3-line-height:1.4;--h3-font-weight:100;--h3-bold-font-weight:var(--h1-bold-font-weight);--h3-text-transform:var(--h1-text-transform);--h3-font-style:var(--h1-font-style);--h3-letter-spacing:0em;--h3-margin-bottom:1.5rem;--h4-font-family:iranyekanwebregular_FaNum;--h4-font-size:24px;--h4-line-height:1.38;--h4-font-weight:var(--h1-font-weight);--h4-bold-font-weight:var(--h1-bold-font-weight);--h4-text-transform:var(--h1-text-transform);--h4-font-style:var(--h1-font-style);--h4-letter-spacing:0em;--h4-margin-bottom:1.5rem;--h5-font-family:iranyekanwebregular_FaNum;--h5-font-size:20px;--h5-line-height:1.4;--h5-font-weight:var(--h1-font-weight);--h5-bold-font-weight:var(--h1-bold-font-weight);--h5-text-transform:var(--h1-text-transform);--h5-font-style:var(--h1-font-style);--h5-letter-spacing:-0.04em;--h5-margin-bottom:1.5rem;--h6-font-family:iranyekanwebregular_FaNum;--h6-font-size:18px;--h6-line-height:1.4;--h6-font-weight:var(--h1-font-weight);--h6-bold-font-weight:var(--h1-bold-font-weight);--h6-text-transform:var(--h1-text-transform);--h6-font-style:var(--h1-font-style);--h6-letter-spacing:0em;--h6-margin-bottom:1.5rem}@media (max-width:600px){:root{--font-size:15px;--line-height:26px;--h1-font-size:30px;--h2-font-size:26px;--h3-font-size:22px;--h4-font-size:20px;--h5-font-size:18px;--h6-font-size:16px}}h1{font-family:var(--h1-font-family,inherit);font-weight:var(--h1-font-weight,inherit);font-size:var(--h1-font-size,inherit);font-style:var(--h1-font-style,inherit);line-height:var(--h1-line-height,1.4);letter-spacing:var(--h1-letter-spacing,inherit);text-transform:var(--h1-text-transform,inherit);margin-bottom:var(--h1-margin-bottom,1.5rem)}h1>strong{font-weight:var(--h1-bold-font-weight,bold)}h2{font-family:var(--h2-font-family,inherit);font-weight:var(--h2-font-weight,inherit);font-size:var(--h2-font-size,inherit);font-style:var(--h2-font-style,inherit);line-height:var(--h2-line-height,1.4);letter-spacing:var(--h2-letter-spacing,inherit);text-transform:var(--h2-text-transform,inherit);margin-bottom:var(--h2-margin-bottom,1.5rem)}h2>strong{font-weight:var(--h2-bold-font-weight,bold)}h3{font-family:var(--h3-font-family,inherit);font-weight:var(--h3-font-weight,inherit);font-size:var(--h3-font-size,inherit);font-style:var(--h3-font-style,inherit);line-height:var(--h3-line-height,1.4);letter-spacing:var(--h3-letter-spacing,inherit);text-transform:var(--h3-text-transform,inherit);margin-bottom:var(--h3-margin-bottom,1.5rem)}h3>strong{font-weight:var(--h3-bold-font-weight,bold)}h4{font-family:var(--h4-font-family,inherit);font-weight:var(--h4-font-weight,inherit);font-size:var(--h4-font-size,inherit);font-style:var(--h4-font-style,inherit);line-height:var(--h4-line-height,1.4);letter-spacing:var(--h4-letter-spacing,inherit);text-transform:var(--h4-text-transform,inherit);margin-bottom:var(--h4-margin-bottom,1.5rem)}h4>strong{font-weight:var(--h4-bold-font-weight,bold)}h5{font-family:var(--h5-font-family,inherit);font-weight:var(--h5-font-weight,inherit);font-size:var(--h5-font-size,inherit);font-style:var(--h5-font-style,inherit);line-height:var(--h5-line-height,1.4);letter-spacing:var(--h5-letter-spacing,inherit);text-transform:var(--h5-text-transform,inherit);margin-bottom:var(--h5-margin-bottom,1.5rem)}h5>strong{font-weight:var(--h5-bold-font-weight,bold)}h6{font-family:var(--h6-font-family,inherit);font-weight:var(--h6-font-weight,inherit);font-size:var(--h6-font-size,inherit);font-style:var(--h6-font-style,inherit);line-height:var(--h6-line-height,1.4);letter-spacing:var(--h6-letter-spacing,inherit);text-transform:var(--h6-text-transform,inherit);margin-bottom:var(--h6-margin-bottom,1.5rem)}h6>strong{font-weight:var(--h6-bold-font-weight,bold)}body{background:#e0e0e0}@media (max-width:1210px){.l-main .aligncenter{max-width:calc(100vw - 5rem)}}@media (min-width:768px){body.footer_reveal .l-canvas{position:relative;z-index:1}body.footer_reveal .l-footer{position:fixed;bottom:0}body.footer_reveal .l-canvas.type_boxed~.l-footer{left:0;right:0}}@media (min-width:1281px){body.usb_preview .hide_on_default{opacity:0.25!important}.vc_hidden-lg,body:not(.usb_preview) .hide_on_default{display:none!important}.default_align_left{text-align:left;justify-content:flex-start}.default_align_right{text-align:right;justify-content:flex-end}.default_align_center{text-align:center;justify-content:center}.default_align_justify{justify-content:space-between}.w-hwrapper>.default_align_justify,.default_align_justify>.w-btn{width:100%}}@media (min-width:1025px) and (max-width:1280px){body.usb_preview .hide_on_laptops{opacity:0.25!important}.vc_hidden-md,body:not(.usb_preview) .hide_on_laptops{display:none!important}.laptops_align_left{text-align:left;justify-content:flex-start}.laptops_align_right{text-align:right;justify-content:flex-end}.laptops_align_center{text-align:center;justify-content:center}.laptops_align_justify{justify-content:space-between}.w-hwrapper>.laptops_align_justify,.laptops_align_justify>.w-btn{width:100%}.g-cols.via_grid[style*=\"--laptops-gap\"]{grid-gap:var(--laptops-gap,3rem)}}@media (min-width:601px) and (max-width:1024px){body.usb_preview .hide_on_tablets{opacity:0.25!important}.vc_hidden-sm,body:not(.usb_preview) .hide_on_tablets{display:none!important}.tablets_align_left{text-align:left;justify-content:flex-start}.tablets_align_right{text-align:right;justify-content:flex-end}.tablets_align_center{text-align:center;justify-content:center}.tablets_align_justify{justify-content:space-between}.w-hwrapper>.tablets_align_justify,.tablets_align_justify>.w-btn{width:100%}.g-cols.via_grid[style*=\"--tablets-gap\"]{grid-gap:var(--tablets-gap,3rem)}}@media (max-width:600px){body.usb_preview .hide_on_mobiles{opacity:0.25!important}.vc_hidden-xs,body:not(.usb_preview) .hide_on_mobiles{display:none!important}.mobiles_align_left{text-align:left;justify-content:flex-start}.mobiles_align_right{text-align:right;justify-content:flex-end}.mobiles_align_center{text-align:center;justify-content:center}.mobiles_align_justify{justify-content:space-between}.w-hwrapper>.mobiles_align_justify,.mobiles_align_justify>.w-btn{width:100%}.w-hwrapper.stack_on_mobiles{display:block}.w-hwrapper.stack_on_mobiles>*{display:block;margin:0 0 var(--hwrapper-gap,1.2rem)}.w-hwrapper.stack_on_mobiles>:last-child{margin-bottom:0}.g-cols.via_grid[style*=\"--mobiles-gap\"]{grid-gap:var(--mobiles-gap,1.5rem)}}@media (max-width:600px){.g-cols.type_default>div[class*=\"vc_col-xs-\"]{margin-top:1rem;margin-bottom:1rem}.g-cols>div:not([class*=\"vc_col-xs-\"]){width:100%;margin:0 0 1.5rem}.g-cols.reversed>div:last-of-type{order:-1}.g-cols.type_boxes>div,.g-cols.reversed>div:first-child,.g-cols:not(.reversed)>div:last-child,.g-cols>div.has_bg_color{margin-bottom:0}.vc_col-xs-1{width:8.3333%}.vc_col-xs-2{width:16.6666%}.vc_col-xs-1\\/5{width:20%}.vc_col-xs-3{width:25%}.vc_col-xs-4{width:33.3333%}.vc_col-xs-2\\/5{width:40%}.vc_col-xs-5{width:41.6666%}.vc_col-xs-6{width:50%}.vc_col-xs-7{width:58.3333%}.vc_col-xs-3\\/5{width:60%}.vc_col-xs-8{width:66.6666%}.vc_col-xs-9{width:75%}.vc_col-xs-4\\/5{width:80%}.vc_col-xs-10{width:83.3333%}.vc_col-xs-11{width:91.6666%}.vc_col-xs-12{width:100%}.vc_col-xs-offset-0{margin-right:0}.vc_col-xs-offset-1{margin-right:8.3333%}.vc_col-xs-offset-2{margin-right:16.6666%}.vc_col-xs-offset-1\\/5{margin-right:20%}.vc_col-xs-offset-3{margin-right:25%}.vc_col-xs-offset-4{margin-right:33.3333%}.vc_col-xs-offset-2\\/5{margin-right:40%}.vc_col-xs-offset-5{margin-right:41.6666%}.vc_col-xs-offset-6{margin-right:50%}.vc_col-xs-offset-7{margin-right:58.3333%}.vc_col-xs-offset-3\\/5{margin-right:60%}.vc_col-xs-offset-8{margin-right:66.6666%}.vc_col-xs-offset-9{margin-right:75%}.vc_col-xs-offset-4\\/5{margin-right:80%}.vc_col-xs-offset-10{margin-right:83.3333%}.vc_col-xs-offset-11{margin-right:91.6666%}.vc_col-xs-offset-12{margin-right:100%}}@media (min-width:601px){.vc_col-sm-1{width:8.3333%}.vc_col-sm-2{width:16.6666%}.vc_col-sm-1\\/5{width:20%}.vc_col-sm-3{width:25%}.vc_col-sm-4{width:33.3333%}.vc_col-sm-2\\/5{width:40%}.vc_col-sm-5{width:41.6666%}.vc_col-sm-6{width:50%}.vc_col-sm-7{width:58.3333%}.vc_col-sm-3\\/5{width:60%}.vc_col-sm-8{width:66.6666%}.vc_col-sm-9{width:75%}.vc_col-sm-4\\/5{width:80%}.vc_col-sm-10{width:83.3333%}.vc_col-sm-11{width:91.6666%}.vc_col-sm-12{width:100%}.vc_col-sm-offset-0{margin-right:0}.vc_col-sm-offset-1{margin-right:8.3333%}.vc_col-sm-offset-2{margin-right:16.6666%}.vc_col-sm-offset-1\\/5{margin-right:20%}.vc_col-sm-offset-3{margin-right:25%}.vc_col-sm-offset-4{margin-right:33.3333%}.vc_col-sm-offset-2\\/5{margin-right:40%}.vc_col-sm-offset-5{margin-right:41.6666%}.vc_col-sm-offset-6{margin-right:50%}.vc_col-sm-offset-7{margin-right:58.3333%}.vc_col-sm-offset-3\\/5{margin-right:60%}.vc_col-sm-offset-8{margin-right:66.6666%}.vc_col-sm-offset-9{margin-right:75%}.vc_col-sm-offset-4\\/5{margin-right:80%}.vc_col-sm-offset-10{margin-right:83.3333%}.vc_col-sm-offset-11{margin-right:91.6666%}.vc_col-sm-offset-12{margin-right:100%}}@media (min-width:1025px){.vc_col-md-1{width:8.3333%}.vc_col-md-2{width:16.6666%}.vc_col-md-1\\/5{width:20%}.vc_col-md-3{width:25%}.vc_col-md-4{width:33.3333%}.vc_col-md-2\\/5{width:40%}.vc_col-md-5{width:41.6666%}.vc_col-md-6{width:50%}.vc_col-md-7{width:58.3333%}.vc_col-md-3\\/5{width:60%}.vc_col-md-8{width:66.6666%}.vc_col-md-9{width:75%}.vc_col-md-4\\/5{width:80%}.vc_col-md-10{width:83.3333%}.vc_col-md-11{width:91.6666%}.vc_col-md-12{width:100%}.vc_col-md-offset-0{margin-right:0}.vc_col-md-offset-1{margin-right:8.3333%}.vc_col-md-offset-2{margin-right:16.6666%}.vc_col-md-offset-1\\/5{margin-right:20%}.vc_col-md-offset-3{margin-right:25%}.vc_col-md-offset-4{margin-right:33.3333%}.vc_col-md-offset-2\\/5{margin-right:40%}.vc_col-md-offset-5{margin-right:41.6666%}.vc_col-md-offset-6{margin-right:50%}.vc_col-md-offset-7{margin-right:58.3333%}.vc_col-md-offset-3\\/5{margin-right:60%}.vc_col-md-offset-8{margin-right:66.6666%}.vc_col-md-offset-9{margin-right:75%}.vc_col-md-offset-4\\/5{margin-right:80%}.vc_col-md-offset-10{margin-right:83.3333%}.vc_col-md-offset-11{margin-right:91.6666%}.vc_col-md-offset-12{margin-right:100%}}@media (min-width:1281px){.vc_col-lg-1{width:8.3333%}.vc_col-lg-2{width:16.6666%}.vc_col-lg-1\\/5{width:20%}.vc_col-lg-3{width:25%}.vc_col-lg-4{width:33.3333%}.vc_col-lg-2\\/5{width:40%}.vc_col-lg-5{width:41.6666%}.vc_col-lg-6{width:50%}.vc_col-lg-7{width:58.3333%}.vc_col-lg-3\\/5{width:60%}.vc_col-lg-8{width:66.6666%}.vc_col-lg-9{width:75%}.vc_col-lg-4\\/5{width:80%}.vc_col-lg-10{width:83.3333%}.vc_col-lg-11{width:91.6666%}.vc_col-lg-12{width:100%}.vc_col-lg-offset-0{margin-right:0}.vc_col-lg-offset-1{margin-right:8.3333%}.vc_col-lg-offset-2{margin-right:16.6666%}.vc_col-lg-offset-1\\/5{margin-right:20%}.vc_col-lg-offset-3{margin-right:25%}.vc_col-lg-offset-4{margin-right:33.3333%}.vc_col-lg-offset-2\\/5{margin-right:40%}.vc_col-lg-offset-5{margin-right:41.6666%}.vc_col-lg-offset-6{margin-right:50%}.vc_col-lg-offset-7{margin-right:58.3333%}.vc_col-lg-offset-3\\/5{margin-right:60%}.vc_col-lg-offset-8{margin-right:66.6666%}.vc_col-lg-offset-9{margin-right:75%}.vc_col-lg-offset-4\\/5{margin-right:80%}.vc_col-lg-offset-10{margin-right:83.3333%}.vc_col-lg-offset-11{margin-right:91.6666%}.vc_col-lg-offset-12{margin-right:100%}}@media (min-width:601px) and (max-width:1024px){.g-cols.via_flex.type_default>div[class*=\"vc_col-md-\"],.g-cols.via_flex.type_default>div[class*=\"vc_col-lg-\"]{margin-top:1rem;margin-bottom:1rem}}@media (min-width:1025px) and (max-width:1280px){.g-cols.via_flex.type_default>div[class*=\"vc_col-lg-\"]{margin-top:1rem;margin-bottom:1rem}}@media (max-width:767px){.l-canvas{overflow:hidden}.g-cols.stacking_default.reversed>div:last-of-type{order:-1}.g-cols.stacking_default.via_flex>div:not([class*=\"vc_col-xs\"]){width:100%;margin:0 0 1.5rem}.g-cols.stacking_default.via_grid.mobiles-cols_1{grid-template-columns:100%}.g-cols.stacking_default.via_flex.type_boxes>div,.g-cols.stacking_default.via_flex.reversed>div:first-child,.g-cols.stacking_default.via_flex:not(.reversed)>div:last-child,.g-cols.stacking_default.via_flex>div.has_bg_color{margin-bottom:0}.g-cols.stacking_default.via_flex.type_default>.wpb_column.stretched{margin-left:-1rem;margin-right:-1rem}.g-cols.stacking_default.via_grid.mobiles-cols_1>.wpb_column.stretched,.g-cols.stacking_default.via_flex.type_boxes>.wpb_column.stretched{margin-left:-2.5rem;margin-right:-2.5rem;width:auto}.vc_column-inner.type_sticky>.wpb_wrapper,.vc_column_container.type_sticky>.vc_column-inner{top:0!important}}@media (min-width:768px){body:not(.rtl) .l-section.for_sidebar.at_left>div>.l-sidebar,.rtl .l-section.for_sidebar.at_right>div>.l-sidebar{order:-1}.vc_column_container.type_sticky>.vc_column-inner,.vc_column-inner.type_sticky>.wpb_wrapper{position:-webkit-sticky;position:sticky}.l-section.type_sticky{position:-webkit-sticky;position:sticky;top:0;z-index:11;transform:translateZ(0); transition:top 0.3s cubic-bezier(.78,.13,.15,.86) 0.1s}.header_hor .l-header.post_fixed.sticky_auto_hide{z-index:12}.admin-bar .l-section.type_sticky{top:32px}.l-section.type_sticky>.l-section-h{transition:padding-top 0.3s}.header_hor .l-header.pos_fixed:not(.down)~.l-main .l-section.type_sticky:not(:first-of-type){top:var(--header-sticky-height)}.admin-bar.header_hor .l-header.pos_fixed:not(.down)~.l-main .l-section.type_sticky:not(:first-of-type){top:calc( var(--header-sticky-height) + 32px )}.header_hor .l-header.pos_fixed.sticky:not(.down)~.l-main .l-section.type_sticky:first-of-type>.l-section-h{padding-top:var(--header-sticky-height)}.header_hor.headerinpos_bottom .l-header.pos_fixed.sticky:not(.down)~.l-main .l-section.type_sticky:first-of-type>.l-section-h{padding-bottom:var(--header-sticky-height)!important}}@media screen and (min-width:1210px){.g-cols.via_flex.type_default>.wpb_column.stretched:first-of-type{margin-left:calc( var(--site-content-width) / 2 + 0px / 2 + 1.5rem - 50vw)}.g-cols.via_flex.type_default>.wpb_column.stretched:last-of-type{margin-right:calc( var(--site-content-width) / 2 + 0px / 2 + 1.5rem - 50vw)}.l-main .alignfull, .w-separator.width_screen,.g-cols.via_grid>.wpb_column.stretched:first-of-type,.g-cols.via_flex.type_boxes>.wpb_column.stretched:first-of-type{margin-left:calc( var(--site-content-width) / 2 + 0px / 2 - 50vw )}.l-main .alignfull, .w-separator.width_screen,.g-cols.via_grid>.wpb_column.stretched:last-of-type,.g-cols.via_flex.type_boxes>.wpb_column.stretched:last-of-type{margin-right:calc( var(--site-content-width) / 2 + 0px / 2 - 50vw )}}@media (max-width:600px){.w-form-row.for_submit[style*=btn-size-mobiles] .w-btn{font-size:var(--btn-size-mobiles)!important}}a,button,input[type=submit],.ui-slider-handle{outline:none!important}.w-toplink,.w-header-show{background:rgba(0,0,0,0.3)}.no-touch .w-toplink.active:hover,.no-touch .w-header-show:hover{background:var(--color-content-primary-grad)}button[type=submit]:not(.w-btn),input[type=submit]:not(.w-btn),.woocommerce .button.alt,.woocommerce .button.checkout,.woocommerce .button.add_to_cart_button,.us-nav-style_1>*,.navstyle_1>.owl-nav button,.us-btn-style_1{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#7049ba;border-color:transparent;color:#ffffff!important}button[type=submit]:not(.w-btn):before,input[type=submit]:not(.w-btn),.woocommerce .button.alt:before,.woocommerce .button.checkout:before,.woocommerce .button.add_to_cart_button:before,.us-nav-style_1>*:before,.navstyle_1>.owl-nav button:before,.us-btn-style_1:before{border-width:2px}.no-touch button[type=submit]:not(.w-btn):hover,.no-touch input[type=submit]:not(.w-btn):hover,.no-touch .woocommerce .button.alt:hover,.no-touch .woocommerce .button.checkout:hover,.no-touch .woocommerce .button.add_to_cart_button:hover,.us-nav-style_1>span.current,.no-touch .us-nav-style_1>a:hover,.no-touch .navstyle_1>.owl-nav button:hover,.no-touch .us-btn-style_1:hover{background:#ffb03a;border-color:transparent;color:#ffffff!important}.us-nav-style_1>*{min-width:calc(1.2em + 2 * 0.8em)}.woocommerce .button,.woocommerce .actions .button,.us-nav-style_2>*,.navstyle_2>.owl-nav button,.us-btn-style_2{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#e0e0e0;border-color:transparent;color:#424242!important}.woocommerce .button:before,.woocommerce .actions .button:before,.us-nav-style_2>*:before,.navstyle_2>.owl-nav button:before,.us-btn-style_2:before{border-width:2px}.no-touch .woocommerce .button:hover,.no-touch .woocommerce .actions .button:hover,.us-nav-style_2>span.current,.no-touch .us-nav-style_2>a:hover,.no-touch .navstyle_2>.owl-nav button:hover,.no-touch .us-btn-style_2:hover{background:#e0e0e0;border-color:transparent;color:#424242!important}.us-nav-style_2>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_3>*,.navstyle_3>.owl-nav button,.us-btn-style_3{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#fff;border-color:transparent;color:#222!important}.us-nav-style_3>*:before,.navstyle_3>.owl-nav button:before,.us-btn-style_3:before{border-width:2px}.us-nav-style_3>span.current,.no-touch .us-nav-style_3>a:hover,.no-touch .navstyle_3>.owl-nav button:hover,.no-touch .us-btn-style_3:hover{background:#fff;border-color:transparent;color:#222!important}.us-nav-style_3>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_4>*,.navstyle_4>.owl-nav button,.us-btn-style_4{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#fff;border-color:transparent;color:#222!important}.us-nav-style_4>*:before,.navstyle_4>.owl-nav button:before,.us-btn-style_4:before{border-width:2px}.us-nav-style_4>span.current,.no-touch .us-nav-style_4>a:hover,.no-touch .navstyle_4>.owl-nav button:hover,.no-touch .us-btn-style_4:hover{background:#fff;border-color:transparent;color:#222!important}.us-nav-style_4>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_5>*,.navstyle_5>.owl-nav button,.us-btn-style_5{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#fff;border-color:transparent;color:#222!important}.us-nav-style_5>*:before,.navstyle_5>.owl-nav button:before,.us-btn-style_5:before{border-width:2px}.us-nav-style_5>span.current,.no-touch .us-nav-style_5>a:hover,.no-touch .navstyle_5>.owl-nav button:hover,.no-touch .us-btn-style_5:hover{background:#fff;border-color:transparent;color:#222!important}.us-nav-style_5>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_6>*,.navstyle_6>.owl-nav button,.us-btn-style_6{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#fff;border-color:transparent;color:#222!important}.us-nav-style_6>*:before,.navstyle_6>.owl-nav button:before,.us-btn-style_6:before{border-width:2px}.us-nav-style_6>span.current,.no-touch .us-nav-style_6>a:hover,.no-touch .navstyle_6>.owl-nav button:hover,.no-touch .us-btn-style_6:hover{background:#fff;border-color:transparent;color:#222!important}.us-nav-style_6>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_7>*,.navstyle_7>.owl-nav button,.us-btn-style_7{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#ffffff;border-color:transparent;color:#222222!important}.us-nav-style_7>*:before,.navstyle_7>.owl-nav button:before,.us-btn-style_7:before{border-width:2px}.us-nav-style_7>span.current,.no-touch .us-nav-style_7>a:hover,.no-touch .navstyle_7>.owl-nav button:hover,.no-touch .us-btn-style_7:hover{background:#ffffff;border-color:transparent;color:#222222!important}.us-nav-style_7>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_8>*,.navstyle_8>.owl-nav button,.us-btn-style_8{font-family:var(--font-family);font-weight:700;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:1.2em 1.2em;background:#f5f5f5;border-color:transparent;color:#424242!important}.us-nav-style_8>*:before,.navstyle_8>.owl-nav button:before,.us-btn-style_8:before{border-width:2px}.us-nav-style_8>span.current,.no-touch .us-nav-style_8>a:hover,.no-touch .navstyle_8>.owl-nav button:hover,.no-touch .us-btn-style_8:hover{background:#e0e0e0;border-color:transparent;color:#424242!important}.us-nav-style_8>*{min-width:calc(1.2em + 2 * 1.2em)}.us-nav-style_9>*,.navstyle_9>.owl-nav button,.us-btn-style_9{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#ffb03a;border-color:transparent;color:#ffffff!important}.us-nav-style_9>*:before,.navstyle_9>.owl-nav button:before,.us-btn-style_9:before{border-width:2px}.us-nav-style_9>span.current,.no-touch .us-nav-style_9>a:hover,.no-touch .navstyle_9>.owl-nav button:hover,.no-touch .us-btn-style_9:hover{background:#ffb03a;border-color:transparent;color:#ffffff!important}.us-nav-style_9>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_10>*,.navstyle_10>.owl-nav button,.us-btn-style_10{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#7049ba;border-color:transparent;color:#ffffff!important}.us-nav-style_10>*:before,.navstyle_10>.owl-nav button:before,.us-btn-style_10:before{border-width:2px}.us-nav-style_10>span.current,.no-touch .us-nav-style_10>a:hover,.no-touch .navstyle_10>.owl-nav button:hover,.no-touch .us-btn-style_10:hover{background:#7049ba;border-color:transparent;color:#ffffff!important}.us-nav-style_10>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_11>*,.navstyle_11>.owl-nav button,.us-btn-style_11{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#424242;border-color:transparent;color:#ffffff!important}.us-nav-style_11>*:before,.navstyle_11>.owl-nav button:before,.us-btn-style_11:before{border-width:2px}.us-nav-style_11>span.current,.no-touch .us-nav-style_11>a:hover,.no-touch .navstyle_11>.owl-nav button:hover,.no-touch .us-btn-style_11:hover{background:#424242;border-color:transparent;color:#ffffff!important}.us-nav-style_11>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_12>*,.navstyle_12>.owl-nav button,.us-btn-style_12{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:transparent;border-color:transparent;color:#ffffff!important}.us-nav-style_12>*:before,.navstyle_12>.owl-nav button:before,.us-btn-style_12:before{border-width:2px}.us-nav-style_12>span.current,.no-touch .us-nav-style_12>a:hover,.no-touch .navstyle_12>.owl-nav button:hover,.no-touch .us-btn-style_12:hover{background:rgba(255,255,255,0.12);border-color:transparent;color:#ffffff!important}.us-nav-style_12>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_13>*,.navstyle_13>.owl-nav button,.us-btn-style_13{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:transparent;border-color:transparent;color:#ffffff!important}.us-nav-style_13>*:before,.navstyle_13>.owl-nav button:before,.us-btn-style_13:before{border-width:2px}.us-nav-style_13>span.current,.no-touch .us-nav-style_13>a:hover,.no-touch .navstyle_13>.owl-nav button:hover,.no-touch .us-btn-style_13:hover{background:#f5f5f5;border-color:transparent;color:#ffffff!important}.us-nav-style_13>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_14>*,.navstyle_14>.owl-nav button,.us-btn-style_14{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#000000;border-color:transparent;color:#ffffff!important}.us-nav-style_14>*:before,.navstyle_14>.owl-nav button:before,.us-btn-style_14:before{border-width:2px}.us-nav-style_14>span.current,.no-touch .us-nav-style_14>a:hover,.no-touch .navstyle_14>.owl-nav button:hover,.no-touch .us-btn-style_14:hover{background:#000000;border-color:transparent;color:#ffffff!important}.us-nav-style_14>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_15>*,.navstyle_15>.owl-nav button,.us-btn-style_15{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:transparent;border-color:transparent;color:#7049ba!important}.us-nav-style_15>*:before,.navstyle_15>.owl-nav button:before,.us-btn-style_15:before{border-width:2px}.us-nav-style_15>span.current,.no-touch .us-nav-style_15>a:hover,.no-touch .navstyle_15>.owl-nav button:hover,.no-touch .us-btn-style_15:hover{background:#f5f5f5;border-color:transparent;color:#7049ba!important}.us-nav-style_15>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_16>*,.navstyle_16>.owl-nav button,.us-btn-style_16{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:transparent;border-color:transparent;color:#ffb03a!important}.us-nav-style_16>*:before,.navstyle_16>.owl-nav button:before,.us-btn-style_16:before{border-width:2px}.us-nav-style_16>span.current,.no-touch .us-nav-style_16>a:hover,.no-touch .navstyle_16>.owl-nav button:hover,.no-touch .us-btn-style_16:hover{background:#f5f5f5;border-color:transparent;color:#ffb03a!important}.us-nav-style_16>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_17>*,.navstyle_17>.owl-nav button,.us-btn-style_17{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:transparent;border-color:transparent;color:inherit!important}.us-nav-style_17>*:before,.navstyle_17>.owl-nav button:before,.us-btn-style_17:before{border-width:2px}.us-nav-style_17>span.current,.no-touch .us-nav-style_17>a:hover,.no-touch .navstyle_17>.owl-nav button:hover,.no-touch .us-btn-style_17:hover{background:#f5f5f5;border-color:transparent;color:inherit!important}.us-nav-style_17>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_18>*,.navstyle_18>.owl-nav button,.us-btn-style_18{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:transparent;border-color:transparent;color:#9e9e9e!important}.us-nav-style_18>*:before,.navstyle_18>.owl-nav button:before,.us-btn-style_18:before{border-width:2px}.us-nav-style_18>span.current,.no-touch .us-nav-style_18>a:hover,.no-touch .navstyle_18>.owl-nav button:hover,.no-touch .us-btn-style_18:hover{background:#f5f5f5;border-color:transparent;color:#9e9e9e!important}.us-nav-style_18>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_19>*,.navstyle_19>.owl-nav button,.us-btn-style_19{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:transparent;border-color:transparent;color:#000000!important}.us-nav-style_19>*:before,.navstyle_19>.owl-nav button:before,.us-btn-style_19:before{border-width:2px}.us-nav-style_19>span.current,.no-touch .us-nav-style_19>a:hover,.no-touch .navstyle_19>.owl-nav button:hover,.no-touch .us-btn-style_19:hover{background:#f5f5f5;border-color:transparent;color:#000000!important}.us-nav-style_19>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_20>*,.navstyle_20>.owl-nav button,.us-btn-style_20{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#42d69b;border-color:transparent;color:#ffeb8c!important}.us-nav-style_20>*:before,.navstyle_20>.owl-nav button:before,.us-btn-style_20:before{border-width:2px}.us-nav-style_20>span.current,.no-touch .us-nav-style_20>a:hover,.no-touch .navstyle_20>.owl-nav button:hover,.no-touch .us-btn-style_20:hover{background:#42d69b;border-color:transparent;color:#ffeb8c!important}.us-nav-style_20>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_21>*,.navstyle_21>.owl-nav button,.us-btn-style_21{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#ffe772;border-color:transparent;color:#725439!important}.us-nav-style_21>*:before,.navstyle_21>.owl-nav button:before,.us-btn-style_21:before{border-width:2px}.us-nav-style_21>span.current,.no-touch .us-nav-style_21>a:hover,.no-touch .navstyle_21>.owl-nav button:hover,.no-touch .us-btn-style_21:hover{background:#ffe772;border-color:transparent;color:#725439!important}.us-nav-style_21>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_22>*,.navstyle_22>.owl-nav button,.us-btn-style_22{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#21aad3;border-color:transparent;color:#ffffff!important}.us-nav-style_22>*:before,.navstyle_22>.owl-nav button:before,.us-btn-style_22:before{border-width:2px}.us-nav-style_22>span.current,.no-touch .us-nav-style_22>a:hover,.no-touch .navstyle_22>.owl-nav button:hover,.no-touch .us-btn-style_22:hover{background:#21aad3;border-color:transparent;color:#ffffff!important}.us-nav-style_22>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_23>*,.navstyle_23>.owl-nav button,.us-btn-style_23{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#f43838;border-color:transparent;color:#ffebce!important}.us-nav-style_23>*:before,.navstyle_23>.owl-nav button:before,.us-btn-style_23:before{border-width:2px}.us-nav-style_23>span.current,.no-touch .us-nav-style_23>a:hover,.no-touch .navstyle_23>.owl-nav button:hover,.no-touch .us-btn-style_23:hover{background:#f43838;border-color:transparent;color:#ffebce!important}.us-nav-style_23>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_24>*,.navstyle_24>.owl-nav button,.us-btn-style_24{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#e1eded;border-color:transparent;color:#1e73be!important}.us-nav-style_24>*:before,.navstyle_24>.owl-nav button:before,.us-btn-style_24:before{border-width:2px}.us-nav-style_24>span.current,.no-touch .us-nav-style_24>a:hover,.no-touch .navstyle_24>.owl-nav button:hover,.no-touch .us-btn-style_24:hover{background:#e1eded;border-color:transparent;color:#1e73be!important}.us-nav-style_24>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_25>*,.navstyle_25>.owl-nav button,.us-btn-style_25{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#2f7c08;border-color:transparent;color:#bfe874!important}.us-nav-style_25>*:before,.navstyle_25>.owl-nav button:before,.us-btn-style_25:before{border-width:2px}.us-nav-style_25>span.current,.no-touch .us-nav-style_25>a:hover,.no-touch .navstyle_25>.owl-nav button:hover,.no-touch .us-btn-style_25:hover{background:#2f7c08;border-color:transparent;color:#bfe874!important}.us-nav-style_25>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_26>*,.navstyle_26>.owl-nav button,.us-btn-style_26{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:transparent;border-color:transparent;color:#99d369!important}.us-nav-style_26>*:before,.navstyle_26>.owl-nav button:before,.us-btn-style_26:before{border-width:2px}.us-nav-style_26>span.current,.no-touch .us-nav-style_26>a:hover,.no-touch .navstyle_26>.owl-nav button:hover,.no-touch .us-btn-style_26:hover{background:#f5f5f5;border-color:transparent;color:#99d369!important}.us-nav-style_26>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_27>*,.navstyle_27>.owl-nav button,.us-btn-style_27{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#edf3f9;border-color:transparent;color:#23cde0!important}.us-nav-style_27>*:before,.navstyle_27>.owl-nav button:before,.us-btn-style_27:before{border-width:2px}.us-nav-style_27>span.current,.no-touch .us-nav-style_27>a:hover,.no-touch .navstyle_27>.owl-nav button:hover,.no-touch .us-btn-style_27:hover{background:#edf3f9;border-color:transparent;color:#23cde0!important}.us-nav-style_27>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_28>*,.navstyle_28>.owl-nav button,.us-btn-style_28{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:transparent;border-color:transparent;color:#d33bbc!important}.us-nav-style_28>*:before,.navstyle_28>.owl-nav button:before,.us-btn-style_28:before{border-width:2px}.us-nav-style_28>span.current,.no-touch .us-nav-style_28>a:hover,.no-touch .navstyle_28>.owl-nav button:hover,.no-touch .us-btn-style_28:hover{background:#f5f5f5;border-color:transparent;color:#d33bbc!important}.us-nav-style_28>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_29>*,.navstyle_29>.owl-nav button,.us-btn-style_29{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#fff8e0;border-color:transparent;color:#ffb200!important}.us-nav-style_29>*:before,.navstyle_29>.owl-nav button:before,.us-btn-style_29:before{border-width:2px}.us-nav-style_29>span.current,.no-touch .us-nav-style_29>a:hover,.no-touch .navstyle_29>.owl-nav button:hover,.no-touch .us-btn-style_29:hover{background:#fff8e0;border-color:transparent;color:#ffb200!important}.us-nav-style_29>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_30>*,.navstyle_30>.owl-nav button,.us-btn-style_30{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:transparent;border-color:transparent;color:#6761cc!important}.us-nav-style_30>*:before,.navstyle_30>.owl-nav button:before,.us-btn-style_30:before{border-width:2px}.us-nav-style_30>span.current,.no-touch .us-nav-style_30>a:hover,.no-touch .navstyle_30>.owl-nav button:hover,.no-touch .us-btn-style_30:hover{background:#f5f5f5;border-color:transparent;color:#6761cc!important}.us-nav-style_30>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_31>*,.navstyle_31>.owl-nav button,.us-btn-style_31{font-family:var(--font-family);font-weight:400;font-style:normal;text-transform:uppercase;letter-spacing:0em;border-radius:0.2em;padding:0.8em 1.5em;background:#7edd8e;border-color:transparent;color:#ffffff!important}.us-nav-style_31>*:before,.navstyle_31>.owl-nav button:before,.us-btn-style_31:before{border-width:2px}.us-nav-style_31>span.current,.no-touch .us-nav-style_31>a:hover,.no-touch .navstyle_31>.owl-nav button:hover,.no-touch .us-btn-style_31:hover{background:#7edd8e;border-color:transparent;color:#ffffff!important}.us-nav-style_31>*{min-width:calc(1.2em + 2 * 0.8em)}.w-filter.state_desktop.style_drop_default .w-filter-item-title,.select2-selection,select,textarea,input:not([type=submit]){font-weight:400;letter-spacing:0em;border-radius:0.2em;background:transparent;border-color:#e0e0e0;color:inherit}.w-filter.state_desktop.style_drop_default .w-filter-item-title:focus,.select2-container--open .select2-selection,select:focus,textarea:focus,input:not([type=submit]):focus{border-color:#7049ba!important;box-shadow:0px 0px 0px 1px #7049ba inset}.w-form-row.move_label .w-form-row-label{font-size:1rem;top:calc(3em/2 + 1px - 0.7em);margin:0 1em;background:var(--color-content-bg-grad);color:inherit}.w-form-row.with_icon.move_label .w-form-row-label{margin-right:calc(1.6em + 1em)}.color_alternate .w-form-row.move_label .w-form-row-label{background:var(--color-alt-content-bg-grad)}.color_footer-top .w-form-row.move_label .w-form-row-label{background:var(--color-subfooter-bg-grad)}.color_footer-bottom .w-form-row.move_label .w-form-row-label{background:var(--color-footer-bg-grad)}.leaflet-default-icon-path{background-image:url(https://demo.parsplugin.com/upsolo/wp-content/themes/Zephyr/common/css/vendor/images/marker-icon.png)}.woocommerce-product-gallery--columns-4 li{width:25.000%}.header_hor .w-nav.type_desktop .menu-item-5340 .w-nav-list.level_2{left:0;right:0;transform-origin:50% 0;padding:15px}.header_hor .w-nav.type_desktop .menu-item-5340{position:static}.header_hor .w-nav.type_desktop .menu-item-5337 .w-nav-list.level_2{left:0;right:0;transform-origin:50% 0;padding:15px}.header_hor .w-nav.type_desktop .menu-item-5337{position:static}", "yes");
INSERT INTO `wp_options` VALUES("43790", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"IjZkiOJpmfiW6oURYiTCt8Y6OB9R4yyL\";}", "yes");
INSERT INTO `wp_options` VALUES("14654", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14655", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14656", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14510", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.8.2\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1533160226;s:7:\"version\";s:5:\"5.0.3\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("14657", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14658", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14515", "bsf-updater-version", "1.27.15", "yes");
INSERT INTO `wp_options` VALUES("14453", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("14456", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("14457", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("14458", "wp_page_for_privacy_policy", "", "yes");
INSERT INTO `wp_options` VALUES("14459", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای بهبود تجربه شما در این سایت و برای مدیریت دسترسی به حساب کاربری و یا دیگر اهداف ذکر شده در [privacy_policy] استفاده می گردد.", "yes");
INSERT INTO `wp_options` VALUES("14460", "woocommerce_checkout_privacy_policy_text", "داده های شخصی شما برای پردازش سفارش شما مورد استفاده قرار می گیرد، تجربه شما را در این وب سایت و سایر موارد ذکر شده در [privacy_policy] ما پشتیبانی می کند", "yes");
INSERT INTO `wp_options` VALUES("14461", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("14462", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `wp_options` VALUES("14463", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `wp_options` VALUES("14464", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `wp_options` VALUES("14465", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("14466", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wp_options` VALUES("14467", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `wp_options` VALUES("14468", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("14470", "default_product_cat", "50", "yes");
INSERT INTO `wp_options` VALUES("14485", "revslider_table_version", "1.0.12", "yes");
INSERT INTO `wp_options` VALUES("14489", "woocommerce_thumbnail_cropping", "1:1", "yes");
INSERT INTO `wp_options` VALUES("15107", "wpp_adminpanel_font_main", "Vazir", "yes");
INSERT INTO `wp_options` VALUES("15108", "wpp_adminpanel_font_h", "Vazir", "yes");
INSERT INTO `wp_options` VALUES("15109", "wpp_adminpanel_font_nav", "Vazir", "yes");
INSERT INTO `wp_options` VALUES("15110", "wpp_adminpanel_datepicker", "1", "yes");
INSERT INTO `wp_options` VALUES("15114", "loco_settings", "a:3:{s:1:\"c\";s:18:\"Loco_data_Settings\";s:1:\"v\";i:0;s:1:\"d\";a:11:{s:7:\"version\";s:5:\"2.1.4\";s:8:\"gen_hash\";b:0;s:9:\"use_fuzzy\";b:1;s:11:\"num_backups\";i:1;s:9:\"pot_alias\";a:3:{i:0;s:10:\"default.po\";i:1;s:8:\"en_US.po\";i:2;s:5:\"en.po\";}s:9:\"php_alias\";a:2:{i:0;s:3:\"php\";i:1;s:4:\"twig\";}s:10:\"fs_persist\";b:0;s:10:\"fs_protect\";i:1;s:12:\"max_php_size\";s:4:\"100K\";s:11:\"po_utf8_bom\";b:0;s:8:\"po_width\";s:2:\"79\";}}", "yes");
INSERT INTO `wp_options` VALUES("15122", "loco_recent", "a:3:{s:1:\"c\";s:21:\"Loco_data_RecentItems\";s:1:\"v\";i:0;s:1:\"d\";a:1:{s:6:\"bundle\";a:2:{s:4:\"core\";i:1533293928;s:46:\"plugin.us-header-builder/us-header-builder.php\";i:1536917794;}}}", "no");
INSERT INTO `wp_options` VALUES("15180", "bsf_force_check_extensions", "", "no");
INSERT INTO `wp_options` VALUES("6084", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("5152", "usof_backup_Zephyr", "a:2:{s:4:\"time\";s:19:\"2017-04-23 15:52:56\";s:12:\"usof_options\";a:306:{s:9:\"preloader\";s:1:\"1\";s:15:\"preloader_image\";s:0:\"\";s:12:\"page_sidebar\";s:4:\"none\";s:15:\"page_sidebar_id\";s:15:\"default_sidebar\";s:9:\"footer_id\";s:14:\"default-footer\";s:13:\"footer_layout\";s:7:\"compact\";s:10:\"og_enabled\";s:1:\"1\";s:13:\"gmaps_api_key\";s:0:\"\";s:25:\"custom_post_types_support\";a:0:{}s:17:\"responsive_layout\";s:1:\"1\";s:13:\"canvas_layout\";s:4:\"wide\";s:13:\"color_body_bg\";s:7:\"#e0e0e0\";s:13:\"body_bg_image\";s:0:\"\";s:20:\"body_bg_image_repeat\";s:6:\"repeat\";s:22:\"body_bg_image_position\";s:10:\"top center\";s:24:\"body_bg_image_attachment\";s:6:\"scroll\";s:18:\"body_bg_image_size\";s:7:\"initial\";s:17:\"site_canvas_width\";s:4:\"1300\";s:18:\"site_content_width\";s:4:\"1140\";s:13:\"sidebar_width\";s:2:\"25\";s:13:\"content_width\";s:2:\"68\";s:22:\"columns_stacking_width\";s:3:\"767\";s:21:\"disable_effects_width\";s:3:\"900\";s:10:\"row_height\";s:6:\"medium\";s:22:\"color_header_middle_bg\";s:7:\"#7049ba\";s:24:\"color_header_middle_text\";s:7:\"#ffffff\";s:30:\"color_header_middle_text_hover\";s:7:\"#ffffff\";s:19:\"color_header_top_bg\";s:7:\"#6039a8\";s:21:\"color_header_top_text\";s:7:\"#c8b8e5\";s:27:\"color_header_top_text_hover\";s:7:\"#ffffff\";s:22:\"color_header_bottom_bg\";s:7:\"#6039a8\";s:24:\"color_header_bottom_text\";s:7:\"#c8b8e5\";s:30:\"color_header_bottom_text_hover\";s:7:\"#ffffff\";s:29:\"color_header_transparent_text\";s:7:\"#ffffff\";s:35:\"color_header_transparent_text_hover\";s:7:\"#ffffff\";s:22:\"color_header_search_bg\";s:7:\"#7049ba\";s:24:\"color_header_search_text\";s:7:\"#ffffff\";s:19:\"color_menu_hover_bg\";s:7:\"#6039a8\";s:21:\"color_menu_hover_text\";s:7:\"#ffffff\";s:22:\"color_menu_active_text\";s:7:\"#ffc670\";s:34:\"color_menu_transparent_active_text\";s:7:\"#ffc670\";s:13:\"color_drop_bg\";s:7:\"#ffffff\";s:15:\"color_drop_text\";s:7:\"#212121\";s:19:\"color_drop_hover_bg\";s:4:\"#eee\";s:21:\"color_drop_hover_text\";s:7:\"#212121\";s:20:\"color_drop_active_bg\";s:7:\"#f7f7f7\";s:22:\"color_drop_active_text\";s:7:\"#7049ba\";s:20:\"color_menu_button_bg\";s:7:\"#ffffff\";s:22:\"color_menu_button_text\";s:7:\"#7049ba\";s:26:\"color_menu_button_hover_bg\";s:7:\"#ffffff\";s:28:\"color_menu_button_hover_text\";s:7:\"#7049ba\";s:16:\"color_content_bg\";s:7:\"#ffffff\";s:20:\"color_content_bg_alt\";s:7:\"#f5f5f5\";s:20:\"color_content_border\";s:7:\"#e0e0e0\";s:21:\"color_content_heading\";s:7:\"#212121\";s:18:\"color_content_text\";s:7:\"#424242\";s:18:\"color_content_link\";s:7:\"#7049ba\";s:24:\"color_content_link_hover\";s:7:\"#ffb03a\";s:21:\"color_content_primary\";s:7:\"#7049ba\";s:23:\"color_content_secondary\";s:7:\"#ffb03a\";s:19:\"color_content_faded\";s:7:\"#9e9e9e\";s:18:\"color_subfooter_bg\";s:7:\"#212121\";s:22:\"color_subfooter_bg_alt\";s:7:\"#292929\";s:22:\"color_subfooter_border\";s:4:\"#333\";s:20:\"color_subfooter_text\";s:7:\"#757575\";s:20:\"color_subfooter_link\";s:7:\"#9e9e9e\";s:26:\"color_subfooter_link_hover\";s:7:\"#ffb03a\";s:15:\"color_footer_bg\";s:4:\"#111\";s:19:\"color_footer_bg_alt\";s:7:\"#212121\";s:19:\"color_footer_border\";s:4:\"#333\";s:17:\"color_footer_text\";s:7:\"#757575\";s:17:\"color_footer_link\";s:7:\"#9e9e9e\";s:23:\"color_footer_link_hover\";s:7:\"#ffb03a\";s:11:\"color_style\";s:1:\"1\";s:6:\"header\";a:4:{s:7:\"default\";a:2:{s:7:\"options\";a:24:{s:11:\"orientation\";s:3:\"hor\";s:6:\"sticky\";b:1;s:17:\"scroll_breakpoint\";i:100;s:11:\"transparent\";s:1:\"0\";s:5:\"width\";s:3:\"300\";s:9:\"elm_align\";s:6:\"center\";s:8:\"top_show\";i:1;s:10:\"top_height\";s:2:\"40\";s:17:\"top_sticky_height\";s:1:\"0\";s:13:\"top_fullwidth\";s:1:\"0\";s:13:\"middle_height\";s:3:\"100\";s:20:\"middle_sticky_height\";s:2:\"50\";s:16:\"middle_fullwidth\";s:1:\"0\";s:6:\"bg_img\";s:0:\"\";s:20:\"bg_img_wrapper_start\";s:0:\"\";s:11:\"bg_img_size\";s:5:\"cover\";s:13:\"bg_img_repeat\";s:6:\"repeat\";s:17:\"bg_img_attachment\";s:6:\"scroll\";s:15:\"bg_img_position\";s:10:\"top center\";s:19:\"bgimage_wrapper_end\";s:0:\"\";s:11:\"bottom_show\";i:0;s:13:\"bottom_height\";s:2:\"40\";s:20:\"bottom_sticky_height\";s:2:\"40\";s:16:\"bottom_fullwidth\";s:1:\"0\";}s:6:\"layout\";a:10:{s:8:\"top_left\";a:3:{i:0;s:6:\"text:2\";i:1;s:6:\"text:3\";i:2;s:6:\"text:4\";}s:10:\"top_center\";a:0:{}s:9:\"top_right\";a:1:{i:0;s:9:\"socials:1\";}s:11:\"middle_left\";a:1:{i:0;s:6:\"text:1\";}s:13:\"middle_center\";a:0:{}s:12:\"middle_right\";a:3:{i:0;s:6:\"menu:1\";i:1;s:8:\"search:1\";i:2;s:6:\"cart:1\";}s:11:\"bottom_left\";a:0:{}s:13:\"bottom_center\";a:0:{}s:12:\"bottom_right\";a:0:{}s:6:\"hidden\";a:0:{}}}s:7:\"tablets\";a:2:{s:7:\"options\";a:24:{s:11:\"orientation\";s:3:\"hor\";s:6:\"sticky\";s:1:\"1\";s:17:\"scroll_breakpoint\";i:100;s:11:\"transparent\";i:0;s:5:\"width\";i:300;s:9:\"elm_align\";s:6:\"center\";s:8:\"top_show\";i:1;s:10:\"top_height\";i:36;s:17:\"top_sticky_height\";i:0;s:13:\"top_fullwidth\";i:0;s:13:\"middle_height\";i:80;s:20:\"middle_sticky_height\";s:2:\"50\";s:16:\"middle_fullwidth\";i:0;s:6:\"bg_img\";s:0:\"\";s:20:\"bg_img_wrapper_start\";s:0:\"\";s:11:\"bg_img_size\";s:5:\"cover\";s:13:\"bg_img_repeat\";s:6:\"repeat\";s:17:\"bg_img_attachment\";s:6:\"scroll\";s:15:\"bg_img_position\";s:10:\"top center\";s:19:\"bgimage_wrapper_end\";s:0:\"\";s:11:\"bottom_show\";i:0;s:13:\"bottom_height\";i:50;s:20:\"bottom_sticky_height\";i:50;s:16:\"bottom_fullwidth\";i:0;}s:6:\"layout\";a:10:{s:8:\"top_left\";a:3:{i:0;s:6:\"text:2\";i:1;s:6:\"text:3\";i:2;s:6:\"text:4\";}s:10:\"top_center\";a:0:{}s:9:\"top_right\";a:1:{i:0;s:9:\"socials:1\";}s:11:\"middle_left\";a:1:{i:0;s:6:\"text:1\";}s:13:\"middle_center\";a:0:{}s:12:\"middle_right\";a:3:{i:0;s:6:\"menu:1\";i:1;s:8:\"search:1\";i:2;s:6:\"cart:1\";}s:11:\"bottom_left\";a:0:{}s:13:\"bottom_center\";a:0:{}s:12:\"bottom_right\";a:0:{}s:6:\"hidden\";a:0:{}}}s:7:\"mobiles\";a:2:{s:7:\"options\";a:24:{s:11:\"orientation\";s:3:\"hor\";s:6:\"sticky\";s:1:\"1\";s:17:\"scroll_breakpoint\";i:100;s:11:\"transparent\";i:0;s:5:\"width\";i:300;s:9:\"elm_align\";s:6:\"center\";s:8:\"top_show\";i:0;s:10:\"top_height\";i:36;s:17:\"top_sticky_height\";i:0;s:13:\"top_fullwidth\";i:0;s:13:\"middle_height\";i:50;s:20:\"middle_sticky_height\";i:50;s:16:\"middle_fullwidth\";i:0;s:6:\"bg_img\";s:0:\"\";s:20:\"bg_img_wrapper_start\";s:0:\"\";s:11:\"bg_img_size\";s:5:\"cover\";s:13:\"bg_img_repeat\";s:6:\"repeat\";s:17:\"bg_img_attachment\";s:6:\"scroll\";s:15:\"bg_img_position\";s:10:\"top center\";s:19:\"bgimage_wrapper_end\";s:0:\"\";s:11:\"bottom_show\";i:0;s:13:\"bottom_height\";i:50;s:20:\"bottom_sticky_height\";i:50;s:16:\"bottom_fullwidth\";i:0;}s:6:\"layout\";a:10:{s:8:\"top_left\";a:3:{i:0;s:6:\"text:2\";i:1;s:6:\"text:3\";i:2;s:6:\"text:4\";}s:10:\"top_center\";a:0:{}s:9:\"top_right\";a:1:{i:0;s:9:\"socials:1\";}s:11:\"middle_left\";a:1:{i:0;s:6:\"text:1\";}s:13:\"middle_center\";a:0:{}s:12:\"middle_right\";a:3:{i:0;s:6:\"menu:1\";i:1;s:8:\"search:1\";i:2;s:6:\"cart:1\";}s:11:\"bottom_left\";a:0:{}s:13:\"bottom_center\";a:0:{}s:12:\"bottom_right\";a:0:{}s:6:\"hidden\";a:0:{}}}s:4:\"data\";a:8:{s:6:\"text:1\";a:10:{s:4:\"text\";s:23:\"<strong>ZEPHYR</strong>\";s:4:\"link\";s:28:\"http://zephyr.us-themes.com/\";s:4:\"icon\";s:0:\"\";s:4:\"font\";s:7:\"regular\";s:5:\"color\";s:0:\"\";s:4:\"wrap\";i:0;s:4:\"size\";s:2:\"27\";s:12:\"size_tablets\";s:2:\"24\";s:12:\"size_mobiles\";s:2:\"20\";s:14:\"design_options\";s:0:\"\";}s:6:\"text:2\";a:10:{s:4:\"text\";s:13:\"+321 123 4567\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:8:\"fa-phone\";s:4:\"font\";s:7:\"regular\";s:5:\"color\";s:0:\"\";s:4:\"wrap\";s:1:\"0\";s:4:\"size\";s:2:\"14\";s:12:\"size_tablets\";s:2:\"13\";s:12:\"size_mobiles\";s:2:\"13\";s:14:\"design_options\";a:1:{s:15:\"hide_for_sticky\";b:0;}}s:6:\"text:3\";a:10:{s:4:\"text\";s:13:\"info@test.com\";s:4:\"link\";s:20:\"mailto:info@test.com\";s:4:\"icon\";s:11:\"fa-envelope\";s:4:\"font\";s:7:\"regular\";s:5:\"color\";s:0:\"\";s:4:\"wrap\";s:1:\"0\";s:4:\"size\";s:2:\"14\";s:12:\"size_tablets\";s:2:\"13\";s:12:\"size_mobiles\";s:2:\"13\";s:14:\"design_options\";a:1:{s:15:\"hide_for_sticky\";b:0;}}s:6:\"text:4\";a:10:{s:4:\"text\";s:10:\"User login\";s:4:\"link\";s:18:\"/pages/login-page/\";s:4:\"icon\";s:4:\"lock\";s:4:\"font\";s:7:\"regular\";s:5:\"color\";s:0:\"\";s:4:\"wrap\";s:1:\"0\";s:4:\"size\";s:2:\"14\";s:12:\"size_tablets\";s:2:\"13\";s:12:\"size_mobiles\";s:2:\"13\";s:14:\"design_options\";a:1:{s:15:\"hide_for_sticky\";b:0;}}s:9:\"socials:1\";a:36:{s:5:\"color\";s:4:\"text\";s:5:\"hover\";s:7:\"default\";s:8:\"facebook\";s:1:\"#\";s:7:\"twitter\";s:1:\"#\";s:6:\"google\";s:0:\"\";s:8:\"linkedin\";s:0:\"\";s:7:\"youtube\";s:0:\"\";s:5:\"vimeo\";s:0:\"\";s:6:\"flickr\";s:0:\"\";s:7:\"behance\";s:1:\"#\";s:9:\"instagram\";s:1:\"#\";s:4:\"xing\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:5:\"skype\";s:0:\"\";s:8:\"dribbble\";s:0:\"\";s:2:\"vk\";s:1:\"#\";s:6:\"tumblr\";s:0:\"\";s:10:\"soundcloud\";s:1:\"#\";s:6:\"twitch\";s:0:\"\";s:4:\"yelp\";s:0:\"\";s:10:\"deviantart\";s:1:\"#\";s:10:\"foursquare\";s:0:\"\";s:6:\"github\";s:0:\"\";s:13:\"odnoklassniki\";s:0:\"\";s:6:\"s500px\";s:0:\"\";s:5:\"houzz\";s:0:\"\";s:6:\"medium\";s:0:\"\";s:11:\"tripadvisor\";s:0:\"\";s:3:\"rss\";s:0:\"\";s:11:\"custom_icon\";s:0:\"\";s:10:\"custom_url\";s:0:\"\";s:12:\"custom_color\";s:7:\"#1abc9c\";s:4:\"size\";i:18;s:12:\"size_tablets\";i:18;s:12:\"size_mobiles\";i:18;s:14:\"design_options\";s:0:\"\";}s:6:\"menu:1\";a:11:{s:9:\"font_size\";s:2:\"16\";s:7:\"indents\";i:40;s:8:\"vstretch\";s:1:\"0\";s:12:\"hover_effect\";s:6:\"simple\";s:15:\"dropdown_effect\";s:7:\"mdesign\";s:18:\"dropdown_font_size\";s:2:\"15\";s:12:\"mobile_width\";s:4:\"1000\";s:16:\"mobile_font_size\";s:2:\"16\";s:25:\"mobile_dropdown_font_size\";s:2:\"15\";s:15:\"mobile_behavior\";s:1:\"1\";s:14:\"design_options\";s:0:\"\";}s:8:\"search:1\";a:6:{s:4:\"text\";s:56:\"تایپ کنید و کلید اینتر را بزنید\";s:6:\"layout\";s:10:\"fullscreen\";s:5:\"width\";s:3:\"240\";s:13:\"width_tablets\";s:3:\"200\";s:14:\"product_search\";s:1:\"0\";s:14:\"design_options\";a:1:{s:15:\"hide_for_sticky\";b:0;}}s:6:\"cart:1\";a:5:{s:4:\"icon\";s:13:\"shopping_cart\";s:4:\"size\";s:2:\"20\";s:12:\"size_tablets\";s:2:\"20\";s:12:\"size_mobiles\";s:2:\"20\";s:14:\"design_options\";a:1:{s:15:\"hide_for_sticky\";b:0;}}}}s:13:\"header_layout\";s:10:\"extended_1\";s:13:\"header_sticky\";a:3:{i:0;s:7:\"default\";i:1;s:7:\"tablets\";i:2;s:7:\"mobiles\";}s:18:\"header_transparent\";s:1:\"0\";s:16:\"header_fullwidth\";s:1:\"0\";s:17:\"header_top_height\";s:2:\"40\";s:24:\"header_top_sticky_height\";s:1:\"0\";s:20:\"header_middle_height\";s:3:\"100\";s:27:\"header_middle_sticky_height\";s:2:\"50\";s:20:\"header_bottom_height\";s:2:\"40\";s:27:\"header_bottom_sticky_height\";s:2:\"40\";s:17:\"header_main_width\";s:3:\"300\";s:22:\"header_invert_logo_pos\";s:1:\"0\";s:24:\"header_scroll_breakpoint\";i:100;s:18:\"header_search_show\";s:1:\"1\";s:20:\"header_search_layout\";s:10:\"fullscreen\";s:20:\"header_contacts_show\";s:1:\"1\";s:21:\"header_contacts_phone\";s:10:\"0912000000\";s:21:\"header_contacts_email\";s:13:\"info@test.com\";s:27:\"header_contacts_custom_icon\";s:4:\"lock\";s:27:\"header_contacts_custom_text\";s:90:\"<a href=\'http://demo.parsplugin.com/upsolo/pages/login-page//\'>ورود کاربران</a>\";s:19:\"header_socials_show\";s:1:\"1\";s:23:\"header_socials_facebook\";s:1:\"#\";s:22:\"header_socials_twitter\";s:1:\"#\";s:21:\"header_socials_google\";s:0:\"\";s:23:\"header_socials_linkedin\";s:0:\"\";s:22:\"header_socials_youtube\";s:0:\"\";s:20:\"header_socials_vimeo\";s:0:\"\";s:21:\"header_socials_flickr\";s:0:\"\";s:22:\"header_socials_behance\";s:1:\"#\";s:24:\"header_socials_instagram\";s:1:\"#\";s:19:\"header_socials_xing\";s:0:\"\";s:24:\"header_socials_pinterest\";s:0:\"\";s:20:\"header_socials_skype\";s:0:\"\";s:23:\"header_socials_dribbble\";s:0:\"\";s:17:\"header_socials_vk\";s:1:\"#\";s:21:\"header_socials_tumblr\";s:0:\"\";s:25:\"header_socials_soundcloud\";s:1:\"#\";s:21:\"header_socials_twitch\";s:0:\"\";s:19:\"header_socials_yelp\";s:0:\"\";s:25:\"header_socials_deviantart\";s:1:\"#\";s:25:\"header_socials_foursquare\";s:0:\"\";s:21:\"header_socials_github\";s:0:\"\";s:28:\"header_socials_odnoklassniki\";s:0:\"\";s:21:\"header_socials_s500px\";s:0:\"\";s:20:\"header_socials_houzz\";s:0:\"\";s:21:\"header_socials_medium\";s:0:\"\";s:26:\"header_socials_tripadvisor\";s:0:\"\";s:18:\"header_socials_rss\";s:0:\"\";s:25:\"header_socials_custom_url\";s:0:\"\";s:26:\"header_socials_custom_icon\";s:0:\"\";s:20:\"header_language_show\";s:1:\"0\";s:22:\"header_language_source\";s:3:\"own\";s:17:\"header_link_title\";s:7:\"English\";s:15:\"header_link_qty\";s:1:\"3\";s:19:\"header_link_1_label\";s:7:\"Spanish\";s:17:\"header_link_1_url\";s:1:\"#\";s:19:\"header_link_2_label\";s:6:\"German\";s:17:\"header_link_2_url\";s:1:\"#\";s:19:\"header_link_3_label\";s:7:\"Russian\";s:17:\"header_link_3_url\";s:1:\"#\";s:19:\"header_link_4_label\";s:0:\"\";s:17:\"header_link_4_url\";s:0:\"\";s:19:\"header_link_5_label\";s:0:\"\";s:17:\"header_link_5_url\";s:0:\"\";s:19:\"header_link_6_label\";s:0:\"\";s:17:\"header_link_6_url\";s:0:\"\";s:19:\"header_link_7_label\";s:0:\"\";s:17:\"header_link_7_url\";s:0:\"\";s:19:\"header_link_8_label\";s:0:\"\";s:17:\"header_link_8_url\";s:0:\"\";s:19:\"header_link_9_label\";s:0:\"\";s:17:\"header_link_9_url\";s:0:\"\";s:9:\"logo_type\";s:4:\"text\";s:9:\"logo_text\";s:23:\"<strong>ZEPHYR</strong>\";s:14:\"logo_font_size\";s:2:\"27\";s:22:\"logo_font_size_tablets\";s:2:\"24\";s:22:\"logo_font_size_mobiles\";s:2:\"20\";s:10:\"logo_image\";s:0:\"\";s:11:\"logo_height\";s:2:\"30\";s:18:\"logo_height_sticky\";s:2:\"30\";s:19:\"logo_height_tablets\";s:2:\"30\";s:19:\"logo_height_mobiles\";s:2:\"30\";s:22:\"logo_image_transparent\";s:0:\"\";s:18:\"logo_image_tablets\";s:0:\"\";s:18:\"logo_image_mobiles\";s:0:\"\";s:13:\"menu_fontsize\";s:2:\"16\";s:12:\"menu_indents\";i:40;s:11:\"menu_height\";s:1:\"0\";s:20:\"menu_dropdown_effect\";s:7:\"mdesign\";s:17:\"menu_sub_fontsize\";s:2:\"15\";s:17:\"menu_mobile_width\";s:4:\"1000\";s:19:\"menu_togglable_type\";s:1:\"1\";s:16:\"titlebar_content\";s:3:\"all\";s:13:\"titlebar_size\";s:5:\"large\";s:14:\"titlebar_color\";s:9:\"alternate\";s:26:\"titlebar_portfolio_content\";s:3:\"all\";s:23:\"titlebar_portfolio_size\";s:5:\"large\";s:24:\"titlebar_portfolio_color\";s:9:\"alternate\";s:24:\"titlebar_archive_content\";s:3:\"all\";s:21:\"titlebar_archive_size\";s:5:\"large\";s:22:\"titlebar_archive_color\";s:9:\"alternate\";s:21:\"titlebar_post_content\";s:4:\"hide\";s:19:\"titlebar_post_title\";s:4:\"Blog\";s:18:\"titlebar_post_size\";s:6:\"medium\";s:19:\"titlebar_post_color\";s:9:\"alternate\";s:16:\"body_font_family\";s:10:\"IRANSans5|\";s:13:\"body_fontsize\";s:2:\"14\";s:20:\"body_fontsize_mobile\";s:2:\"15\";s:15:\"body_lineheight\";s:2:\"24\";s:22:\"body_lineheight_mobile\";s:2:\"26\";s:19:\"heading_font_family\";s:10:\"IRANSans5|\";s:11:\"h1_fontsize\";s:2:\"40\";s:18:\"h1_fontsize_mobile\";s:2:\"30\";s:16:\"h1_letterspacing\";s:1:\"0\";s:12:\"h1_transform\";s:0:\"\";s:11:\"h2_fontsize\";s:2:\"33\";s:18:\"h2_fontsize_mobile\";s:2:\"26\";s:16:\"h2_letterspacing\";s:1:\"0\";s:12:\"h2_transform\";s:0:\"\";s:11:\"h3_fontsize\";s:2:\"28\";s:18:\"h3_fontsize_mobile\";s:2:\"22\";s:16:\"h3_letterspacing\";s:1:\"0\";s:12:\"h3_transform\";s:0:\"\";s:11:\"h4_fontsize\";s:2:\"24\";s:18:\"h4_fontsize_mobile\";s:2:\"20\";s:16:\"h4_letterspacing\";s:1:\"0\";s:12:\"h4_transform\";s:0:\"\";s:11:\"h5_fontsize\";s:2:\"20\";s:18:\"h5_fontsize_mobile\";s:2:\"18\";s:16:\"h5_letterspacing\";s:1:\"0\";s:12:\"h5_transform\";s:0:\"\";s:11:\"h6_fontsize\";s:2:\"18\";s:18:\"h6_fontsize_mobile\";s:2:\"16\";s:16:\"h6_letterspacing\";s:1:\"0\";s:12:\"h6_transform\";s:0:\"\";s:16:\"menu_font_family\";s:10:\"IRANSans5|\";s:11:\"font_subset\";s:5:\"latin\";s:17:\"portfolio_sidebar\";s:4:\"none\";s:20:\"portfolio_sidebar_id\";s:15:\"default_sidebar\";s:18:\"portfolio_comments\";s:1:\"0\";s:19:\"portfolio_sided_nav\";s:1:\"1\";s:27:\"portfolio_prevnext_category\";s:1:\"0\";s:14:\"portfolio_slug\";s:9:\"portfolio\";s:23:\"portfolio_category_slug\";s:18:\"portfolio_category\";s:28:\"portfolio_breakpoint_1_width\";i:1200;s:27:\"portfolio_breakpoint_1_cols\";s:1:\"3\";s:28:\"portfolio_breakpoint_2_width\";i:900;s:27:\"portfolio_breakpoint_2_cols\";s:1:\"2\";s:28:\"portfolio_breakpoint_3_width\";i:600;s:27:\"portfolio_breakpoint_3_cols\";s:1:\"1\";s:12:\"post_sidebar\";s:5:\"right\";s:15:\"post_sidebar_id\";s:15:\"default_sidebar\";s:19:\"post_preview_layout\";s:5:\"basic\";s:9:\"post_meta\";a:5:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:4:\"tags\";}s:12:\"post_sharing\";s:1:\"1\";s:17:\"post_sharing_type\";s:5:\"solid\";s:22:\"post_sharing_providers\";a:7:{i:0;s:5:\"email\";i:1;s:8:\"facebook\";i:2;s:7:\"twitter\";i:3;s:5:\"gplus\";i:4;s:8:\"linkedin\";i:5;s:9:\"pinterest\";i:6;s:2:\"vk\";}s:15:\"post_author_box\";s:1:\"1\";s:8:\"post_nav\";s:1:\"1\";s:17:\"post_nav_category\";s:1:\"0\";s:12:\"post_related\";s:1:\"1\";s:19:\"post_related_layout\";s:7:\"related\";s:12:\"blog_sidebar\";s:5:\"right\";s:15:\"blog_sidebar_id\";s:15:\"default_sidebar\";s:11:\"blog_layout\";s:7:\"classic\";s:9:\"blog_type\";s:4:\"grid\";s:9:\"blog_cols\";s:1:\"1\";s:17:\"blog_content_type\";s:7:\"excerpt\";s:9:\"blog_meta\";a:6:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:4:\"tags\";i:5;s:9:\"read_more\";}s:15:\"blog_pagination\";s:7:\"regular\";s:15:\"archive_sidebar\";s:5:\"right\";s:18:\"archive_sidebar_id\";s:15:\"default_sidebar\";s:14:\"archive_layout\";s:7:\"classic\";s:12:\"archive_type\";s:4:\"grid\";s:12:\"archive_cols\";s:1:\"2\";s:20:\"archive_content_type\";s:7:\"excerpt\";s:12:\"archive_meta\";a:6:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:4:\"tags\";i:5;s:9:\"read_more\";}s:18:\"archive_pagination\";s:4:\"ajax\";s:14:\"search_sidebar\";s:5:\"right\";s:17:\"search_sidebar_id\";s:15:\"default_sidebar\";s:13:\"search_layout\";s:7:\"compact\";s:11:\"search_type\";s:4:\"grid\";s:11:\"search_cols\";s:1:\"1\";s:19:\"search_content_type\";s:7:\"excerpt\";s:11:\"search_meta\";a:1:{i:0;s:4:\"date\";}s:17:\"search_pagination\";s:4:\"ajax\";s:14:\"excerpt_length\";s:2:\"40\";s:23:\"blog_breakpoint_1_width\";i:1200;s:22:\"blog_breakpoint_1_cols\";s:1:\"3\";s:23:\"blog_breakpoint_2_width\";i:900;s:22:\"blog_breakpoint_2_cols\";s:1:\"2\";s:23:\"blog_breakpoint_3_width\";i:600;s:22:\"blog_breakpoint_3_cols\";s:1:\"1\";s:21:\"shop_titlebar_content\";s:4:\"hide\";s:12:\"shop_sidebar\";s:5:\"right\";s:15:\"shop_sidebar_id\";s:12:\"shop_sidebar\";s:15:\"product_sidebar\";s:5:\"right\";s:18:\"product_sidebar_id\";s:12:\"shop_sidebar\";s:18:\"shop_listing_style\";s:6:\"modern\";s:12:\"shop_columns\";s:1:\"3\";s:19:\"product_related_qty\";s:1:\"3\";s:9:\"shop_cart\";s:7:\"compact\";s:12:\"shop_catalog\";i:0;s:13:\"forum_sidebar\";s:5:\"right\";s:16:\"forum_sidebar_id\";s:15:\"default_sidebar\";s:16:\"enable_portfolio\";i:1;s:19:\"enable_testimonials\";i:1;s:13:\"jquery_footer\";i:0;s:22:\"disable_jquery_migrate\";i:1;s:12:\"ajax_load_js\";i:0;s:17:\"generate_css_file\";b:0;s:16:\"disable_extra_vc\";i:1;s:14:\"blog_img_width\";s:3:\"600\";s:15:\"blog_img_height\";s:3:\"400\";s:10:\"custom_css\";s:0:\"\";s:11:\"custom_html\";s:0:\"\";s:8:\"of_reset\";s:0:\"\";s:10:\"minify_css\";i:1;s:12:\"blog_masonry\";i:0;s:15:\"archive_masonry\";i:0;s:14:\"search_masonry\";i:0;s:20:\"change_header_colors\";s:1:\"0\";s:18:\"change_menu_colors\";s:1:\"0\";s:21:\"change_content_colors\";s:1:\"0\";s:23:\"change_subfooter_colors\";s:1:\"0\";s:23:\"color_subfooter_heading\";s:7:\"#9e9e9e\";s:20:\"change_footer_colors\";s:1:\"0\";s:15:\"footer_show_top\";s:1:\"1\";s:14:\"footer_columns\";s:1:\"3\";s:18:\"footer_show_bottom\";s:1:\"1\";s:16:\"footer_copyright\";s:91:\"© 2016 All rights reserved. ZEPHYR theme by <a href=\"http://us-themes.com/\">UpSolution</a>\";}}", "no");
INSERT INTO `wp_options` VALUES("155", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("366", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("179", "ztjalali_options", "{\"force_timezone\":false,\"change_date_to_jalali\":true,\"change_jdate_number_to_persian\":true,\"change_url_date_to_jalali\":false,\"afghan_month_name\":false,\"disallow_month_short_name\":true,\"change_title_number_to_persian\":true,\"change_content_number_to_persian\":true,\"change_excerpt_number_to_persian\":true,\"change_comment_number_to_persian\":true,\"change_commentcount_number_to_persian\":false,\"change_category_number_to_persian\":false,\"change_point_to_persian\":true,\"change_arabic_to_persian\":false,\"change_archive_title\":true,\"save_changes_in_db\":false,\"ztjalali_admin_style\":false,\"persian_planet\":true}", "yes");
INSERT INTO `wp_options` VALUES("177", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `wp_options` VALUES("176", "vc_version", "7.0", "yes");
INSERT INTO `wp_options` VALUES("180", "ztjalali_version", "5.0.1", "yes");
INSERT INTO `wp_options` VALUES("182", "widget_ztjalali_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("183", "widget_ztjalali_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("367", "revslider-latest-version", "6.6.18", "yes");
INSERT INTO `wp_options` VALUES("368", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wp_options` VALUES("188", "revslider-update-check-short", "1699191194", "yes");
INSERT INTO `wp_options` VALUES("189", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("369", "revslider-notices", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("296", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("401", "us_portfolio_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("195", "revslider-valid-notice", "false", "yes");
INSERT INTO `wp_options` VALUES("200", "revslider-templates-check", "1698997938", "yes");
INSERT INTO `wp_options` VALUES("199", "usof_options_زفایر", "a:248:{s:9:\"preloader\";s:8:\"disabled\";s:15:\"preloader_image\";s:0:\"\";s:12:\"page_sidebar\";s:4:\"none\";s:17:\"generate_css_file\";i:0;s:10:\"og_enabled\";i:1;s:32:\"enable_unsupported_vc_shortcodes\";i:0;s:11:\"custom_html\";s:0:\"\";s:17:\"responsive_layout\";i:1;s:13:\"canvas_layout\";s:4:\"wide\";s:13:\"color_body_bg\";s:7:\"#e0e0e0\";s:13:\"body_bg_image\";s:0:\"\";s:20:\"body_bg_image_repeat\";s:6:\"repeat\";s:22:\"body_bg_image_position\";s:10:\"top_center\";s:24:\"body_bg_image_attachment\";s:6:\"scroll\";s:18:\"body_bg_image_size\";s:5:\"cover\";s:17:\"site_canvas_width\";i:1300;s:18:\"site_content_width\";i:1140;s:13:\"sidebar_width\";i:25;s:13:\"content_width\";i:70;s:22:\"columns_stacking_width\";i:767;s:21:\"disable_effects_width\";i:900;s:22:\"color_header_middle_bg\";s:7:\"#7049ba\";s:24:\"color_header_middle_text\";s:7:\"#ffffff\";s:30:\"color_header_middle_text_hover\";s:7:\"#ffffff\";s:19:\"color_header_top_bg\";s:7:\"#6039a8\";s:21:\"color_header_top_text\";s:7:\"#c8b8e5\";s:27:\"color_header_top_text_hover\";s:7:\"#ffffff\";s:22:\"color_header_bottom_bg\";s:7:\"#6039a8\";s:24:\"color_header_bottom_text\";s:7:\"#c8b8e5\";s:30:\"color_header_bottom_text_hover\";s:7:\"#ffffff\";s:29:\"color_header_transparent_text\";s:7:\"#ffffff\";s:35:\"color_header_transparent_text_hover\";s:7:\"#ffffff\";s:22:\"color_header_search_bg\";s:7:\"#7049ba\";s:24:\"color_header_search_text\";s:7:\"#ffffff\";s:19:\"color_menu_hover_bg\";s:7:\"#6039a8\";s:21:\"color_menu_hover_text\";s:7:\"#ffffff\";s:22:\"color_menu_active_text\";s:7:\"#ffc670\";s:34:\"color_menu_transparent_active_text\";s:7:\"#ffc670\";s:13:\"color_drop_bg\";s:7:\"#ffffff\";s:15:\"color_drop_text\";s:7:\"#212121\";s:19:\"color_drop_hover_bg\";s:4:\"#eee\";s:21:\"color_drop_hover_text\";s:7:\"#212121\";s:20:\"color_drop_active_bg\";s:7:\"#f7f7f7\";s:22:\"color_drop_active_text\";s:7:\"#7049ba\";s:20:\"color_menu_button_bg\";s:7:\"#ffffff\";s:22:\"color_menu_button_text\";s:7:\"#7049ba\";s:26:\"color_menu_button_hover_bg\";s:7:\"#ffffff\";s:28:\"color_menu_button_hover_text\";s:7:\"#7049ba\";s:16:\"color_content_bg\";s:7:\"#ffffff\";s:20:\"color_content_bg_alt\";s:7:\"#f5f5f5\";s:20:\"color_content_border\";s:7:\"#e0e0e0\";s:21:\"color_content_heading\";s:7:\"#212121\";s:18:\"color_content_text\";s:7:\"#424242\";s:21:\"color_content_primary\";s:7:\"#7049ba\";s:23:\"color_content_secondary\";s:7:\"#ffb03a\";s:19:\"color_content_faded\";s:7:\"#9e9e9e\";s:18:\"color_subfooter_bg\";s:7:\"#212121\";s:22:\"color_subfooter_bg_alt\";s:7:\"#292929\";s:22:\"color_subfooter_border\";s:4:\"#333\";s:20:\"color_subfooter_text\";s:7:\"#757575\";s:23:\"color_subfooter_heading\";s:7:\"#9e9e9e\";s:20:\"color_subfooter_link\";s:7:\"#9e9e9e\";s:26:\"color_subfooter_link_hover\";s:7:\"#ffb03a\";s:15:\"color_footer_bg\";s:4:\"#111\";s:17:\"color_footer_text\";s:7:\"#757575\";s:17:\"color_footer_link\";s:7:\"#9e9e9e\";s:23:\"color_footer_link_hover\";s:7:\"#ffb03a\";s:11:\"color_style\";i:1;s:20:\"change_header_colors\";i:0;s:18:\"change_menu_colors\";i:0;s:21:\"change_content_colors\";i:0;s:23:\"change_subfooter_colors\";i:0;s:20:\"change_footer_colors\";i:0;s:10:\"custom_css\";s:0:\"\";s:13:\"header_layout\";s:8:\"simple_1\";s:13:\"header_sticky\";a:3:{i:0;s:7:\"default\";i:1;s:7:\"tablets\";i:2;s:7:\"mobiles\";}s:18:\"header_transparent\";i:0;s:16:\"header_fullwidth\";i:0;s:17:\"header_top_height\";i:40;s:24:\"header_top_sticky_height\";i:0;s:20:\"header_middle_height\";i:100;s:27:\"header_middle_sticky_height\";i:50;s:20:\"header_bottom_height\";i:50;s:27:\"header_bottom_sticky_height\";i:50;s:17:\"header_main_width\";i:300;s:22:\"header_invert_logo_pos\";i:0;s:18:\"header_search_show\";i:1;s:20:\"header_search_layout\";s:10:\"fullscreen\";s:20:\"header_contacts_show\";i:0;s:21:\"header_contacts_phone\";s:0:\"\";s:21:\"header_contacts_email\";s:0:\"\";s:27:\"header_contacts_custom_icon\";s:0:\"\";s:27:\"header_contacts_custom_text\";s:0:\"\";s:19:\"header_socials_show\";i:0;s:23:\"header_socials_facebook\";s:0:\"\";s:22:\"header_socials_twitter\";s:0:\"\";s:21:\"header_socials_google\";s:0:\"\";s:23:\"header_socials_linkedin\";s:0:\"\";s:22:\"header_socials_youtube\";s:0:\"\";s:20:\"header_socials_vimeo\";s:0:\"\";s:21:\"header_socials_flickr\";s:0:\"\";s:22:\"header_socials_behance\";s:0:\"\";s:24:\"header_socials_instagram\";s:0:\"\";s:19:\"header_socials_xing\";s:0:\"\";s:24:\"header_socials_pinterest\";s:0:\"\";s:20:\"header_socials_skype\";s:0:\"\";s:23:\"header_socials_dribbble\";s:0:\"\";s:17:\"header_socials_vk\";s:0:\"\";s:21:\"header_socials_tumblr\";s:0:\"\";s:25:\"header_socials_soundcloud\";s:0:\"\";s:21:\"header_socials_twitch\";s:0:\"\";s:19:\"header_socials_yelp\";s:0:\"\";s:25:\"header_socials_deviantart\";s:0:\"\";s:25:\"header_socials_foursquare\";s:0:\"\";s:21:\"header_socials_github\";s:0:\"\";s:28:\"header_socials_odnoklassniki\";s:0:\"\";s:21:\"header_socials_s500px\";s:0:\"\";s:20:\"header_socials_houzz\";s:0:\"\";s:21:\"header_socials_medium\";s:0:\"\";s:26:\"header_socials_tripadvisor\";s:0:\"\";s:18:\"header_socials_rss\";s:0:\"\";s:25:\"header_socials_custom_url\";s:0:\"\";s:26:\"header_socials_custom_icon\";s:0:\"\";s:20:\"header_language_show\";i:0;s:22:\"header_language_source\";s:3:\"own\";s:17:\"header_link_title\";s:0:\"\";s:15:\"header_link_qty\";s:1:\"2\";s:19:\"header_link_1_label\";s:0:\"\";s:17:\"header_link_1_url\";s:0:\"\";s:19:\"header_link_2_label\";s:0:\"\";s:17:\"header_link_2_url\";s:0:\"\";s:19:\"header_link_3_label\";s:0:\"\";s:17:\"header_link_3_url\";s:0:\"\";s:19:\"header_link_4_label\";s:0:\"\";s:17:\"header_link_4_url\";s:0:\"\";s:19:\"header_link_5_label\";s:0:\"\";s:17:\"header_link_5_url\";s:0:\"\";s:19:\"header_link_6_label\";s:0:\"\";s:17:\"header_link_6_url\";s:0:\"\";s:19:\"header_link_7_label\";s:0:\"\";s:17:\"header_link_7_url\";s:0:\"\";s:19:\"header_link_8_label\";s:0:\"\";s:17:\"header_link_8_url\";s:0:\"\";s:19:\"header_link_9_label\";s:0:\"\";s:17:\"header_link_9_url\";s:0:\"\";s:9:\"logo_type\";s:4:\"text\";s:9:\"logo_text\";s:4:\"LOGO\";s:14:\"logo_font_size\";i:26;s:22:\"logo_font_size_tablets\";i:24;s:22:\"logo_font_size_mobiles\";i:20;s:10:\"logo_image\";s:0:\"\";s:11:\"logo_height\";i:60;s:18:\"logo_height_sticky\";i:60;s:19:\"logo_height_tablets\";i:40;s:19:\"logo_height_mobiles\";i:30;s:22:\"logo_image_transparent\";s:0:\"\";s:18:\"logo_image_tablets\";s:0:\"\";s:18:\"logo_image_mobiles\";s:0:\"\";s:13:\"menu_fontsize\";i:16;s:12:\"menu_indents\";i:40;s:11:\"menu_height\";i:0;s:20:\"menu_dropdown_effect\";s:7:\"mdesign\";s:17:\"menu_sub_fontsize\";i:15;s:17:\"menu_mobile_width\";i:900;s:19:\"menu_togglable_type\";i:1;s:16:\"titlebar_content\";s:3:\"all\";s:13:\"titlebar_size\";s:5:\"large\";s:14:\"titlebar_color\";s:9:\"alternate\";s:26:\"titlebar_portfolio_content\";s:3:\"all\";s:23:\"titlebar_portfolio_size\";s:5:\"large\";s:24:\"titlebar_portfolio_color\";s:9:\"alternate\";s:24:\"titlebar_archive_content\";s:3:\"all\";s:21:\"titlebar_archive_size\";s:6:\"medium\";s:22:\"titlebar_archive_color\";s:9:\"alternate\";s:15:\"footer_show_top\";i:0;s:14:\"footer_columns\";i:3;s:18:\"footer_show_bottom\";i:1;s:16:\"footer_copyright\";s:18:\"Any text goes here\";s:19:\"heading_font_family\";s:7:\"Rezvan|\";s:11:\"h1_fontsize\";s:2:\"40\";s:18:\"h1_fontsize_mobile\";s:2:\"30\";s:16:\"h1_letterspacing\";s:1:\"0\";s:11:\"h2_fontsize\";s:2:\"34\";s:18:\"h2_fontsize_mobile\";s:2:\"26\";s:16:\"h2_letterspacing\";s:1:\"0\";s:11:\"h3_fontsize\";s:2:\"28\";s:18:\"h3_fontsize_mobile\";s:2:\"22\";s:16:\"h3_letterspacing\";s:1:\"0\";s:11:\"h4_fontsize\";s:2:\"24\";s:18:\"h4_fontsize_mobile\";s:2:\"20\";s:16:\"h4_letterspacing\";s:1:\"0\";s:11:\"h5_fontsize\";s:2:\"20\";s:18:\"h5_fontsize_mobile\";s:2:\"18\";s:16:\"h5_letterspacing\";s:1:\"0\";s:11:\"h6_fontsize\";s:2:\"18\";s:18:\"h6_fontsize_mobile\";s:2:\"16\";s:16:\"h6_letterspacing\";s:1:\"0\";s:16:\"body_font_family\";s:7:\"BYekan|\";s:13:\"body_fontsize\";s:2:\"14\";s:20:\"body_fontsize_mobile\";s:2:\"16\";s:15:\"body_lineheight\";s:2:\"24\";s:22:\"body_lineheight_mobile\";s:2:\"28\";s:16:\"menu_font_family\";s:7:\"BYekan|\";s:11:\"font_subset\";s:5:\"latin\";s:17:\"portfolio_sidebar\";s:4:\"none\";s:18:\"portfolio_comments\";i:0;s:19:\"portfolio_sided_nav\";i:1;s:27:\"portfolio_prevnext_category\";i:0;s:14:\"portfolio_slug\";s:9:\"portfolio\";s:23:\"portfolio_category_slug\";s:18:\"portfolio_category\";s:12:\"post_sidebar\";s:5:\"right\";s:19:\"post_preview_layout\";s:5:\"basic\";s:9:\"post_meta\";a:5:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:4:\"tags\";}s:12:\"post_sharing\";i:0;s:17:\"post_sharing_type\";s:6:\"simple\";s:22:\"post_sharing_providers\";a:3:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:5:\"gplus\";}s:15:\"post_author_box\";i:0;s:8:\"post_nav\";i:0;s:17:\"post_nav_category\";i:0;s:12:\"post_related\";i:1;s:19:\"post_related_layout\";s:7:\"compact\";s:12:\"blog_sidebar\";s:5:\"right\";s:11:\"blog_layout\";s:7:\"classic\";s:9:\"blog_cols\";s:1:\"1\";s:17:\"blog_content_type\";s:7:\"excerpt\";s:9:\"blog_meta\";a:6:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:4:\"tags\";i:5;s:9:\"read_more\";}s:15:\"blog_pagination\";s:7:\"regular\";s:15:\"archive_sidebar\";s:5:\"right\";s:14:\"archive_layout\";s:11:\"smallcircle\";s:12:\"archive_cols\";s:1:\"1\";s:20:\"archive_content_type\";s:7:\"excerpt\";s:12:\"archive_meta\";a:4:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:8:\"comments\";i:3;s:4:\"tags\";}s:18:\"archive_pagination\";s:7:\"regular\";s:14:\"search_sidebar\";s:5:\"right\";s:13:\"search_layout\";s:7:\"compact\";s:11:\"search_cols\";s:1:\"1\";s:19:\"search_content_type\";s:7:\"excerpt\";s:11:\"search_meta\";a:1:{i:0;s:4:\"date\";}s:17:\"search_pagination\";s:7:\"regular\";s:14:\"excerpt_length\";s:2:\"55\";s:21:\"shop_titlebar_content\";s:4:\"hide\";s:12:\"shop_sidebar\";s:5:\"right\";s:15:\"product_sidebar\";s:5:\"right\";s:18:\"shop_listing_style\";s:1:\"2\";s:12:\"shop_columns\";s:1:\"3\";s:19:\"product_related_qty\";s:1:\"3\";s:13:\"forum_sidebar\";s:5:\"right\";s:8:\"of_reset\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("204", "revslider-global-settings", "{\"permission\":\"admin\",\"lang\":\"fa_IR\",\"allinclude\":\"true\",\"highContrast\":\"false\",\"includeids\":\"\",\"script\":{\"footer\":\"false\",\"defer\":\"false\",\"full\":\"false\"},\"imgcrossOrigin\":\"unset\",\"lazyloaddata\":\"\",\"fontdownload\":\"off\",\"fontawesomedisable\":\"false\",\"fonturl\":\"\",\"size\":{\"desktop\":\"1240\",\"notebook\":\"1024\",\"tablet\":\"768\",\"mobile\":\"480\"},\"customfonts\":\"\",\"customFontList\":[{\"family\":\"\",\"url\":\"\",\"frontend\":\"false\",\"backend\":\"true\",\"weights\":\"200,300,400,500,600,700,800,900\"}],\"tracking\":\"2023-01-29\"}", "yes");
INSERT INTO `wp_options` VALUES("205", "revslider_update_version", "6.6.0", "yes");
INSERT INTO `wp_options` VALUES("218", "usof_options_قالب زفایر", "a:248:{s:9:\"preloader\";s:8:\"disabled\";s:15:\"preloader_image\";s:0:\"\";s:12:\"page_sidebar\";s:4:\"none\";s:17:\"generate_css_file\";i:0;s:10:\"og_enabled\";i:1;s:32:\"enable_unsupported_vc_shortcodes\";i:0;s:11:\"custom_html\";s:0:\"\";s:17:\"responsive_layout\";i:1;s:13:\"canvas_layout\";s:4:\"wide\";s:13:\"color_body_bg\";s:7:\"#e0e0e0\";s:13:\"body_bg_image\";s:0:\"\";s:20:\"body_bg_image_repeat\";s:6:\"repeat\";s:22:\"body_bg_image_position\";s:10:\"top_center\";s:24:\"body_bg_image_attachment\";s:6:\"scroll\";s:18:\"body_bg_image_size\";s:5:\"cover\";s:17:\"site_canvas_width\";i:1300;s:18:\"site_content_width\";i:1140;s:13:\"sidebar_width\";i:25;s:13:\"content_width\";i:70;s:22:\"columns_stacking_width\";i:767;s:21:\"disable_effects_width\";i:900;s:22:\"color_header_middle_bg\";s:7:\"#7049ba\";s:24:\"color_header_middle_text\";s:7:\"#ffffff\";s:30:\"color_header_middle_text_hover\";s:7:\"#ffffff\";s:19:\"color_header_top_bg\";s:7:\"#6039a8\";s:21:\"color_header_top_text\";s:7:\"#c8b8e5\";s:27:\"color_header_top_text_hover\";s:7:\"#ffffff\";s:22:\"color_header_bottom_bg\";s:7:\"#6039a8\";s:24:\"color_header_bottom_text\";s:7:\"#c8b8e5\";s:30:\"color_header_bottom_text_hover\";s:7:\"#ffffff\";s:29:\"color_header_transparent_text\";s:7:\"#ffffff\";s:35:\"color_header_transparent_text_hover\";s:7:\"#ffffff\";s:22:\"color_header_search_bg\";s:7:\"#7049ba\";s:24:\"color_header_search_text\";s:7:\"#ffffff\";s:19:\"color_menu_hover_bg\";s:7:\"#6039a8\";s:21:\"color_menu_hover_text\";s:7:\"#ffffff\";s:22:\"color_menu_active_text\";s:7:\"#ffc670\";s:34:\"color_menu_transparent_active_text\";s:7:\"#ffc670\";s:13:\"color_drop_bg\";s:7:\"#ffffff\";s:15:\"color_drop_text\";s:7:\"#212121\";s:19:\"color_drop_hover_bg\";s:4:\"#eee\";s:21:\"color_drop_hover_text\";s:7:\"#212121\";s:20:\"color_drop_active_bg\";s:7:\"#f7f7f7\";s:22:\"color_drop_active_text\";s:7:\"#7049ba\";s:20:\"color_menu_button_bg\";s:7:\"#ffffff\";s:22:\"color_menu_button_text\";s:7:\"#7049ba\";s:26:\"color_menu_button_hover_bg\";s:7:\"#ffffff\";s:28:\"color_menu_button_hover_text\";s:7:\"#7049ba\";s:16:\"color_content_bg\";s:7:\"#ffffff\";s:20:\"color_content_bg_alt\";s:7:\"#f5f5f5\";s:20:\"color_content_border\";s:7:\"#e0e0e0\";s:21:\"color_content_heading\";s:7:\"#212121\";s:18:\"color_content_text\";s:7:\"#424242\";s:21:\"color_content_primary\";s:7:\"#7049ba\";s:23:\"color_content_secondary\";s:7:\"#ffb03a\";s:19:\"color_content_faded\";s:7:\"#9e9e9e\";s:18:\"color_subfooter_bg\";s:7:\"#212121\";s:22:\"color_subfooter_bg_alt\";s:7:\"#292929\";s:22:\"color_subfooter_border\";s:4:\"#333\";s:20:\"color_subfooter_text\";s:7:\"#757575\";s:23:\"color_subfooter_heading\";s:7:\"#9e9e9e\";s:20:\"color_subfooter_link\";s:7:\"#9e9e9e\";s:26:\"color_subfooter_link_hover\";s:7:\"#ffb03a\";s:15:\"color_footer_bg\";s:4:\"#111\";s:17:\"color_footer_text\";s:7:\"#757575\";s:17:\"color_footer_link\";s:7:\"#9e9e9e\";s:23:\"color_footer_link_hover\";s:7:\"#ffb03a\";s:11:\"color_style\";i:1;s:20:\"change_header_colors\";i:0;s:18:\"change_menu_colors\";i:0;s:21:\"change_content_colors\";i:0;s:23:\"change_subfooter_colors\";i:0;s:20:\"change_footer_colors\";i:0;s:10:\"custom_css\";s:0:\"\";s:13:\"header_layout\";s:8:\"simple_1\";s:13:\"header_sticky\";a:3:{i:0;s:7:\"default\";i:1;s:7:\"tablets\";i:2;s:7:\"mobiles\";}s:18:\"header_transparent\";i:0;s:16:\"header_fullwidth\";i:0;s:17:\"header_top_height\";i:40;s:24:\"header_top_sticky_height\";i:0;s:20:\"header_middle_height\";i:100;s:27:\"header_middle_sticky_height\";i:50;s:20:\"header_bottom_height\";i:50;s:27:\"header_bottom_sticky_height\";i:50;s:17:\"header_main_width\";i:300;s:22:\"header_invert_logo_pos\";i:0;s:18:\"header_search_show\";i:1;s:20:\"header_search_layout\";s:10:\"fullscreen\";s:20:\"header_contacts_show\";i:0;s:21:\"header_contacts_phone\";s:0:\"\";s:21:\"header_contacts_email\";s:0:\"\";s:27:\"header_contacts_custom_icon\";s:0:\"\";s:27:\"header_contacts_custom_text\";s:0:\"\";s:19:\"header_socials_show\";i:0;s:23:\"header_socials_facebook\";s:0:\"\";s:22:\"header_socials_twitter\";s:0:\"\";s:21:\"header_socials_google\";s:0:\"\";s:23:\"header_socials_linkedin\";s:0:\"\";s:22:\"header_socials_youtube\";s:0:\"\";s:20:\"header_socials_vimeo\";s:0:\"\";s:21:\"header_socials_flickr\";s:0:\"\";s:22:\"header_socials_behance\";s:0:\"\";s:24:\"header_socials_instagram\";s:0:\"\";s:19:\"header_socials_xing\";s:0:\"\";s:24:\"header_socials_pinterest\";s:0:\"\";s:20:\"header_socials_skype\";s:0:\"\";s:23:\"header_socials_dribbble\";s:0:\"\";s:17:\"header_socials_vk\";s:0:\"\";s:21:\"header_socials_tumblr\";s:0:\"\";s:25:\"header_socials_soundcloud\";s:0:\"\";s:21:\"header_socials_twitch\";s:0:\"\";s:19:\"header_socials_yelp\";s:0:\"\";s:25:\"header_socials_deviantart\";s:0:\"\";s:25:\"header_socials_foursquare\";s:0:\"\";s:21:\"header_socials_github\";s:0:\"\";s:28:\"header_socials_odnoklassniki\";s:0:\"\";s:21:\"header_socials_s500px\";s:0:\"\";s:20:\"header_socials_houzz\";s:0:\"\";s:21:\"header_socials_medium\";s:0:\"\";s:26:\"header_socials_tripadvisor\";s:0:\"\";s:18:\"header_socials_rss\";s:0:\"\";s:25:\"header_socials_custom_url\";s:0:\"\";s:26:\"header_socials_custom_icon\";s:0:\"\";s:20:\"header_language_show\";i:0;s:22:\"header_language_source\";s:3:\"own\";s:17:\"header_link_title\";s:0:\"\";s:15:\"header_link_qty\";s:1:\"2\";s:19:\"header_link_1_label\";s:0:\"\";s:17:\"header_link_1_url\";s:0:\"\";s:19:\"header_link_2_label\";s:0:\"\";s:17:\"header_link_2_url\";s:0:\"\";s:19:\"header_link_3_label\";s:0:\"\";s:17:\"header_link_3_url\";s:0:\"\";s:19:\"header_link_4_label\";s:0:\"\";s:17:\"header_link_4_url\";s:0:\"\";s:19:\"header_link_5_label\";s:0:\"\";s:17:\"header_link_5_url\";s:0:\"\";s:19:\"header_link_6_label\";s:0:\"\";s:17:\"header_link_6_url\";s:0:\"\";s:19:\"header_link_7_label\";s:0:\"\";s:17:\"header_link_7_url\";s:0:\"\";s:19:\"header_link_8_label\";s:0:\"\";s:17:\"header_link_8_url\";s:0:\"\";s:19:\"header_link_9_label\";s:0:\"\";s:17:\"header_link_9_url\";s:0:\"\";s:9:\"logo_type\";s:4:\"text\";s:9:\"logo_text\";s:4:\"LOGO\";s:14:\"logo_font_size\";i:26;s:22:\"logo_font_size_tablets\";i:24;s:22:\"logo_font_size_mobiles\";i:20;s:10:\"logo_image\";s:0:\"\";s:11:\"logo_height\";i:60;s:18:\"logo_height_sticky\";i:60;s:19:\"logo_height_tablets\";i:40;s:19:\"logo_height_mobiles\";i:30;s:22:\"logo_image_transparent\";s:0:\"\";s:18:\"logo_image_tablets\";s:0:\"\";s:18:\"logo_image_mobiles\";s:0:\"\";s:13:\"menu_fontsize\";i:16;s:12:\"menu_indents\";i:40;s:11:\"menu_height\";i:0;s:20:\"menu_dropdown_effect\";s:7:\"mdesign\";s:17:\"menu_sub_fontsize\";i:15;s:17:\"menu_mobile_width\";i:900;s:19:\"menu_togglable_type\";i:1;s:16:\"titlebar_content\";s:3:\"all\";s:13:\"titlebar_size\";s:5:\"large\";s:14:\"titlebar_color\";s:9:\"alternate\";s:26:\"titlebar_portfolio_content\";s:3:\"all\";s:23:\"titlebar_portfolio_size\";s:5:\"large\";s:24:\"titlebar_portfolio_color\";s:9:\"alternate\";s:24:\"titlebar_archive_content\";s:3:\"all\";s:21:\"titlebar_archive_size\";s:6:\"medium\";s:22:\"titlebar_archive_color\";s:9:\"alternate\";s:15:\"footer_show_top\";i:0;s:14:\"footer_columns\";i:3;s:18:\"footer_show_bottom\";i:1;s:16:\"footer_copyright\";s:18:\"Any text goes here\";s:19:\"heading_font_family\";s:7:\"Rezvan|\";s:11:\"h1_fontsize\";s:2:\"40\";s:18:\"h1_fontsize_mobile\";s:2:\"30\";s:16:\"h1_letterspacing\";s:1:\"0\";s:11:\"h2_fontsize\";s:2:\"34\";s:18:\"h2_fontsize_mobile\";s:2:\"26\";s:16:\"h2_letterspacing\";s:1:\"0\";s:11:\"h3_fontsize\";s:2:\"28\";s:18:\"h3_fontsize_mobile\";s:2:\"22\";s:16:\"h3_letterspacing\";s:1:\"0\";s:11:\"h4_fontsize\";s:2:\"24\";s:18:\"h4_fontsize_mobile\";s:2:\"20\";s:16:\"h4_letterspacing\";s:1:\"0\";s:11:\"h5_fontsize\";s:2:\"20\";s:18:\"h5_fontsize_mobile\";s:2:\"18\";s:16:\"h5_letterspacing\";s:1:\"0\";s:11:\"h6_fontsize\";s:2:\"18\";s:18:\"h6_fontsize_mobile\";s:2:\"16\";s:16:\"h6_letterspacing\";s:1:\"0\";s:16:\"body_font_family\";s:7:\"BYekan|\";s:13:\"body_fontsize\";s:2:\"14\";s:20:\"body_fontsize_mobile\";s:2:\"16\";s:15:\"body_lineheight\";s:2:\"24\";s:22:\"body_lineheight_mobile\";s:2:\"28\";s:16:\"menu_font_family\";s:7:\"BYekan|\";s:11:\"font_subset\";s:5:\"latin\";s:17:\"portfolio_sidebar\";s:4:\"none\";s:18:\"portfolio_comments\";i:0;s:19:\"portfolio_sided_nav\";i:1;s:27:\"portfolio_prevnext_category\";i:0;s:14:\"portfolio_slug\";s:9:\"portfolio\";s:23:\"portfolio_category_slug\";s:18:\"portfolio_category\";s:12:\"post_sidebar\";s:5:\"right\";s:19:\"post_preview_layout\";s:5:\"basic\";s:9:\"post_meta\";a:5:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:4:\"tags\";}s:12:\"post_sharing\";i:0;s:17:\"post_sharing_type\";s:6:\"simple\";s:22:\"post_sharing_providers\";a:3:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:5:\"gplus\";}s:15:\"post_author_box\";i:0;s:8:\"post_nav\";i:0;s:17:\"post_nav_category\";i:0;s:12:\"post_related\";i:1;s:19:\"post_related_layout\";s:7:\"compact\";s:12:\"blog_sidebar\";s:5:\"right\";s:11:\"blog_layout\";s:7:\"classic\";s:9:\"blog_cols\";s:1:\"1\";s:17:\"blog_content_type\";s:7:\"excerpt\";s:9:\"blog_meta\";a:6:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:4:\"tags\";i:5;s:9:\"read_more\";}s:15:\"blog_pagination\";s:7:\"regular\";s:15:\"archive_sidebar\";s:5:\"right\";s:14:\"archive_layout\";s:11:\"smallcircle\";s:12:\"archive_cols\";s:1:\"1\";s:20:\"archive_content_type\";s:7:\"excerpt\";s:12:\"archive_meta\";a:4:{i:0;s:4:\"date\";i:1;s:6:\"author\";i:2;s:8:\"comments\";i:3;s:4:\"tags\";}s:18:\"archive_pagination\";s:7:\"regular\";s:14:\"search_sidebar\";s:5:\"right\";s:13:\"search_layout\";s:7:\"compact\";s:11:\"search_cols\";s:1:\"1\";s:19:\"search_content_type\";s:7:\"excerpt\";s:11:\"search_meta\";a:1:{i:0;s:4:\"date\";}s:17:\"search_pagination\";s:7:\"regular\";s:14:\"excerpt_length\";s:2:\"55\";s:21:\"shop_titlebar_content\";s:4:\"hide\";s:12:\"shop_sidebar\";s:5:\"right\";s:15:\"product_sidebar\";s:5:\"right\";s:18:\"shop_listing_style\";s:1:\"2\";s:12:\"shop_columns\";s:1:\"3\";s:19:\"product_related_qty\";s:1:\"3\";s:13:\"forum_sidebar\";s:5:\"right\";s:8:\"of_reset\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("809", "woocommerce_admin_notices", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("716", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("717", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("718", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("719", "woocommerce_default_customer_address", "", "yes");
INSERT INTO `wp_options` VALUES("720", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("721", "woocommerce_demo_store", "no", "yes");
INSERT INTO `wp_options` VALUES("722", "woocommerce_demo_store_notice", "This is a demo store for testing purposes &mdash; no orders shall be fulfilled.", "no");
INSERT INTO `wp_options` VALUES("723", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("325", "ewww_image_optimizer_bulk_attachments", "", "no");
INSERT INTO `wp_options` VALUES("326", "ewww_image_optimizer_flag_attachments", "", "no");
INSERT INTO `wp_options` VALUES("327", "ewww_image_optimizer_ngg_attachments", "", "no");
INSERT INTO `wp_options` VALUES("328", "ewww_image_optimizer_aux_attachments", "", "no");
INSERT INTO `wp_options` VALUES("329", "ewww_image_optimizer_defer_attachments", "", "no");
INSERT INTO `wp_options` VALUES("320", "ewww_image_optimizer_disable_pngout", "1", "yes");
INSERT INTO `wp_options` VALUES("321", "ewww_image_optimizer_optipng_level", "2", "yes");
INSERT INTO `wp_options` VALUES("322", "ewww_image_optimizer_pngout_level", "2", "yes");
INSERT INTO `wp_options` VALUES("323", "ewww_image_optimizer_version", "285.0", "yes");
INSERT INTO `wp_options` VALUES("335", "ewww_image_optimizer_bulk_resume", "", "yes");
INSERT INTO `wp_options` VALUES("568", "revslider-dashboard", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("569", "revslider-addons", "O:8:\"stdClass\":34:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"380\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:6:\"6.5.15\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"1.1.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2023-08-24\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particlewave.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"424\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"3.3.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2023-07-28\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"3.0.8\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"481\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:6:\"1.0.10\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_cluster.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"369\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2023-02-23\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_transition.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"507\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"3.1.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2023-05-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"418\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"499\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"3.1.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2023-10-06\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_mousetrap.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"500\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"420\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"3.1.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_lottie.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"411\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2023-08-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"483\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:6:\"6.5.17\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_charts.png\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2022-08-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_charts.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"422\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"421\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2023-07-17\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:84:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"416\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"423\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"3.0.9\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"498\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"407\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"397\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2023-07-08\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:80:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"419\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:81:\"//updates.themepunch-ext-b.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"414\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2022-02-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_domainswitch.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"415\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2023-06-12\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"399\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2022-01-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2022-12-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2023-08-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2023-06-12\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"402\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"406\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}}", "yes");
INSERT INTO `wp_options` VALUES("724", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `wp_options` VALUES("725", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("726", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wp_options` VALUES("727", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `wp_options` VALUES("728", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("729", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("730", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("731", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("732", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("733", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("734", "woocommerce_shop_page_id", "4756", "yes");
INSERT INTO `wp_options` VALUES("735", "woocommerce_shop_page_display", "", "yes");
INSERT INTO `wp_options` VALUES("736", "woocommerce_category_archive_display", "", "yes");
INSERT INTO `wp_options` VALUES("737", "woocommerce_default_catalog_orderby", "menu_order", "yes");
INSERT INTO `wp_options` VALUES("738", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("739", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("740", "shop_catalog_image_size", "a:3:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("741", "shop_single_image_size", "a:3:{s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("742", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";s:3:\"180\";s:6:\"height\";s:3:\"180\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("743", "woocommerce_enable_lightbox", "yes", "yes");
INSERT INTO `wp_options` VALUES("744", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("745", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("746", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("747", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("748", "woocommerce_stock_email_recipient", "robowp@yahoo.com", "no");
INSERT INTO `wp_options` VALUES("749", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("750", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("751", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("752", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("753", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("754", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("755", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("756", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("757", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("758", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("759", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("761", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("762", "woocommerce_tax_display_cart", "excl", "no");
INSERT INTO `wp_options` VALUES("763", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("764", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("765", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("766", "woocommerce_shipping_cost_requires_address", "no", "no");
INSERT INTO `wp_options` VALUES("767", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("768", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("769", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("770", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("771", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("772", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("773", "woocommerce_cart_page_id", "6134", "yes");
INSERT INTO `wp_options` VALUES("774", "woocommerce_checkout_page_id", "6136", "yes");
INSERT INTO `wp_options` VALUES("775", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("776", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("777", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("778", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("779", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("780", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("781", "woocommerce_myaccount_page_id", "6138", "yes");
INSERT INTO `wp_options` VALUES("782", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("783", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `wp_options` VALUES("784", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `wp_options` VALUES("785", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("786", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `wp_options` VALUES("787", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("788", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("789", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("790", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("791", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("792", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("793", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("794", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("795", "woocommerce_email_from_name", "روبو وردپرس", "no");
INSERT INTO `wp_options` VALUES("796", "woocommerce_email_from_address", "robowp@yahoo.com", "no");
INSERT INTO `wp_options` VALUES("797", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("798", "woocommerce_email_footer_text", "روبو وردپرس - Powered by WooCommerce", "no");
INSERT INTO `wp_options` VALUES("799", "woocommerce_email_base_color", "#557da1", "no");
INSERT INTO `wp_options` VALUES("800", "woocommerce_email_background_color", "#f5f5f5", "no");
INSERT INTO `wp_options` VALUES("801", "woocommerce_email_body_background_color", "#fdfdfd", "no");
INSERT INTO `wp_options` VALUES("802", "woocommerce_email_text_color", "#505050", "no");
INSERT INTO `wp_options` VALUES("803", "woocommerce_api_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("812", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("826", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("79211", "woocommerce_db_version", "8.2.1", "yes");
INSERT INTO `wp_options` VALUES("79229", "woocommerce_version", "8.2.1", "yes");
INSERT INTO `wp_options` VALUES("813", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("814", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("815", "widget_woocommerce_price_filter", "a:2:{i:2;a:1:{s:5:\"title\";s:34:\"فیلتر براساس قیمت :\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("816", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("817", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("818", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("819", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("820", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("821", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("822", "widget_woocommerce_recently_viewed_products", "a:2:{i:2;a:2:{s:5:\"title\";s:63:\"آخرین محصولات نمایش شده در ووکامرس\";s:6:\"number\";i:10;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("823", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("7767", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("13433", "Zephyr_editor_caps_set", "1", "yes");
INSERT INTO `wp_options` VALUES("7556", "dokan_allow_tracking", "no", "yes");
INSERT INTO `wp_options` VALUES("7557", "dokan_tracking_notice", "hide", "yes");
INSERT INTO `wp_options` VALUES("1933", "widget_cl-counter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1934", "widget_cl-flipbox", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1935", "widget_cl-ib", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1936", "widget_cl-itext", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1937", "widget_cl-popup", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1938", "widget_cl-review", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1551", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("1514", "us_widget_areas", "a:5:{s:12:\"shop_sidebar\";s:12:\"Shop Sidebar\";s:12:\"footer_first\";s:15:\"Footer Column 1\";s:13:\"footer_second\";s:15:\"Footer Column 2\";s:12:\"footer_third\";s:15:\"Footer Column 3\";s:13:\"footer_fourth\";s:15:\"Footer Column 4\";}", "yes");
INSERT INTO `wp_options` VALUES("2111", "bsf_skip_braisntorm_menu", "1", "no");
INSERT INTO `wp_options` VALUES("2103", "revslider-library-check", "1698402439", "yes");
INSERT INTO `wp_options` VALUES("2104", "rs-library", "a:3:{s:4:\"hash\";s:32:\"dae3de1eb57eeeee008b70e9a23844b5\";s:7:\"objects\";a:417:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:121;a:12:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:122;a:12:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:123;a:12:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:124;a:12:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:125;a:12:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:126;a:12:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:127;a:12:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:128;a:12:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:129;a:12:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:130;a:12:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:131;a:12:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:132;a:12:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:133;a:12:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:134;a:12:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:135;a:12:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:136;a:12:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:137;a:12:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:138;a:12:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:139;a:12:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:140;a:12:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:141;a:12:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:142;a:12:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:143;a:12:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:144;a:12:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:145;a:12:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:146;a:12:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:147;a:12:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:148;a:12:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:149;a:12:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:150;a:12:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:151;a:12:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:152;a:12:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:153;a:12:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:154;a:12:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:155;a:12:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:156;a:12:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:157;a:12:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:158;a:12:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:159;a:12:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:160;a:12:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:161;a:12:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:162;a:12:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:163;a:12:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:164;a:12:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:165;a:12:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:166;a:12:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:167;a:12:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:168;a:12:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:169;a:12:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:170;a:12:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:171;a:12:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:172;a:12:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:173;a:12:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:174;a:12:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:175;a:12:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:176;a:12:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:177;a:12:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:178;a:12:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:179;a:12:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:180;a:12:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:181;a:12:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:182;a:12:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:183;a:12:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:184;a:12:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:185;a:12:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:186;a:12:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:187;a:12:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:188;a:12:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:189;a:12:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:190;a:12:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:191;a:12:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:192;a:12:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:193;a:12:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:194;a:12:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:195;a:12:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:196;a:12:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:197;a:12:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:198;a:12:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:199;a:12:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:200;a:12:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:201;a:12:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:202;a:12:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:203;a:12:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:204;a:12:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:205;a:12:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:206;a:12:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:207;a:12:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:208;a:12:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:209;a:12:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:210;a:12:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:211;a:12:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:212;a:12:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:213;a:12:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:214;a:12:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:215;a:12:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:216;a:12:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:217;a:12:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:218;a:12:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:219;a:12:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:220;a:12:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:221;a:12:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:222;a:12:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:223;a:12:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:224;a:12:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:225;a:12:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:226;a:12:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:227;a:12:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:228;a:12:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:229;a:12:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:230;a:12:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:231;a:12:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:232;a:12:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:233;a:12:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:234;a:12:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:235;a:12:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:236;a:12:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:237;a:12:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:238;a:12:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:239;a:12:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:240;a:12:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:241;a:12:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:242;a:12:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:243;a:12:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:244;a:12:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:245;a:12:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:246;a:12:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:247;a:12:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:248;a:12:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:249;a:12:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:250;a:12:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:251;a:12:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:252;a:12:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:253;a:12:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:254;a:12:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:255;a:12:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:256;a:12:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:257;a:12:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:258;a:12:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:259;a:12:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:309;a:13:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:310;a:13:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:311;a:13:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:312;a:13:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:313;a:13:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:314;a:13:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:315;a:13:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:316;a:13:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:317;a:13:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:318;a:13:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:319;a:13:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:320;a:13:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:321;a:13:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:322;a:13:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:323;a:13:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:324;a:13:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:325;a:13:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:326;a:13:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:327;a:13:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:328;a:13:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:329;a:13:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:330;a:13:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:331;a:13:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:332;a:13:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:333;a:13:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:334;a:13:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:335;a:13:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:336;a:13:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:337;a:13:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:338;a:13:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:339;a:13:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:340;a:13:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:341;a:13:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:342;a:13:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:343;a:13:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:344;a:13:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:345;a:13:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:346;a:13:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:347;a:13:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:348;a:13:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:349;a:13:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:350;a:13:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:351;a:13:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:352;a:13:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:353;a:13:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:354;a:13:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:355;a:13:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:356;a:13:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:357;a:13:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:358;a:13:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:369;a:13:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:370;a:13:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:371;a:13:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:372;a:13:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:373;a:13:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:374;a:13:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:375;a:13:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:376;a:13:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:377;a:13:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:378;a:13:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:379;a:13:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:380;a:13:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:381;a:13:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:382;a:13:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:383;a:13:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:384;a:13:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:385;a:13:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:386;a:13:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:387;a:13:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:388;a:13:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:389;a:13:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:390;a:13:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:391;a:13:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:392;a:13:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:393;a:13:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:394;a:13:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:395;a:13:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:396;a:13:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:397;a:13:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:398;a:13:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:399;a:13:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:400;a:13:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:401;a:13:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:402;a:13:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:403;a:13:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:404;a:13:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:405;a:13:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:406;a:13:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:407;a:13:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:408;a:13:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:409;a:13:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:410;a:13:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:411;a:13:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:412;a:13:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:413;a:13:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:414;a:13:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:415;a:13:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:416;a:13:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "no");
INSERT INTO `wp_options` VALUES("1648", "edd_settings", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1649", "edd_use_php_sessions", "1", "yes");
INSERT INTO `wp_options` VALUES("14469", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2013", "ultimate_row", "enable", "yes");
INSERT INTO `wp_options` VALUES("2014", "ultimate_animation", "disable", "yes");
INSERT INTO `wp_options` VALUES("2015", "ultimate_vc_addons_redirect", "", "yes");
INSERT INTO `wp_options` VALUES("2016", "ultimate_js", "enable", "yes");
INSERT INTO `wp_options` VALUES("2017", "ultimate_css", "enable", "yes");
INSERT INTO `wp_options` VALUES("2018", "ultimate_google_fonts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2019", "ultimate_selected_google_fonts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2020", "bsf_local_transient", "1598619891", "yes");
INSERT INTO `wp_options` VALUES("2023", "ultimate_updater", "disabled", "yes");
INSERT INTO `wp_options` VALUES("2024", "ultimate_constants", "a:3:{s:24:\"ULTIMATE_NO_UPDATE_CHECK\";b:0;s:28:\"ULTIMATE_NO_EDIT_PAGE_NOTICE\";b:1;s:30:\"ULTIMATE_NO_PLUGIN_PAGE_NOTICE\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("2025", "ultimate_modules", "a:41:{i:0;s:18:\"ultimate_animation\";i:1;s:16:\"ultimate_buttons\";i:2;s:18:\"ultimate_countdown\";i:3;s:17:\"ultimate_flip_box\";i:4;s:20:\"ultimate_google_maps\";i:5;s:22:\"ultimate_google_trends\";i:6;s:17:\"ultimate_headings\";i:7;s:22:\"ultimate_icon_timeline\";i:8;s:17:\"ultimate_info_box\";i:9;s:20:\"ultimate_info_circle\";i:10;s:18:\"ultimate_info_list\";i:11;s:20:\"ultimate_info_tables\";i:12;s:28:\"ultimate_interactive_banners\";i:13;s:29:\"ultimate_interactive_banner_2\";i:14;s:15:\"ultimate_modals\";i:15;s:17:\"ultimate_parallax\";i:16;s:23:\"ultimate_pricing_tables\";i:17;s:15:\"ultimate_spacer\";i:18;s:22:\"ultimate_stats_counter\";i:19;s:20:\"ultimate_swatch_book\";i:20;s:14:\"ultimate_icons\";i:21;s:18:\"ultimate_list_icon\";i:22;s:17:\"ultimate_carousel\";i:23;s:18:\"ultimate_fancytext\";i:24;s:22:\"ultimate_highlight_box\";i:25;s:20:\"ultimate_info_banner\";i:26;s:15:\"ultimate_ihover\";i:27;s:16:\"ultimate_hotspot\";i:28;s:21:\"ultimate_video_banner\";i:29;s:11:\"woocomposer\";i:30;s:20:\"ultimate_dual_button\";i:31;s:13:\"ultimate_link\";i:32;s:19:\"ultimate_fancy_text\";i:33;s:23:\"ultimate_hightlight_box\";i:34;s:20:\"ultimate_content_box\";i:35;s:24:\"ultimate_image_separator\";i:36;s:27:\"ultimate_expandable_section\";i:37;s:12:\"ultimate_tab\";i:38;s:23:\"ultimate_sticky_section\";i:39;s:13:\"ultimate_team\";i:40;s:21:\"ultimate_range_slider\";}", "yes");
INSERT INTO `wp_options` VALUES("2026", "smile_fonts", "a:1:{s:8:\"Defaults\";a:4:{s:7:\"include\";s:20:\"smile_fonts/Defaults\";s:6:\"folder\";s:20:\"smile_fonts/Defaults\";s:5:\"style\";s:21:\"Defaults/Defaults.css\";s:6:\"config\";s:11:\"charmap.php\";}}", "yes");
INSERT INTO `wp_options` VALUES("2027", "brainstrom_products", "a:1:{s:7:\"plugins\";a:1:{i:6892199;a:32:{s:2:\"id\";s:7:\"6892199\";s:4:\"name\";s:41:\"Ultimate Addons for WPBakery Page Builder\";s:4:\"slug\";s:18:\"Ultimate_VC_Addons\";s:10:\"short_name\";s:0:\"\";s:11:\"description\";s:153:\"The top seller new plugin of 2016. Install Ultimate with WPBakery Page Builder and you will probably have everything you need to build stunning websites.\";s:7:\"version\";s:7:\"3.19.17\";s:12:\"download_url\";s:0:\"\";s:12:\"version_beta\";s:0:\"\";s:17:\"download_url_beta\";s:0:\"\";s:6:\"tested\";s:3:\"6.0\";s:14:\"privacy_policy\";s:132:\"https://store.brainstormforce.com/privacy-policy/?utm_source=license-form&utm_medium=privacy-policy&utm_campaign=graupi-license-form\";s:16:\"terms_conditions\";s:144:\"https://store.brainstormforce.com/terms-and-conditions/?utm_source=license-form&utm_medium=terms-and-conditions&utm_campaign=graupi-license-form\";s:12:\"purchase_url\";s:74:\"https://codecanyon.net/cart/add_items?item_ids=6892199&ref=BrainstormForce\";s:13:\"changelog_url\";s:47:\"https://ultimate.brainstormforce.com/changelog/\";s:4:\"type\";s:6:\"plugin\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:4:\"true\";s:15:\"is_product_free\";s:5:\"false\";s:14:\"has-extensions\";s:5:\"false\";s:13:\"support_forum\";s:37:\"http://brainstormforce.freshdesk.com/\";s:25:\"after_registration_action\";s:0:\"\";s:13:\"product_image\";s:65:\"//support.brainstormforce.com/wp-content/uploads/2017/07/uavc.jpg\";s:32:\"show_on_register_licence_listing\";s:4:\"true\";s:15:\"show_on_listing\";s:4:\"true\";s:13:\"is_support_on\";s:4:\"true\";s:14:\"envato_item_id\";s:7:\"6892199\";s:8:\"template\";s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";s:6:\"remote\";s:7:\"3.19.19\";s:12:\"purchase_key\";s:0:\"\";s:6:\"status\";s:14:\"not-registered\";s:7:\"message\";s:0:\"\";s:12:\"product_name\";s:41:\"Ultimate Addons for WPBakery Page Builder\";}}}", "yes");
INSERT INTO `wp_options` VALUES("55346", "bsf_skip_author", "", "no");
INSERT INTO `wp_options` VALUES("2028", "bsf_local_transient_bundled", "1598171711", "yes");
INSERT INTO `wp_options` VALUES("2106", "rs_tables_created", "1", "yes");
INSERT INTO `wp_options` VALUES("8224", "widget_us_blog", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6674", "rs_cache_overlay", "6.6.18", "yes");
INSERT INTO `wp_options` VALUES("5120", "woocommerce_shipping_debug_mode", "no", "no");
INSERT INTO `wp_options` VALUES("7530", "dokan_pages", "a:3:{s:9:\"dashboard\";i:6094;s:13:\"store_listing\";i:6095;s:9:\"my_orders\";i:6096;}", "yes");
INSERT INTO `wp_options` VALUES("7531", "dokan_pages_created", "1", "yes");
INSERT INTO `wp_options` VALUES("7532", "dokan_selling", "a:1:{s:13:\"product_style\";s:3:\"new\";}", "yes");
INSERT INTO `wp_options` VALUES("7533", "dokan_theme_version", "2.6.4", "yes");
INSERT INTO `wp_options` VALUES("7536", "widget_dokan-category-menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("7537", "widget_dokan-best-selling-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("7538", "widget_dokan-top-rated", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("7539", "widget_dokan-store-menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("7540", "widget_dokan-store-location", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("7541", "widget_dokan-store-contact-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("7543", "dokan_general", "", "yes");
INSERT INTO `wp_options` VALUES("7544", "dokan_withdraw", "", "yes");
INSERT INTO `wp_options` VALUES("7545", "dokan_appearance", "", "yes");
INSERT INTO `wp_options` VALUES("6294", "wc_customizer_version", "2.5.0", "yes");
INSERT INTO `wp_options` VALUES("13590", "theme_mods_Zephyr2", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:14:\"us_footer_menu\";i:29;s:12:\"us_main_menu\";i:30;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1514962621;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"default_sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:12:\"shop_sidebar\";a:2:{i:0;s:26:\"woocommerce_price_filter-2\";i:1;s:38:\"woocommerce_recently_viewed_products-2\";}s:12:\"footer_first\";a:1:{i:0;s:10:\"us_login-2\";}s:13:\"footer_second\";a:1:{i:0;s:14:\"us_portfolio-2\";}s:12:\"footer_third\";a:1:{i:0;s:12:\"us_socials-2\";}s:13:\"footer_fourth\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("13610", "woocommerce_gateway_order", "a:5:{s:4:\"bacs\";i:0;s:6:\"cheque\";i:1;s:3:\"cod\";i:2;s:6:\"paypal\";i:3;s:5:\"payir\";i:4;}", "yes");
INSERT INTO `wp_options` VALUES("14354", "us_addons_version", "8.19", "yes");
INSERT INTO `wp_options` VALUES("13494", "revslider_servers", "a:3:{i:0;s:22:\"themepunch-ext-b.tools\";i:1;s:22:\"themepunch-ext-c.tools\";i:2;s:22:\"themepunch-ext-a.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("13495", "revslider_server_refresh", "1699049770", "yes");
INSERT INTO `wp_options` VALUES("14452", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("16679", "show_comments_cookies_opt_in", "", "yes");
INSERT INTO `wp_options` VALUES("19383", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("20045", "revslider-templates-hash", "b6897ad1ea846c0481d544eb1b0f97e9", "yes");
INSERT INTO `wp_options` VALUES("16040", "usof_color_palette_Zephyr", "a:8:{i:0;s:7:\"#7049ba\";i:1;s:7:\"#ffb03a\";i:2;s:7:\"#212121\";i:3;s:7:\"#424242\";i:4;s:7:\"#9e9e9e\";i:5;s:7:\"#e0e0e0\";i:6;s:7:\"#f5f5f5\";i:7;s:7:\"#ffffff\";}", "yes");
INSERT INTO `wp_options` VALUES("15976", "us_dismiss_addons_install_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("15960", "woocommerce_placeholder_image", "6411", "yes");
INSERT INTO `wp_options` VALUES("15996", "license_key_token", "1541929057|XreVcigJRgA0rmdP1aT3", "yes");
INSERT INTO `wp_options` VALUES("17349", "revslider-valid", "true", "yes");
INSERT INTO `wp_options` VALUES("17350", "revslider-code", "active", "yes");
INSERT INTO `wp_options` VALUES("17351", "revslider-temp-active-notice", "false", "yes");
INSERT INTO `wp_options` VALUES("17356", "revslider-update-check", "1699198893", "yes");
INSERT INTO `wp_options` VALUES("17357", "revslider_update_info", "O:8:\"stdClass\":0:{}", "yes");
INSERT INTO `wp_options` VALUES("171287", "brainstrom_bundled_products", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("19085", "remove_google_fonts_configs", "a:1:{s:8:\"cssfiles\";a:527:{s:32:\"e5bef570431870e4a777baf031984ef3\";s:0:\"\";s:32:\"7da60b0c4b20fbc1a4444442edcca6df\";s:0:\"\";s:32:\"4562d2c297f998127b31c3d9b57ee447\";s:0:\"\";s:32:\"fbb29465a673eb4e5f7bce448873fb0e\";s:0:\"\";s:32:\"60cc4b61a97439c9f68f55a2cdaeead4\";s:0:\"\";s:32:\"de5e79dc6e4432501f3b2e7a93ac1171\";s:0:\"\";s:32:\"c3285d0af987d9121aa6f9816e152180\";s:0:\"\";s:32:\"6c7b74e2c7658ed843d2f4b860336621\";s:126:\"http://demo.parsplugin.com/upsolo/wp-content/plugins/remove-google-fonts-references/cache/6c7b74e2c7658ed843d2f4b860336621.css\";s:32:\"49c53d5e89ec927095330e8d1612b082\";s:0:\"\";s:32:\"1774e8e29d4a8d6a807ea7b120a1819d\";s:0:\"\";s:32:\"9320ea76a9b8264b99460c9d0747826e\";s:0:\"\";s:32:\"33b2cd1939629e8211c5cd409845b610\";s:0:\"\";s:32:\"b4fd884cb3897319466e322e4d5bd816\";s:0:\"\";s:32:\"45b0c87ccdc47d0a1c9fb68a5ab6edd0\";s:0:\"\";s:32:\"d96f8998e2235afac77b8d55d49c236d\";s:0:\"\";s:32:\"d770a7c1b92084910d63a3dfa86456da\";s:0:\"\";s:32:\"ef123d6cc3f1e77a8475c3c89c826d3b\";s:0:\"\";s:32:\"970dfee0bb27c841c5623f97e45bf57c\";s:0:\"\";s:32:\"a6f913fc72cb74c0ba0c9dbf506f596d\";s:0:\"\";s:32:\"71e7f62b580fa90dd3f0c1b05d12efd8\";s:0:\"\";s:32:\"537f097a83ae71f628991d46f84f9dc2\";s:0:\"\";s:32:\"733b4103db3e74b13a259bb95107f006\";s:0:\"\";s:32:\"b271248d96e60b86479cd01f18586136\";s:0:\"\";s:32:\"3654d076eabec92ee8be818ce6369b79\";s:0:\"\";s:32:\"6e23df29d818b67f34bb57c67a5eaafb\";s:0:\"\";s:32:\"8cb61033b1e0d50f9bdfcc55029c5dfd\";s:0:\"\";s:32:\"ae2d0371f8b7501b41d55779e10a5209\";s:0:\"\";s:32:\"ccc4a940f0d73943c2591522917cebbc\";s:0:\"\";s:32:\"914f3a5cf28d679efdd1519ab03f36db\";s:126:\"http://demo.parsplugin.com/upsolo/wp-content/plugins/remove-google-fonts-references/cache/914f3a5cf28d679efdd1519ab03f36db.css\";s:32:\"98aee22f11aeb311c1284897cc603cf1\";s:0:\"\";s:32:\"5890c2b2515fd8a9bf7c93b61c8e2cbb\";s:0:\"\";s:32:\"3e780c6716371baf1a327fc95d2e2ccd\";s:0:\"\";s:32:\"a83d21e306aa6f127ece80ce2600ad2e\";s:0:\"\";s:32:\"e7fd85b7382181eb69d445c8e4624cba\";s:0:\"\";s:32:\"11575798bb0a8ef2ddb94ecd29dfd015\";s:0:\"\";s:32:\"550f318785abfc38e2b395a91a13cdcd\";s:0:\"\";s:32:\"991a7c834a2b81b920076cae2ee81105\";s:0:\"\";s:32:\"1ebaa3ab34e626bad0ec8e5ad94cac33\";s:0:\"\";s:32:\"fd8121a47571729ac6103433cdb8c0fa\";s:0:\"\";s:32:\"25abaf4350fdd92e99871ffbe653835f\";s:0:\"\";s:32:\"8fd795d94cdc2499290fe9c598541392\";s:0:\"\";s:32:\"2d2a5fa0c6bcfbac9061c83f36e0b784\";s:0:\"\";s:32:\"312cbe8aa1e58c1008f64e680803556c\";s:0:\"\";s:32:\"d457b90c4d3b5ef431cf6f3d5da846f4\";s:0:\"\";s:32:\"ed4610189a26f5af537b13b9323cb597\";s:0:\"\";s:32:\"1ceb5b80e19a15a8bd41cc4717505080\";s:0:\"\";s:32:\"e8142a90f1b54333ed3617b9dd961627\";s:126:\"http://demo.parsplugin.com/upsolo/wp-content/plugins/remove-google-fonts-references/cache/e8142a90f1b54333ed3617b9dd961627.css\";s:32:\"e33b740e9dea55c5009bc8e9b5baec39\";s:0:\"\";s:32:\"9c60ab6f4e9f23bd4d8f319321d25e3e\";s:0:\"\";s:32:\"fdcc297d58fe42c9518de2b557823630\";s:0:\"\";s:32:\"dcc5f68e40c72f22247594c563a0767b\";s:0:\"\";s:32:\"98f29b1a203b0f4f217534b21378435a\";s:0:\"\";s:32:\"90e58a237aa815515259b440f2d8b3df\";s:0:\"\";s:32:\"08e97fac8428360f2c4bee97d23fab3c\";s:0:\"\";s:32:\"b7902db4077f06c18666da28395781c7\";s:0:\"\";s:32:\"c1b54cadf8be2094d6d652ea92fd9171\";s:0:\"\";s:32:\"b3647d4b950fb33d60dea5caa46d5103\";s:0:\"\";s:32:\"d24ce554d70cb72036586a54dd134ab6\";s:0:\"\";s:32:\"4baa0579190d70fc7f3824f5753dfdbe\";s:0:\"\";s:32:\"24dc66917ecf6b44b826f35651371f87\";s:0:\"\";s:32:\"d3f9f558eefdf941498da429053205f8\";s:0:\"\";s:32:\"f47bd3ee336b5e94fc5f968b0238be0e\";s:0:\"\";s:32:\"370c4978fd9a4486242f145867999667\";s:0:\"\";s:32:\"51d314156ee6bb657d57655362f2b1db\";s:0:\"\";s:32:\"7e4030a96b5f41f75b4f2ed88c9534ff\";s:0:\"\";s:32:\"7be3603e8b2f4fc75dea3661344a3481\";s:0:\"\";s:32:\"c6c8624b9eb87183ee273e23eda13119\";s:0:\"\";s:32:\"f36f1eca726d6000b19b8c2bad17400b\";s:0:\"\";s:32:\"b30bc72a935325ed37c6aaa9a9b68c04\";s:0:\"\";s:32:\"8bb1ea398a305a335efea051bb4428a7\";s:0:\"\";s:32:\"1a90e180185b60801fa9ebe31ccca504\";s:0:\"\";s:32:\"0bdaab40cf002d7666e23f6ab55618fc\";s:0:\"\";s:32:\"71910e95ccae62d0799be6b904825f99\";s:0:\"\";s:32:\"7a81f89cceb51585d29bb5b175cab1df\";s:0:\"\";s:32:\"f927a594a125aeaf15e23a3a6619c96d\";s:0:\"\";s:32:\"ce234a7ca5c6b997de9e96db423b300d\";s:0:\"\";s:32:\"9a7efadd2a4813cf292c2ef195bd5000\";s:0:\"\";s:32:\"ac0a8f4b8a1937a0b884e2dfa573b3ce\";s:0:\"\";s:32:\"dfe7c026aedf499d20213d4afac3b83d\";s:0:\"\";s:32:\"136710828eca28546e35c337af3ca55e\";s:0:\"\";s:32:\"2b12b532aa3dffbe1d8a9a85af6fbd57\";s:0:\"\";s:32:\"0843a464a938554d56ca3d8b280e14c3\";s:0:\"\";s:32:\"67517d1b09ec135be164b5661665cf79\";s:0:\"\";s:32:\"4b23ace3452ee8165e188aa499600fcf\";s:0:\"\";s:32:\"9e49aae1e1e9ee77e9d51349fc43b2c1\";s:0:\"\";s:32:\"b5e1c58fd3d0d617997be4a1c5d07171\";s:0:\"\";s:32:\"3bd8e4b4c9a4952239c9c83ccee5a792\";s:0:\"\";s:32:\"70168a6270b8ebddbb520e3ce77a50b6\";s:0:\"\";s:32:\"35d60af3334fd950190c8b446e3178c2\";s:0:\"\";s:32:\"0389411e98a3a6b195042c527f16b768\";s:0:\"\";s:32:\"7b37f4272fbcd3ee75c2ee219858f15b\";s:0:\"\";s:32:\"f78c78f9ffa611473c93a90deb91f03c\";s:0:\"\";s:32:\"176725e29bc0ebc7ccac3f3e0e8f90ff\";s:0:\"\";s:32:\"7f1b1e70f36b5d287dcca7286785d34f\";s:0:\"\";s:32:\"7b984855405aeb63dddbf2c7b1df0108\";s:0:\"\";s:32:\"c7bf0bfbf5cbad6794bdb6a0eb569ff9\";s:0:\"\";s:32:\"a7e0c96c639edb45feefdfbd0834c414\";s:0:\"\";s:32:\"000524c899b4d25dfc245b7e09779fb0\";s:0:\"\";s:32:\"31223b00b83a0c5a6f2be980ae2b0167\";s:0:\"\";s:32:\"cfa5c2efe59954f1f0b0acadee1da861\";s:0:\"\";s:32:\"2fe397503e4bd98d918eafc4de836460\";s:0:\"\";s:32:\"afc31c0881ab0884ba5634a8236ab392\";s:0:\"\";s:32:\"57056ae8c91e66615146641ce861a017\";s:0:\"\";s:32:\"0256e330efe913065503c9ffc8055052\";s:0:\"\";s:32:\"c39b3c41b687eec6e7455a59e8d08690\";s:0:\"\";s:32:\"1d5b0122c6c33513359b3f54c937cc13\";s:0:\"\";s:32:\"ce0d5f7e76c961009925f6eb391aff4d\";s:0:\"\";s:32:\"427888359103a9d461ed2f3dd4ca9539\";s:0:\"\";s:32:\"2c6cfd4db038aeceee76381923225d39\";s:0:\"\";s:32:\"8ee22ec3e978cf9069b91d30683cbd8c\";s:0:\"\";s:32:\"207e2207548053ff7390722c7c1ba1a9\";s:0:\"\";s:32:\"f959f56875b0ac88653253f58612760d\";s:0:\"\";s:32:\"bc0246c3c7d1ee39d7accdea486c5237\";s:0:\"\";s:32:\"2307458fd27f0db02584f4afb78aa3f3\";s:0:\"\";s:32:\"0f1273e161c8e90a546d394ba4b7f8c7\";s:0:\"\";s:32:\"fb06f6e78730e9a0d714c44efed22448\";s:0:\"\";s:32:\"2ce8edb126074430316cec1b5bc40ca5\";s:0:\"\";s:32:\"bf471c39157d6ab1177ff8360288cf45\";s:0:\"\";s:32:\"bc24ee671fdd93400c19cacd05a6027b\";s:0:\"\";s:32:\"0b1eda40520cb72cdbe0e69d11de7eb7\";s:0:\"\";s:32:\"045b95f191a80f896f44320b7e6fcd30\";s:0:\"\";s:32:\"8e789ef685d9fe28808de9497f5bdea3\";s:0:\"\";s:32:\"5a48373d59bfca3cf9181ebb95673889\";s:0:\"\";s:32:\"fb6ff3533f0d927b9a0a1cb6c32cfffb\";s:0:\"\";s:32:\"11cf0020fa04fb647aba577b32f9dafa\";s:0:\"\";s:32:\"91ff1e3d4c7a9c1d8f73e9ad4b7a8c76\";s:0:\"\";s:32:\"d6027fffeee0bc890bacb76fba2fa75b\";s:0:\"\";s:32:\"781bdcdf1580147208ca8e5ee5a6b733\";s:0:\"\";s:32:\"c3949794357feff024e520c6eeb0ec1c\";s:0:\"\";s:32:\"460505bcf0a9673dea37125dd1d036cf\";s:0:\"\";s:32:\"18ba4281310ec3b7128aa8ddb763cb94\";s:0:\"\";s:32:\"62a8547eb1f2e33a0e2b1de37295161f\";s:0:\"\";s:32:\"2bf9805a0d19d20448f85356e577ef25\";s:0:\"\";s:32:\"f3fd851eaa10f643abcf5e050ba23b85\";s:0:\"\";s:32:\"d80d08ea7a50fccfa066899839b90493\";s:0:\"\";s:32:\"712bc1844d61ec5bac5c37fb7ad85a0a\";s:0:\"\";s:32:\"2dcf3d2637cae83f1633aa3709297d67\";s:0:\"\";s:32:\"857dffa08b384ef98c4a8193820fcd9a\";s:0:\"\";s:32:\"c2eda1483836c45ca2378316071b5a2d\";s:0:\"\";s:32:\"0a098035204424918a6078d99afca609\";s:0:\"\";s:32:\"094859d08fe9191d33634e67b9346b9b\";s:0:\"\";s:32:\"ab56b3d43c4bcfced77e6cc51799a531\";s:0:\"\";s:32:\"8900f139e5885a70443ebbd725c260c4\";s:0:\"\";s:32:\"7b9b3fc5d3f03d349f92c51470bed5ba\";s:0:\"\";s:32:\"07a43aaa1958e924764d16b72b2c03fb\";s:0:\"\";s:32:\"9fee538de9841000cb1328ecbbc95bf0\";s:0:\"\";s:32:\"a08be7dd3fadaa8535ee60185a418bfc\";s:0:\"\";s:32:\"c65a456d307fa54025996b885a0cd798\";s:0:\"\";s:32:\"19267354a7570a4bd3612925c11a8a01\";s:0:\"\";s:32:\"96af496307258bdca1d38eadb68aa225\";s:0:\"\";s:32:\"db5af6458fbdf67f8190e8ab64b787fc\";s:0:\"\";s:32:\"63ebc65f306a859deb7da53eca876717\";s:0:\"\";s:32:\"22c401ab8c949cf8c1e7e8a0dab6dca2\";s:0:\"\";s:32:\"f20c334985f09b72ecc177e65e0f3a67\";s:0:\"\";s:32:\"ba7a5a870869053356f3bed1ca47934b\";s:0:\"\";s:32:\"adf043e341c52cf7199ba66dbbeec8f3\";s:0:\"\";s:32:\"6c7922019a8e552fef5a739ea82e0528\";s:0:\"\";s:32:\"c618297e0edf64b91a1ed6eb3d5f4038\";s:0:\"\";s:32:\"c2f4dbfb7820aec7f1226939c0d3ab91\";s:0:\"\";s:32:\"6531c3c84e79834e62f91ae6ecf579a7\";s:0:\"\";s:32:\"b74f8cc3dbe0a0e758a7fde958e0876b\";s:0:\"\";s:32:\"2052ca1438c6a0950a6837f03782a618\";s:0:\"\";s:32:\"93a120b6689cc4317884b2a85e336af6\";s:0:\"\";s:32:\"c63ea52948bab395293372ca0687af7d\";s:0:\"\";s:32:\"f7429dfed1b8998c1a97378655a6861c\";s:0:\"\";s:32:\"2ace275cefc176cf742c4ca991869461\";s:0:\"\";s:32:\"468e5f723aa840e8e9d04586e214b88b\";s:0:\"\";s:32:\"808b6274f97662be1c387968b42969b3\";s:0:\"\";s:32:\"f4511e9677f3d8f23a6a2b1a4e620204\";s:0:\"\";s:32:\"d6a3031c56970c40d9b62fa6df5f9a74\";s:0:\"\";s:32:\"b3044285ab0bc93cdb23968c9309478d\";s:0:\"\";s:32:\"2ca2610458ef75ca3b83bb3731c1388f\";s:0:\"\";s:32:\"49f33876de5b6bde76d56015ccba7861\";s:0:\"\";s:32:\"785dfca37228328d10fd882a48dceeeb\";s:0:\"\";s:32:\"45766a90e9c893afacb36dec39b11769\";s:0:\"\";s:32:\"6bbc1e5ba22c066859a124a417a88323\";s:0:\"\";s:32:\"0039ed450534334da22727554dacd302\";s:0:\"\";s:32:\"a71619ce9803ac6958e468cb88c368d8\";s:0:\"\";s:32:\"2d4a49efb6b54f053cbd19ea92dc76f2\";s:0:\"\";s:32:\"fca06860b8b2300bcb551b24c4a3876d\";s:126:\"http://demo.parsplugin.com/upsolo/wp-content/plugins/remove-google-fonts-references/cache/fca06860b8b2300bcb551b24c4a3876d.css\";s:32:\"0e98b256efe1c30147f410a2bce2fc15\";s:0:\"\";s:32:\"28093b4ee141638757fd2f8c39303c86\";s:0:\"\";s:32:\"3ba6958afffd4643aeff5a44e922a138\";s:0:\"\";s:32:\"5251a34f800b7aec17f61a8af1a0590c\";s:0:\"\";s:32:\"fce19c28771c3a8e78631fa78bf4fffc\";s:0:\"\";s:32:\"34bae891f81fc92987ed00b149d7ece2\";s:0:\"\";s:32:\"dbbbcfaee89966a7dfdab9abbd218c85\";s:0:\"\";s:32:\"8c8fb3571217a866b0967ca4af31da07\";s:0:\"\";s:32:\"59f342feb32ffb1482c7c9c123ca4e75\";s:0:\"\";s:32:\"5fe8266cd06505d3a3b8b09c549fabcd\";s:0:\"\";s:32:\"5f441793a4517de2b0b75da76a186a16\";s:0:\"\";s:32:\"7761a27a6a41f872850b1a658995af6e\";s:0:\"\";s:32:\"74ddc5da3d83c2c131f7d18cb826c5e6\";s:0:\"\";s:32:\"eda14e317d4eabfb9a817339ff9bbbbb\";s:0:\"\";s:32:\"200c968a5537edf7ed634ac5a2c3900e\";s:0:\"\";s:32:\"87e57f8d218d5e60f37b4f5a63330dfa\";s:0:\"\";s:32:\"7008c0212afe6d26b601bdc716fa14b3\";s:0:\"\";s:32:\"9e6ea3bbfcefe442b399be3df5815545\";s:0:\"\";s:32:\"00764634ce1e6b1d8d955a46aef2cfaa\";s:0:\"\";s:32:\"0bad5b93bcf8a04df2070664999dd187\";s:0:\"\";s:32:\"4570f7ac194e92ef10d113fe412f43ca\";s:0:\"\";s:32:\"e0f0c6880a21f00b1769f2f232c1849c\";s:0:\"\";s:32:\"e19ce225d0c13be2c566b1cc6960a031\";s:0:\"\";s:32:\"9756632fdfc2feb5eb2bd29a60f14d0c\";s:0:\"\";s:32:\"412ceb1271667a3b783ca5403a38912c\";s:0:\"\";s:32:\"e5865a8c7f1d132d1734ea8fcdd8d7da\";s:0:\"\";s:32:\"2d5495f53e997a1a89554bc25b4b2ab8\";s:0:\"\";s:32:\"c0e72a3da2005867103c16a36706903e\";s:0:\"\";s:32:\"c2453ecdc8be77af10859f10978da03d\";s:0:\"\";s:32:\"693fb2fff25609846897df7d3be62442\";s:0:\"\";s:32:\"11445006fec9746be510a09da4ae5644\";s:0:\"\";s:32:\"8edb3d5083eddcd36c429c5b71b8cb3e\";s:0:\"\";s:32:\"d19d8635534be10f3cc2a40a0ea7ff70\";s:0:\"\";s:32:\"83e163817a1b972a0f16a4efb67a4e2e\";s:0:\"\";s:32:\"dc4fd78d736a2408906ce17a63a383b8\";s:0:\"\";s:32:\"97ec5bbc25b4a8a4b7501b1a9e8502ca\";s:0:\"\";s:32:\"6f4dbbed24ef0a86b35dd340e7aa30d6\";s:0:\"\";s:32:\"0d573dc62072c092041260d0e24da673\";s:0:\"\";s:32:\"9eab40dc6a0964f44eafaf9f52f7590e\";s:126:\"http://demo.parsplugin.com/upsolo/wp-content/plugins/remove-google-fonts-references/cache/9eab40dc6a0964f44eafaf9f52f7590e.css\";s:32:\"c7b0cef8de574660d88416ed0d61f471\";s:0:\"\";s:32:\"8420e0ae49a3837f3364192868866406\";s:0:\"\";s:32:\"4cfba0d64629480a1156a4cd9ce9bd68\";s:0:\"\";s:32:\"e5a992c1c9852da9e17158a4555a6e7a\";s:0:\"\";s:32:\"729acff846cf0204353af8b6355280bf\";s:0:\"\";s:32:\"6de6a891af5223629ecfab9e8511fadf\";s:126:\"http://demo.parsplugin.com/upsolo/wp-content/plugins/remove-google-fonts-references/cache/6de6a891af5223629ecfab9e8511fadf.css\";s:32:\"8fdac880ed0be4db1f0b3b0a91815ac8\";s:0:\"\";s:32:\"e702b4b4ad32e74863bb9ff6cab69049\";s:0:\"\";s:32:\"bc3cd85deb460acbece5d6fd0d7b1f16\";s:0:\"\";s:32:\"557e7e322dbde46b0405d55e2782d16f\";s:0:\"\";s:32:\"7f431441bbde17b301d9a1c9a84d0fa0\";s:0:\"\";s:32:\"1daf80448b498f2542021a60e79314b7\";s:0:\"\";s:32:\"f18d3b42e01eb5506ef06a2e09c722e7\";s:0:\"\";s:32:\"8ceec20657962e90fb4a87393fe3faaa\";s:0:\"\";s:32:\"dc3cf0a6230ad7cc596ef72675658749\";s:0:\"\";s:32:\"acbf4217121fa5dccec6ac127358634e\";s:0:\"\";s:32:\"e9927f9e50e863b585a923280ecf612e\";s:0:\"\";s:32:\"14bafa294478b320f4a9045a90a687a7\";s:0:\"\";s:32:\"a6916b7920d9ff262721f06a9ffbc420\";s:0:\"\";s:32:\"14d86db22c900b87ae98d6a86650f18e\";s:0:\"\";s:32:\"71ad5585154f38deb0d788ab277bd483\";s:0:\"\";s:32:\"80910bf0c9647fee6fc45d7ed7187323\";s:0:\"\";s:32:\"c5078ef322174a6ff8f037c20f5ad27a\";s:0:\"\";s:32:\"8778436503d646b88d91d0321127c1a4\";s:0:\"\";s:32:\"30b9796b644270873efef7535e735b85\";s:0:\"\";s:32:\"bfdcc507f17d000c624f70a5321da06c\";s:0:\"\";s:32:\"f8f2310989c7b21d3324e622d4ec2649\";s:0:\"\";s:32:\"d61c1ba4516c75b40a23d43b07e89b86\";s:0:\"\";s:32:\"c1e735a6c696c1d3ffabc3c4aee07e71\";s:0:\"\";s:32:\"cc6d4ed8d8a7ea57aef688e20f6421c7\";s:0:\"\";s:32:\"776a24ec4f0617d77d34dfa88c824d6d\";s:0:\"\";s:32:\"5b7146a024871dfe2f0e5edaed88be92\";s:0:\"\";s:32:\"c7d4fbde6644b0a120355913407410ad\";s:0:\"\";s:32:\"866ad8c10b85c87633dc89f5a5c68c17\";s:0:\"\";s:32:\"1e0300349ed64122ab594ee0b245524c\";s:0:\"\";s:32:\"f13a124abe5990639a647adf6c4e3b36\";s:0:\"\";s:32:\"e1f6803b94f89accb619d8918b0ada73\";s:0:\"\";s:32:\"769507f25e301edbcc609c7262125c0a\";s:0:\"\";s:32:\"82306953da4af3bd2e33fd13a01c6d7e\";s:0:\"\";s:32:\"f90e9d036f5e027449abbd72b382fe59\";s:0:\"\";s:32:\"834e376816c8e1862b6a1086ebbc5e21\";s:0:\"\";s:32:\"571713ad5700080d58e75867fc9007dc\";s:0:\"\";s:32:\"20728db632e479cb1d6441eb05367573\";s:0:\"\";s:32:\"112db03dea22ca3a3c28952e92e62a0f\";s:0:\"\";s:32:\"5c3565e1494818ed45e9445953737d84\";s:0:\"\";s:32:\"782579b23c7edafee65655cdbfb8544c\";s:0:\"\";s:32:\"63870c986460bb850f46d1cdce7bb3ec\";s:0:\"\";s:32:\"17acb9091ff432b935fa8252b5b86886\";s:0:\"\";s:32:\"b9dc65b6c506428c3f3113275170297e\";s:0:\"\";s:32:\"8f87c88f4ec9eea3ebebb7f65f859d31\";s:0:\"\";s:32:\"19ca6afccd702c6fa7a853f5d496f63c\";s:0:\"\";s:32:\"4ae86a4202d686656dadead0e8d23516\";s:0:\"\";s:32:\"fedf1a1edde079a4cfdc75f3853a07e3\";s:0:\"\";s:32:\"11e316488b434233478f44658fb1f333\";s:0:\"\";s:32:\"92fdb95560254e32458d9d7adb44a5d5\";s:0:\"\";s:32:\"39c65c0a09ee2e1a899b82048c2502f0\";s:0:\"\";s:32:\"8d122afe1de100da9e84a95efbb5a1d0\";s:0:\"\";s:32:\"3aa54d682efb1ab294c9b022f8e11e00\";s:0:\"\";s:32:\"03d07d14649400089ac3827b7bffcf81\";s:0:\"\";s:32:\"a203981c771a9281f04b3bf6224e4ef6\";s:0:\"\";s:32:\"123042681b6385c738558d0c5a323b48\";s:0:\"\";s:32:\"567d3ad40a28317a6c560599d9857a2e\";s:0:\"\";s:32:\"260e80fa66db5d03a0008429b3e030df\";s:0:\"\";s:32:\"3b84585ef07d52243218933425a2f3bc\";s:0:\"\";s:32:\"00ae729d7177417c6f8f3bf15d1d207a\";s:0:\"\";s:32:\"6f89be2805f0c41ae04bf6f19942e625\";s:0:\"\";s:32:\"4b4eab7d5f2f5007ddc7db6a393391a1\";s:0:\"\";s:32:\"00131295274bba4d08374905840ce4b4\";s:0:\"\";s:32:\"99eec021e7ecdbd8767e9166abd3a1b8\";s:0:\"\";s:32:\"0b2b4e0d50a125ee77cf85a53c3b077e\";s:0:\"\";s:32:\"9dd3fb8050cc19b721e00412263a2dd5\";s:0:\"\";s:32:\"37801c56119b680fcd83d136830120c2\";s:0:\"\";s:32:\"47c4a5495093211414905759a1ba7e78\";s:0:\"\";s:32:\"c24f95ce60baee6ceb6fdf34e3054197\";s:0:\"\";s:32:\"daeb32603b9e8ed43c5ca2e12c17ee3d\";s:0:\"\";s:32:\"c62a1c3e73e65cf3c8b90067ae1769be\";s:0:\"\";s:32:\"b50d6b1ad9f15563fdee237dda1d2816\";s:0:\"\";s:32:\"6b54657e3de32a0bd3181dfc9559fdf7\";s:0:\"\";s:32:\"ced83ec023276b4bd553545771a8a668\";s:0:\"\";s:32:\"03060e4225ee2ccf2512861a557521ec\";s:0:\"\";s:32:\"c9189ccf5ebc45e2e028e45499000c41\";s:0:\"\";s:32:\"6fdb79785fbe5dea9d716025add995e9\";s:0:\"\";s:32:\"7512c55791975264bd075c394772c341\";s:0:\"\";s:32:\"32c5d14c0a7a428269df04393556947d\";s:0:\"\";s:32:\"952471ecc15fc617c70baf6638fc4bb1\";s:0:\"\";s:32:\"1aee91a93d6ee332f080a0fb1a872a15\";s:0:\"\";s:32:\"60e8c40fbd66bbf29d57137f35f76673\";s:126:\"http://demo.parsplugin.com/upsolo/wp-content/plugins/remove-google-fonts-references/cache/60e8c40fbd66bbf29d57137f35f76673.css\";s:32:\"074df81a1c6e1ed3e9d890e63ca3f17c\";s:0:\"\";s:32:\"2f075070fc0fa12a8dcd815c4f51b3a4\";s:0:\"\";s:32:\"8140088f606f0c07f6e55e0d9de1442d\";s:0:\"\";s:32:\"d01f1a040ad3154c2d2bb5f9b6078163\";s:0:\"\";s:32:\"1523c68ee78ac991416186e394e28f0a\";s:0:\"\";s:32:\"160606bbf5174f6badc4132fa3f3645b\";s:0:\"\";s:32:\"ad63933a0ec2f111f9b33a63b117b191\";s:0:\"\";s:32:\"2b608c91cc965823e0e6797a2712b73f\";s:0:\"\";s:32:\"10214095747957d62f24ccba9ee68629\";s:0:\"\";s:32:\"f49df7175d55b12941e58a43b9a62eb2\";s:0:\"\";s:32:\"e8de4b3522329639ce0a45572fdc86a1\";s:0:\"\";s:32:\"548267799c624a635517a9a3beda8d0a\";s:0:\"\";s:32:\"180fb1623799d96b4c330986d0632c39\";s:0:\"\";s:32:\"6b9addc1aed9ee95dcd1f00c5045c348\";s:0:\"\";s:32:\"0b07d56a89733ef4cbba7fa481e57a6b\";s:0:\"\";s:32:\"baff300555e0f8fea83e467a0e3137f5\";s:0:\"\";s:32:\"9edbc7e1b42f6517da8348ac8bc756e8\";s:0:\"\";s:32:\"42f2b42a1ef82d63848dc6f763eaf188\";s:0:\"\";s:32:\"80dd5f7ac31b25051436056ca29dfc1e\";s:0:\"\";s:32:\"e978588ae9977a6e20e8184b7878de72\";s:0:\"\";s:32:\"3a611d211159e00855cb016d0699a7a6\";s:126:\"http://demo.parsplugin.com/upsolo/wp-content/plugins/remove-google-fonts-references/cache/3a611d211159e00855cb016d0699a7a6.css\";s:32:\"750ba6673a87c8dea662f4408a0e7f16\";s:0:\"\";s:32:\"4a0afd0ee39761c68bc0d842619b97be\";s:0:\"\";s:32:\"38952cd330945e134567d829b886ec35\";s:0:\"\";s:32:\"376e4497a2b145d3161a703701dac1a1\";s:0:\"\";s:32:\"ebecce3de565e402f22345e28fa9de8c\";s:0:\"\";s:32:\"57f9e0910f92d59b71dc6883936364a5\";s:0:\"\";s:32:\"f81136a44df18259e9cf6d0d176b9e3a\";s:0:\"\";s:32:\"5b21ba3ad688610eaee1a77d0e3a6387\";s:0:\"\";s:32:\"dfb20f893bd851a2349785ac38152563\";s:0:\"\";s:32:\"d9c16b46f67a51a6f371cafaeb0de9b6\";s:0:\"\";s:32:\"56d48fca8b780aafa33f40434c7afd73\";s:0:\"\";s:32:\"33b461e07b9a6a93d4dffa6516c4a748\";s:0:\"\";s:32:\"b1a5e9a1b4f170440b78ac1401963a74\";s:0:\"\";s:32:\"ad8dda17fdc72ab6d0ced6176f95a71b\";s:0:\"\";s:32:\"55d5e0f4c08e19bb2873108ddf8adafc\";s:0:\"\";s:32:\"16c9940b1faa3d6c1a20f49d1699dbc2\";s:0:\"\";s:32:\"22e812465576d3a1ccc45908f4af19ef\";s:0:\"\";s:32:\"2b785944672efca2d1deae211ed9f9bd\";s:0:\"\";s:32:\"034fbb4299c54e7b31c6cb86f7e58a2b\";s:0:\"\";s:32:\"bab2789cb8c56c5d0a4a5635908594cc\";s:0:\"\";s:32:\"2bc3b096aebddb9c961e4200ef722af4\";s:0:\"\";s:32:\"760997e9b3777d91ec4859f6df94a45c\";s:0:\"\";s:32:\"a457f3c5925ff30d6ad2ff2865bf8304\";s:0:\"\";s:32:\"7e9bdfac9078f63e3a50281fc4431a18\";s:0:\"\";s:32:\"ded51743a79dc4191a19d7a1eaa97756\";s:0:\"\";s:32:\"bb0e2d26b31e71f2653c0f92daf93bbe\";s:0:\"\";s:32:\"f315738ab94a116635f0f15940863faf\";s:0:\"\";s:32:\"fea27e8cc8bf4356e364eb06dfd4a696\";s:0:\"\";s:32:\"bf294394a87c1c1a17a2edb2de236e9e\";s:0:\"\";s:32:\"d7af7583918b7b68a547cc1673d6e086\";s:0:\"\";s:32:\"1c9e803a5c6eef62056049b8a8368331\";s:0:\"\";s:32:\"9a01914a5c552888196c27891ba99d0d\";s:0:\"\";s:32:\"c7b82d2d02792ab218051e8b79b4c0e0\";s:0:\"\";s:32:\"18c762abc032657878bf4ff2ef381eff\";s:0:\"\";s:32:\"31e5e790d6858c20a87d6e7083955d11\";s:0:\"\";s:32:\"69368a7e4ef5be7d2894171dcfc88675\";s:0:\"\";s:32:\"d8146e6e52226005e939d30813858296\";s:0:\"\";s:32:\"630156c36b80484321451f6c2f6ed9b2\";s:0:\"\";s:32:\"d3cf6d67074813c551840f7a01c4d8b2\";s:0:\"\";s:32:\"04d5cdddbe168fd5641dca6c2c7c48f0\";s:0:\"\";s:32:\"b0e5135d635acc042cc0d5175a2f9ec3\";s:0:\"\";s:32:\"27617e7a7e2763d4cc86199293caea05\";s:0:\"\";s:32:\"e553e25fd198a20fe86a57367c0c0d4a\";s:0:\"\";s:32:\"6f468ccc1c436ce191cfe682652cff79\";s:0:\"\";s:32:\"1319b850b5d0245c890dc9ce1aceabc4\";s:0:\"\";s:32:\"b926135605aeda958bb536c20e8c72fc\";s:0:\"\";s:32:\"28dc9baaf98ba166622bf908c28b24f4\";s:126:\"http://demo.parsplugin.com/upsolo/wp-content/plugins/remove-google-fonts-references/cache/28dc9baaf98ba166622bf908c28b24f4.css\";s:32:\"259066b30b3eea091613778439e6e399\";s:0:\"\";s:32:\"4387b36750f6c0ede1b572907bde0639\";s:0:\"\";s:32:\"8e9f1909ded3477aff1e0f0236d8784b\";s:0:\"\";s:32:\"96f29aa3608e2133d0413a7f062f76da\";s:0:\"\";s:32:\"fd1ae63b0cf31277c2fd653eb7a48e9d\";s:0:\"\";s:32:\"79ae17143da4bfa159554c307abf1bf9\";s:0:\"\";s:32:\"b687e59b4a1b9abe7514a1defe0371d6\";s:0:\"\";s:32:\"97324d19e73f198a954ca6439fefea17\";s:0:\"\";s:32:\"f1cf28aedf032ec32f55ca38c2cf8675\";s:0:\"\";s:32:\"33d9987f99876fb1a75a0ff4d9e45c39\";s:0:\"\";s:32:\"14994c5d64fe27a684e40518b124a4dc\";s:0:\"\";s:32:\"c2849cd880b2e3189594995ec2b143e3\";s:0:\"\";s:32:\"770a4f5cb60bcba2efd84d490a311484\";s:0:\"\";s:32:\"8c98c48426103c1fa2fd8ef79d2322fa\";s:0:\"\";s:32:\"b9d00e3b764acfdcf40b6ce1be432878\";s:0:\"\";s:32:\"75ac3441cb7d3e405924a4f9dadd6443\";s:0:\"\";s:32:\"65929a08d5b6f37996ac3a17b33812cc\";s:0:\"\";s:32:\"ccfa63176611bc8a5816db0bf4cffca6\";s:0:\"\";s:32:\"104d08c41f412f3c5d50725ca9ec7a9e\";s:0:\"\";s:32:\"79d489e02fa5d5143c78674ea962c80e\";s:126:\"http://demo.parsplugin.com/upsolo/wp-content/plugins/remove-google-fonts-references/cache/79d489e02fa5d5143c78674ea962c80e.css\";s:32:\"42ec04dcf9c1514fd71e2a9e10a60188\";s:0:\"\";s:32:\"b27469cb4683744f5d84f5460ac4f71a\";s:0:\"\";s:32:\"c12543d7fa5d4a67efcce78af889624e\";s:0:\"\";s:32:\"429db4956a4c6582955c49bd3fbc5ad6\";s:0:\"\";s:32:\"a910d9a4b86b73df44192759c27cba84\";s:126:\"http://demo.parsplugin.com/upsolo/wp-content/plugins/remove-google-fonts-references/cache/a910d9a4b86b73df44192759c27cba84.css\";s:32:\"bbb84f7c988fe73c90780e2475b6f75f\";s:0:\"\";s:32:\"7cfa8a0d2f688a23185ca38cf7ad7950\";s:0:\"\";s:32:\"d610ef5b58a3f77415266fefdaa43fc6\";s:0:\"\";s:32:\"b0df8ed994a74a0261986562c357b739\";s:0:\"\";s:32:\"da05a060dd4f5c8602b394be133fde55\";s:0:\"\";s:32:\"9af2d3cf411c5b54a83bb4210f3b5d3b\";s:0:\"\";s:32:\"d66acc3a791e8130e8d9750a78adb929\";s:0:\"\";s:32:\"381ecd61bd29a86eaca948eebebd5050\";s:0:\"\";s:32:\"cd794d31bfda1caa79c979c9a15b054a\";s:0:\"\";s:32:\"903632157e2cc6418bfc42bb1478acee\";s:0:\"\";s:32:\"20fcd7055814e7f20c62c27c56337c97\";s:0:\"\";s:32:\"7be4a1570c56b2f5062d7aa17dc7afe3\";s:0:\"\";s:32:\"fd3e03665b5e54b474f856fac15941e1\";s:0:\"\";s:32:\"201ac01194a7568229cb7c815a640965\";s:0:\"\";s:32:\"6df571c8328249006cd21f50d74718af\";s:0:\"\";s:32:\"b7ac0456b8b44ac0dca77dab893dd758\";s:0:\"\";s:32:\"d1b06c3e97387f6b8853dfc07e82efe0\";s:0:\"\";s:32:\"610a144a67d781b18a71d62d5cb4455e\";s:0:\"\";s:32:\"8735b17d536255a460625e597808d4ab\";s:126:\"http://demo.parsplugin.com/upsolo/wp-content/plugins/remove-google-fonts-references/cache/8735b17d536255a460625e597808d4ab.css\";s:32:\"90b3623a9b5efd99551ea1c1ca629fb0\";s:0:\"\";s:32:\"88852e8434e2f48b9332e873a4a3da89\";s:0:\"\";s:32:\"3c10e8f1c0cf55149fb1c3920a1457b4\";s:0:\"\";s:32:\"ac02deb3bba6c1175314357806e1c753\";s:0:\"\";s:32:\"919039bac9aea45667ea238cad9d5b1d\";s:0:\"\";s:32:\"19bdd81126fdd68508673abd3e6e1936\";s:0:\"\";s:32:\"ae620f2daf2298f559768d3255393212\";s:0:\"\";s:32:\"7db58e207940c813180f97b73077fb72\";s:0:\"\";s:32:\"97816f9027743b5869da47dc75aadc3d\";s:0:\"\";s:32:\"13a74d514072cefb4c096f0c0e336b7b\";s:0:\"\";s:32:\"ddf4cfefc54a03b6f51b1997cb9b034c\";s:0:\"\";s:32:\"85fe895209a1bad30e35a2b802337764\";s:0:\"\";s:32:\"3df164f2183169aeba47dee34815c44f\";s:0:\"\";s:32:\"7e95949303158f79dd2f5ccdde4cbc0b\";s:0:\"\";s:32:\"d91bcee4c52b79d56d02b2589e302062\";s:0:\"\";s:32:\"fbd59220166b1182124452b289595646\";s:0:\"\";s:32:\"43c5a537400bc6efc2b420c330e7a8a9\";s:0:\"\";s:32:\"fdbd74c2dc293322edb94270c29f020d\";s:0:\"\";s:32:\"0355a5f075ceaefcb10f945f90a76e49\";s:0:\"\";s:32:\"1c926795c98a44fbd6ebc037170018c5\";s:0:\"\";s:32:\"d51c34a70137551139f3b3066cacff3b\";s:0:\"\";s:32:\"56272d1e46972a195fe444e3bc00543a\";s:0:\"\";s:32:\"c28b614b3ef5f68ccb4600242cd84fac\";s:0:\"\";s:32:\"610df2957e9bd287cc4ee0c0e1afff96\";s:0:\"\";s:32:\"fcd332121a607ce1181c24bc11e481f7\";s:0:\"\";s:32:\"e6b8fae85522680105b0b12313bb6676\";s:0:\"\";s:32:\"0491857513359c4f523be0175d194d18\";s:0:\"\";s:32:\"979227f1a7c5e069e3333bc349f9cbdc\";s:0:\"\";s:32:\"5c617195380c5516b5e0eda3d723a3ca\";s:0:\"\";s:32:\"3fea23a2d88db692669d10e416069ba9\";s:0:\"\";s:32:\"3e6ae60b0100f81fd2f2f2cefa55306c\";s:0:\"\";s:32:\"5db4ef9ca0b947ce5fee35ce3d11cf5b\";s:0:\"\";s:32:\"3c728a50449369030a86957cc97d2102\";s:0:\"\";s:32:\"5ab137d40cca3085a9a1430827356f6f\";s:0:\"\";s:32:\"176fee1cc10bb5f5eeab0cf003a3ce16\";s:0:\"\";s:32:\"8d23234e78dbf8564ddbf5607743e440\";s:0:\"\";s:32:\"28d310e6ec0262a0f2c020e4099a7100\";s:0:\"\";s:32:\"7c373c67b850001cfe6dd34cb064b7c2\";s:0:\"\";s:32:\"497d9059fb296f59e63788bdf409370e\";s:0:\"\";s:32:\"fc0d439570354d93938161ee697af163\";s:0:\"\";s:32:\"3ec0dfe30c35200d735f6283d995737d\";s:0:\"\";s:32:\"b7ebfd8edae3ee9ea91a378c3f6df6b0\";s:0:\"\";s:32:\"9bdcf6f656a9c3c2ec926ce3e507f5f4\";s:0:\"\";s:32:\"784167176b4aa99d9272abbd93bbe276\";s:0:\"\";s:32:\"13035bfea42dc6917cc804dfb6ddd213\";s:0:\"\";s:32:\"6cd827870c7d4fcefa50796d3d316c11\";s:0:\"\";s:32:\"001575049c17347d3cd3ed36d369a173\";s:0:\"\";s:32:\"32f81b1924cb7661fef87fc2a1fb3c61\";s:0:\"\";s:32:\"e789da8c10246a33491e0c0d818f075e\";s:0:\"\";s:32:\"9a1ac4848a1e0c178c67b9c742b3360b\";s:0:\"\";s:32:\"70a98c75b96b2f16158ae29133a92f6e\";s:0:\"\";s:32:\"1fdefc22d9a10b64a7247b03292862ba\";s:0:\"\";s:32:\"9b1543bd835550b1d00cb862af89717b\";s:0:\"\";s:32:\"fdeee018ab647451a2fc6670d050649f\";s:0:\"\";s:32:\"28536cfd98f374595d147b561a1237b5\";s:0:\"\";s:32:\"d157c2296050e6bde3b68293dcb88650\";s:0:\"\";s:32:\"6ae31405c5a0c4a37effad3964005942\";s:0:\"\";s:32:\"5af2d5af206bee28c90cd946c2b66d1d\";s:0:\"\";s:32:\"0dbe7e8ace8711e62d5947365f5b7877\";s:0:\"\";s:32:\"ae0cbe62821d79fa33562c28ec560140\";s:0:\"\";s:32:\"b26ca9e27c57833151ab2d4a022ac566\";s:0:\"\";s:32:\"a3269b9b17411c61f84d84bb04efc650\";s:0:\"\";s:32:\"79919a6e9f6bfca815afe9d6c821445f\";s:0:\"\";s:32:\"fa6952d0fb322a05a2f744f1d62c07c1\";s:0:\"\";s:32:\"df31cca1ddc6cc781ef5262bb3c98928\";s:0:\"\";s:32:\"0feaf698129b1f61832025aedba2a421\";s:0:\"\";s:32:\"a4d36d3d5e7a0c73a7dc0064be6d0324\";s:0:\"\";s:32:\"7e36e358278ba6b28d9ca04cdd6e8f06\";s:0:\"\";s:32:\"607bf1d8e6fb333cbcb01bdcc404a802\";s:0:\"\";s:32:\"e840f882ef25ea43aabc334790364fe2\";s:0:\"\";s:32:\"3409b121eb6b93cd41cf9cd68da439d0\";s:0:\"\";s:32:\"cd21d09fb91993f974d270e59e0df01a\";s:0:\"\";s:32:\"588a6397da8ff2b5df0d9c496a4cef96\";s:0:\"\";s:32:\"dd7a8dac49a3600cd34462b3f6a9e3de\";s:0:\"\";s:32:\"5d8bb0de2127b027a7f30ba70bfaeaca\";s:0:\"\";s:32:\"139316fcde5bfae692532250b23e8865\";s:0:\"\";s:32:\"9d0c05c2627e35a93a9bfbd10680390a\";s:0:\"\";s:32:\"fc4b9be4da62d2d5584a80f6018cbd33\";s:0:\"\";s:32:\"7bc0c0f4f170586b59c416809c02bae9\";s:0:\"\";s:32:\"4f8bd9fb70787670bf5209bd97ab1c26\";s:0:\"\";s:32:\"b7ca71070a8b105848fffd2e7b9551d0\";s:0:\"\";s:32:\"121e5a0c530f6e27f9e19c955c0e8295\";s:0:\"\";s:32:\"090c675563d33dc849a4e723145dc06b\";s:0:\"\";s:32:\"6faa469c77292244cccce12da2a0d2ae\";s:0:\"\";s:32:\"9810564f5cca334b754519c6deab703c\";s:0:\"\";s:32:\"b805f938073a0abad49d43e7ec6f55d0\";s:0:\"\";s:32:\"aa37a387259b1c06835a932df9a255c4\";s:0:\"\";s:32:\"101ad41a5936525b8b16c6f8321fefe1\";s:0:\"\";s:32:\"e77457c42166068a9151c30fc3bde1ec\";s:0:\"\";s:32:\"d1b864fa248c0cd92ffddcd3592fc05e\";s:0:\"\";s:32:\"05083f12262639761a98807f5732118c\";s:0:\"\";s:32:\"07ae72377f3af50c255c3922b0256de9\";s:0:\"\";s:32:\"41d91f570f40b99483df9bcba510def0\";s:0:\"\";s:32:\"430898bf52eea7a197ef1a91688434f1\";s:0:\"\";s:32:\"5e07b958c736582bd4b091b6de06484d\";s:0:\"\";s:32:\"2807d6c1312b98b008c830e32ffbe3f9\";s:0:\"\";s:32:\"5228f6e8cce236f928d52930d7e00e94\";s:0:\"\";s:32:\"8e74748146c4dea53aa6a2f3d5d114bc\";s:0:\"\";s:32:\"73ba1338a7040b4d8bfe9485a36b075c\";s:0:\"\";s:32:\"73271178004baf4b8112e1961017b33f\";s:0:\"\";s:32:\"66d0949eea3983031bd5d4a97e6ce3f3\";s:0:\"\";s:32:\"e1929636dd7446b17718f8f7ea916839\";s:0:\"\";s:32:\"652fb85328397087cdb140a992b0295e\";s:0:\"\";s:32:\"ebdc9fb00c74f6bab3f220cda7e87fbd\";s:0:\"\";s:32:\"74cb527c8bba9f79bdc6b3d3ca497515\";s:126:\"http://demo.parsplugin.com/upsolo/wp-content/plugins/remove-google-fonts-references/cache/74cb527c8bba9f79bdc6b3d3ca497515.css\";s:32:\"07b81c8d19c01e1fdbcbad54f8b49cad\";s:0:\"\";s:32:\"84dcf98f2925f4f59463b8ea3b001519\";s:0:\"\";s:32:\"d8db2c1553fa6ab791148010a9f9e023\";s:0:\"\";s:32:\"69fa3223bf2182e89040998fb961ed96\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("19367", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("19757", "revslider-update-hash", "463fbf2705f4cf738b04409f34fc8441", "yes");
INSERT INTO `wp_options` VALUES("19124", "wbcr_dan_hidden_notices", "a:9:{s:65:\"f2db941d9380d8882d732200e1e74265_d13b244cbb2f9b144f4540c484ac075e\";s:101:\"وردپرس 5.2.1 دردسترس است! لطفا هم‌اکنون بروزرسانی نمایید.\";s:65:\"3ea8392e0285b5088f60bea80d31ece7_65456108223117c8c2490b846d221200\";s:131:\"سلام! اگر نیاز به پشتیبانی دارد به ویژوال پرس مراجعه کنید.بستن این اعلان.\";s:65:\"642bdf6d615cff650b0816d4a544e36a_a6473c769edc4d9748af83d748028b72\";s:121:\"افزونه وردپرس فارسی با موفقیت نصب شد. لطفا تنظیمات را بررسی نمایید.\";s:65:\"03e693c00da135f1986dbfa085d2f9e4_2a97704d2127cc46c33b56bb9de28800\";s:154:\"A\n			\n				\n					\n				\n			\n			تقریبا انجام شده - اکیسمت را پیکربندی کنید و با هرزنامه خداحافظی کنید\";s:65:\"aee8cbc569b4ae1cf01f550abc1def83_1bd0c2714078a499d7ec17fca051db77\";s:330:\"رد کردن\n\n	\n	به نظر می رسد فروشگاه شما از یک اتصال امن استفاده نمی کند. ما به شدت توصیه می کنیم در کل وب سایت خود از طریق اتصال HTTPS خدمت کنید تا امنیت اطلاعات مشتری را حفظ شود. بیشتر بدانید.\";s:65:\"f623edb720ee6e1214c496c1c60f692b_9fc9084033fc8b41eb406d88958a3ef5\";s:145:\"رد کردن\n\n	دیتای ووکامرس بروز شد. از شما برای بروزرسانی به آخرین نگارش سپاسگزاریم!\";s:65:\"c0e61b53523ea07d8bb39a1e61ce2a1d_21f0fbd6702a329b06d40a7ac60c1f11\";s:245:\"WooCommerce is updating product data in the background\n		Product display, sorting, and reports may not be accurate until this finishes. It will take a few minutes and this notice will disappear when complete.		&nbsp;مشاهده پیشرفت →\";s:65:\"b66b653f5807bc277aeb9280e4bd3a46_7ad34a8d41033f8ca4ee7f2969b88d60\";s:259:\"رد کردن\n\n	\n		آزمایش آینده ووکامرس. ظاهر سریع‌تر و نیروگرفته از جاوا اسکریپت با ویژگی‌ها و گزارش‌های هیجان‌انگیز جدید.	\n					\n			نصب مدیریت ووکامرس\";s:65:\"72f19fb2b42cb452268752d0e22f81c2_e096e3815aaf289c9fefa340a34eb925\";s:110:\"To enable all features used by Zephyr theme, install and activate UpSolution Core plugin.			Read more about it\";}", "yes");
INSERT INTO `wp_options` VALUES("19089", "wbcr_dan_cache_options", "a:2:{s:18:\"hide_admin_notices\";b:0;s:37:\"factory_400_plugin_activated_wbcr_dan\";i:1552130491;}", "yes");
INSERT INTO `wp_options` VALUES("19090", "wbcr_dan_factory_400_plugin_activated_wbcr_dan", "1552130491", "yes");
INSERT INTO `wp_options` VALUES("23077", "factory_plugin_versions", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("23078", "wbcr_dan_plugin_version", "1.1.1", "yes");
INSERT INTO `wp_options` VALUES("19158", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("19159", "woocommerce_allow_tracking", "no", "no");
INSERT INTO `wp_options` VALUES("19160", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `wp_options` VALUES("23096", "bsr_data", "a:8:{s:13:\"select_tables\";a:50:{i:0;s:14:\"wp_commentmeta\";i:1;s:11:\"wp_comments\";i:2;s:21:\"wp_dokan_announcement\";i:3;s:15:\"wp_dokan_orders\";i:4;s:15:\"wp_dokan_refund\";i:5;s:17:\"wp_dokan_withdraw\";i:6;s:22:\"wp_duplicator_packages\";i:7;s:16:\"wp_ewwwio_images\";i:8;s:8:\"wp_links\";i:9;s:10:\"wp_options\";i:10;s:11:\"wp_postmeta\";i:11;s:8:\"wp_posts\";i:12;s:16:\"wp_revslider_css\";i:13;s:20:\"wp_revslider_css_bkp\";i:14;s:29:\"wp_revslider_layer_animations\";i:15;s:33:\"wp_revslider_layer_animations_bkp\";i:16;s:24:\"wp_revslider_navigations\";i:17;s:28:\"wp_revslider_navigations_bkp\";i:18;s:21:\"wp_revslider_settings\";i:19;s:20:\"wp_revslider_sliders\";i:20;s:24:\"wp_revslider_sliders_bkp\";i:21;s:19:\"wp_revslider_slides\";i:22;s:23:\"wp_revslider_slides_bkp\";i:23;s:26:\"wp_revslider_static_slides\";i:24;s:30:\"wp_revslider_static_slides_bkp\";i:25;s:21:\"wp_term_relationships\";i:26;s:16:\"wp_term_taxonomy\";i:27;s:11:\"wp_termmeta\";i:28;s:8:\"wp_terms\";i:29;s:11:\"wp_usermeta\";i:30;s:8:\"wp_users\";i:31;s:18:\"wp_wc_download_log\";i:32;s:25:\"wp_wc_product_meta_lookup\";i:33;s:22:\"wp_wc_tax_rate_classes\";i:34;s:14:\"wp_wc_webhooks\";i:35;s:23:\"wp_woocommerce_api_keys\";i:36;s:35:\"wp_woocommerce_attribute_taxonomies\";i:37;s:47:\"wp_woocommerce_downloadable_product_permissions\";i:38;s:17:\"wp_woocommerce_ir\";i:39;s:18:\"wp_woocommerce_log\";i:40;s:29:\"wp_woocommerce_order_itemmeta\";i:41;s:26:\"wp_woocommerce_order_items\";i:42;s:32:\"wp_woocommerce_payment_tokenmeta\";i:43;s:29:\"wp_woocommerce_payment_tokens\";i:44;s:23:\"wp_woocommerce_sessions\";i:45;s:38:\"wp_woocommerce_shipping_zone_locations\";i:46;s:36:\"wp_woocommerce_shipping_zone_methods\";i:47;s:29:\"wp_woocommerce_shipping_zones\";i:48;s:33:\"wp_woocommerce_tax_rate_locations\";i:49;s:24:\"wp_woocommerce_tax_rates\";}s:16:\"case_insensitive\";s:3:\"off\";s:13:\"replace_guids\";s:3:\"off\";s:7:\"dry_run\";s:3:\"off\";s:10:\"search_for\";s:9:\"Read More\";s:12:\"replace_with\";s:19:\"ادامه مطلب\";s:15:\"completed_pages\";i:50;s:11:\"total_pages\";i:50;}", "yes");
INSERT INTO `wp_options` VALUES("19414", "_transient_shipping-transient-version", "1564419723", "yes");
INSERT INTO `wp_options` VALUES("30144", "_transient_product-transient-version", "1694935623", "yes");
INSERT INTO `wp_options` VALUES("30145", "_transient_orders-transient-version", "1570271273", "yes");
INSERT INTO `wp_options` VALUES("23081", "_transient_timeout_wbcr_dan_a63820d2c89b3919b77d6fd52c9fe5a0", "3132835690", "no");
INSERT INTO `wp_options` VALUES("23082", "_transient_wbcr_dan_a63820d2c89b3919b77d6fd52c9fe5a0", "a:3:{s:7:\"content\";s:397:\"<div id=\"message\" class=\"notice notice-info is-dismissible wbcr-advt-notice\"><p>Hey, You’ve using <b>Disable admin notices individually</b> – that’s awesome! Could you please do me a BIG favor and give it a 5-star rating on WordPress? Just to help us spread the word and boost our motivation! <a href=\"https://wordpress.org/support/plugin/disable-admin-notices/reviews/\">Review</a></p></div>\";s:7:\"expires\";i:1566423275;s:6:\"plugin\";s:8:\"wbcr_dan\";}", "no");
INSERT INTO `wp_options` VALUES("19446", "_transient_product_query-transient-version", "1699199243", "yes");
INSERT INTO `wp_options` VALUES("19453", "revslider_update_revision_current", "6.6.0", "yes");
INSERT INTO `wp_options` VALUES("19459", "recovery_mode_email_last_sent", "1691920552", "yes");
INSERT INTO `wp_options` VALUES("19399", "rs-templates-new", "", "no");
INSERT INTO `wp_options` VALUES("25060", "_transient_timeout_wbcr_dan_b04e62fde280feff46584059d18874b3", "3135133632", "no");
INSERT INTO `wp_options` VALUES("25061", "_transient_wbcr_dan_b04e62fde280feff46584059d18874b3", "a:3:{s:7:\"content\";s:895:\"<p>\r\n<ul>\r\n<li><a href=\"https://cm-wp.com/2019/02/26/otkljuchit-gravatar-v-wordpress/\">Disable Gravatar In WordPress</a></li>\r\n<li><a href=\"https://cm-wp.com/2019/02/26/udaljaem-nenuzhnye-stranicy-sajta-iz-poiskovika-ili-kak-udalit-stranicy-vlozhenij-v-wordpress/\">Remove WordPress Attachment Pages And Hide Useless Webpages From Search Results</a></li>\r\n<li><a href=\"https://cm-wp.com/2019/02/26/upravlenie-revizijami-i-avtosohranenijami-zapisej-i-stranic-v-wordpress-s-pomoshhju-clearfy/\">How To Manage WordPress Revisions And Autosave With Clearfy</a></li>\r\n<li><a href=\"https://cm-wp.com/2019/02/19/upravlenie-pulsaciej-ili-kak-nastroit-heartbeat-v-wordpress/\">How To Configure And Manage Heartbeat In WordPress</a></li>\r\n<li><a href=\"https://cm-wp.com/2019/02/19/transliteracija-ssylok-i-imen-fajlov-v-wordpress/\">How To Transliterate Links And File Names In WordPress</a></li>\r\n</ul>\r\n</p>\";s:7:\"expires\";i:1567572246;s:6:\"plugin\";s:8:\"wbcr_dan\";}", "no");
INSERT INTO `wp_options` VALUES("19411", "rs-templates", "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", "no");
INSERT INTO `wp_options` VALUES("21776", "revslider-library-hash", "dae3de1eb57eeeee008b70e9a23844b5", "yes");
INSERT INTO `wp_options` VALUES("26170", "akismet_spam_count", "3", "yes");
INSERT INTO `wp_options` VALUES("43793", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_options` VALUES("41392", "admin_email_lifespan", "1706344486", "yes");
INSERT INTO `wp_options` VALUES("58834", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_options` VALUES("58978", "revslider-additions", "O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-b.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-b.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("58862", "woocommerce_admin_last_orders_milestone", "0", "yes");
INSERT INTO `wp_options` VALUES("49151", "revslider-deact-notice", "1", "yes");
INSERT INTO `wp_options` VALUES("50607", "_transient_as_comment_count", "O:8:\"stdClass\":7:{s:8:\"approved\";s:1:\"1\";s:14:\"total_comments\";i:1;s:3:\"all\";i:1;s:9:\"moderated\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("52587", "rgmk_google_map_api_key", "AIzaSyDt54llyLTaHxPmBOe-xAjG7uzUMfvYnX4", "yes");
INSERT INTO `wp_options` VALUES("143759", "woocommerce_admin_version", "3.3.2", "yes");
INSERT INTO `wp_options` VALUES("58850", "action_scheduler_lock_async-request-runner", "6547b968db8b15.36304069|1699199396", "yes");
INSERT INTO `wp_options` VALUES("69156", "woocommerce_schema_version", "430", "yes");
INSERT INTO `wp_options` VALUES("58841", "woocommerce_admin_install_timestamp", "1589939156", "yes");
INSERT INTO `wp_options` VALUES("58836", "woocommerce_onboarding_profile", "a:1:{s:9:\"completed\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("58827", "duplicator_lite_inst_hash_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("58828", "action_scheduler_hybrid_store_demarkation", "6568", "yes");
INSERT INTO `wp_options` VALUES("58829", "schema-ActionScheduler_StoreSchema", "7.0.1690113414", "yes");
INSERT INTO `wp_options` VALUES("58830", "schema-ActionScheduler_LoggerSchema", "3.0.1634440624", "yes");
INSERT INTO `wp_options` VALUES("58831", "woocommerce_onboarding_opt_in", "no", "yes");
INSERT INTO `wp_options` VALUES("59335", "rs-templates-counter", "0", "no");
INSERT INTO `wp_options` VALUES("69165", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("69163", "_transient_woocommerce_reports-transient-version", "1643975609", "yes");
INSERT INTO `wp_options` VALUES("69722", "new_admin_email", "info@parsplugin.com", "yes");
INSERT INTO `wp_options` VALUES("72117", "bsf_last_update_check", "1699211493", "yes");
INSERT INTO `wp_options` VALUES("72120", "bsf_analytics_installed_time", "1598612014", "no");
INSERT INTO `wp_options` VALUES("72411", "wpp_settings", "a:15:{s:10:\"admin_lang\";s:7:\"disable\";s:9:\"user_lang\";s:7:\"disable\";s:12:\"submenu_move\";s:7:\"disable\";s:12:\"persian_date\";s:6:\"enable\";s:10:\"conv_title\";s:7:\"disable\";s:13:\"conv_contents\";s:7:\"disable\";s:12:\"conv_excerpt\";s:7:\"disable\";s:13:\"conv_comments\";s:7:\"disable\";s:18:\"conv_comment_count\";s:7:\"disable\";s:10:\"conv_dates\";s:7:\"disable\";s:9:\"conv_cats\";s:7:\"disable\";s:11:\"conv_arabic\";s:7:\"disable\";s:15:\"conv_permalinks\";s:6:\"enable\";s:11:\"news_source\";s:5:\"parsi\";s:15:\"conv_page_title\";s:7:\"disable\";}", "yes");
INSERT INTO `wp_options` VALUES("72412", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("72413", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("74602", "rs-addons-counter", "1", "yes");
INSERT INTO `wp_options` VALUES("79234", "wc_admin_note_home_screen_feedback_homescreen_accessed", "1603525021", "yes");
INSERT INTO `wp_options` VALUES("79235", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:0;s:22:\"there_are_now_products\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("82967", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("82968", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("82969", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("83250", "_transient_health-check-site-status-result", "{\"good\":17,\"recommended\":4,\"critical\":2}", "yes");
INSERT INTO `wp_options` VALUES("88952", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("88953", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("88954", "auto_update_core_major", "unset", "yes");
INSERT INTO `wp_options` VALUES("92291", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "yes");
INSERT INTO `wp_options` VALUES("98329", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `wp_options` VALUES("91430", "bsf_analytics_optin", "yes", "no");
INSERT INTO `wp_options` VALUES("98447", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("110319", "wc_remote_inbox_notifications_wca_updated", "", "no");
INSERT INTO `wp_options` VALUES("122323", "woocommerce_analytics_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("178851", "_site_transient_timeout_bsf_analytics_track", "1699371680", "no");
INSERT INTO `wp_options` VALUES("178852", "_site_transient_bsf_analytics_track", "1", "no");
INSERT INTO `wp_options` VALUES("118604", "woocommerce_inbox_variant_assignment", "1", "yes");
INSERT INTO `wp_options` VALUES("118603", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:19:\"info@parsplugin.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:19:\"info@parsplugin.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:3:\"yes\";}", "yes");
INSERT INTO `wp_options` VALUES("118602", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `wp_options` VALUES("119627", "rs_image_meta_todo", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("118592", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("118589", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("124947", "woocommerce_task_list_hidden_lists", "a:1:{i:0;s:5:\"setup\";}", "yes");
INSERT INTO `wp_options` VALUES("123153", "woocommerce_refund_returns_page_id", "6664", "yes");
INSERT INTO `wp_options` VALUES("124930", "us_license_activated", "1", "yes");
INSERT INTO `wp_options` VALUES("135129", "_transient_timeout_woocommerce_admin_remote_inbox_notifications_specs", "1699803683", "no");
INSERT INTO `wp_options` VALUES("135130", "_transient_woocommerce_admin_remote_inbox_notifications_specs", "a:36:{s:27:\"new_in_app_marketplace_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"new_in_app_marketplace_2021\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:36:\"Customize your store with extensions\";s:7:\"content\";s:164:\"Check out our NEW Extensions tab to see our favorite extensions for customizing your store, and discover the most popular extensions in the WooCommerce Marketplace.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"browse_extensions\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Browse extensions\";}}s:3:\"url\";s:24:\"admin.php?page=wc-addons\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:14:23\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.7\";}}}s:21:\"wayflyer_bnpl_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:21:\"wayflyer_bnpl_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:48:\"Grow your business with funding through Wayflyer\";s:7:\"content\";s:261:\"Fast, flexible financing to boost cash flow and help your business grow – one fee, no interest rates, penalties, equity, or personal guarantees. Based on your store’s performance, Wayflyer provides funding and analytical insights to invest in your business.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"wayflyer_bnpl_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Level up with funding\";}}s:3:\"url\";s:118:\"https://woocommerce.com/products/wayflyer/?utm_source=inbox_note&utm_medium=product&utm_campaign=wayflyer_bnpl_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-17 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-18 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"BE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IE\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NL\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"GB\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-affirm\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}}}}}}s:35:\"wc_shipping_mobile_app_usps_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:94:\"Print and manage your shipping labels with WooCommerce Shipping and the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Shipping\";}}s:3:\"url\";s:135:\"https://woocommerce.com/woocommerce-shipping/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc_shipping_mobile_app_usps_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-shipping-usps\";}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}}s:30:\"wc_shipping_mobile_app_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wc_shipping_mobile_app_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:69:\"Print and manage your shipping labels with the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"wc_shipping_mobile_app_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:30:\"Get the WooCommerce Mobile App\";}}s:3:\"url\";s:116:\"https://woocommerce.com/mobile/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc_shipping_mobile_app_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}s:37:\"ecomm-need-help-setting-up-your-store\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"ecomm-need-help-setting-up-your-store\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:32:\"Need help setting up your Store?\";s:7:\"content\";s:350:\"Schedule a free 30-min <a href=\"https://wordpress.com/support/concierge-support/\">quick start session</a> and get help from our specialists. We’re happy to walk through setup steps, show you around the WordPress.com dashboard, troubleshoot any issues you may have, and help you the find the features you need to accomplish your goals for your site.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:16:\"set-up-concierge\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Schedule free session\";}}s:3:\"url\";s:34:\"https://wordpress.com/me/concierge\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:16:48\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}}}s:20:\"woocommerce-services\";O:8:\"stdClass\":8:{s:4:\"slug\";s:20:\"woocommerce-services\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"WooCommerce Shipping & Tax\";s:7:\"content\";s:251:\"WooCommerce Shipping & Tax helps get your store \"ready to sell\" as quickly as possible. You create your products. We take care of tax calculation, payment processing, and shipping label printing! Learn more about the extension that you just installed.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:84:\"https://docs.woocommerce.com/document/woocommerce-shipping-and-tax/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:17:25\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:32:\"ecomm-unique-shopping-experience\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"ecomm-unique-shopping-experience\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"For a shopping experience as unique as your customers\";s:7:\"content\";s:270:\"Product Add-Ons allow your customers to personalize products while they\'re shopping on your online store. No more follow-up email requests—customers get what they want, before they\'re done checking out. Learn more about this extension that comes included in your plan.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"learn-more-ecomm-unique-shopping-experience\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:71:\"https://docs.woocommerce.com/document/product-add-ons/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:18:01\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:37:\"wc-admin-getting-started-in-ecommerce\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-getting-started-in-ecommerce\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:38:\"Getting Started in eCommerce - webinar\";s:7:\"content\";s:174:\"We want to make eCommerce and this process of getting started as easy as possible for you. Watch this webinar to get tips on how to have our store up and running in a breeze.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"watch-the-webinar\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Watch the webinar\";}}s:3:\"url\";s:28:\"https://youtu.be/V_2XtCOyZ7o\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:18:37\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:12:\"setup_client\";s:9:\"operation\";s:2:\"!=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_count\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:4:\"none\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:10:\"up-to-2500\";}}}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:467:\"That’s huge! You’re well on your way to building a successful online store — now it’s time to think about how you’ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:130:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:177:\"It’s crucial to get your store’s checkout as smooth as possible to avoid losing sales. Let’s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:144:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox_note&utm_medium=product&utm_campaign=optimizing-the-checkout-flow\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:49\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:39:\"wc-admin-first-five-things-to-customize\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-admin-first-five-things-to-customize\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:45:\"The first 5 things to customize in your store\";s:7:\"content\";s:175:\"Deciding what to start with first is tricky. To help you properly prioritize, we’ve put together this short list of the first few things you should customize in WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:130:\"https://woocommerce.com/posts/first-things-customize-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:20:31\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:2;}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:5:\"value\";s:9:\"NOT EMPTY\";s:7:\"default\";s:9:\"NOT EMPTY\";s:9:\"operation\";s:2:\"!=\";}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Payments setup - let us know what you think\";s:7:\"content\";s:146:\"Congrats on enabling WooCommerce Payments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:39:\"https://automattic.survey.fm/wc-pay-new\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:13\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:50\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:122:\"https://woocommerce.com/products/google-listings-and-ads?utm_source=inbox_note&utm_medium=product&utm_campaign=get-started\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:738:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site’s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woocommerce.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:30:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:31:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:442:\"Heads up! There’s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:33:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:358:\"Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br /><br />Start using our <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">latest PayPal today</a> to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:34:30\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:574:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br /><br />Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br /><br />For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:59:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:38;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}i:39;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.5.10\";}i:40;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.7\";}i:41;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.3\";}i:42;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.3\";}i:43;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.5\";}i:44;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.4\";}i:45;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.4\";}i:46;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.5\";}i:47;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.6\";}i:48;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.4\";}i:49;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.5\";}i:50;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.5\";}i:51;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.4\";}i:52;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.3\";}i:53;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.5\";}i:54;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.3\";}i:55;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:56;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.5\";}i:57;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.3\";}i:58;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.4\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:32:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:42\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:18\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:54\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:19:\"habit-moment-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"habit-moment-survey\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"We’re all ears! Share your experience so far with WooCommerce\";s:7:\"content\";s:136:\"We’d love your input to shape the future of WooCommerce together. Feel free to share any feedback, ideas or suggestions that you have.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:45:\"https://automattic.survey.fm/store-management\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:37:30\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:30;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:0;}}}s:26:\"ecomm-wc-navigation-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:26:\"ecomm-wc-navigation-survey\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"We’d like your feedback on the WooCommerce navigation\";s:7:\"content\";s:134:\"We’re making improvements to the WooCommerce navigation and would love your feedback. Share your experience in this 2 minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:32:\"share-navigation-survey-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:63:\"https://automattic.survey.fm/feedback-on-woocommerce-navigation\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:38:07\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:12:\"is_ecommerce\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:90;}}}s:42:\"woocommerce-core-paypal-march-2022-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:391:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy PayPal Standard security updates for stores running WooCommerce (version 3.5 to 6.3). It’s recommended to disable PayPal Standard, and use <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal Payments</a> to accept PayPal.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-core-paypal-march-2022-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:44:57\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:3:\"5.5\";}i:1;a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}}}}}}}s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:237:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy security updates related to PayPal Standard payment gateway for stores running WooCommerce (version 3.5 to 6.3).\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:45:04\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}s:24:\"pinterest_03_2022_update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"pinterest_03_2022_update\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"Your Pinterest for WooCommerce plugin is out of date!\";s:7:\"content\";s:262:\"Update to the latest version of Pinterest for WooCommerce to continue using this plugin and keep your store connected with Pinterest. To update, visit <strong>Plugins &gt; Installed Plugins</strong>, and click on “update now” under Pinterest for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"pinterest_03_2022_update\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"Update Instructions\";}}s:3:\"url\";s:148:\"https://woocommerce.com/document/pinterest-for-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=pinterest_03_2022_update#section-3\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-23 00:00:39\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"pinterest-for-woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"1.0.8\";}}}s:33:\"store_setup_survey_survey_q2_2022\";O:8:\"stdClass\":8:{s:4:\"slug\";s:33:\"store_setup_survey_survey_q2_2022\";s:4:\"type\";s:6:\"survey\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:30:\"How is your store setup going?\";s:7:\"content\";s:232:\"Our goal is to make sure you have all the right tools to start setting up your store in the smoothest way possible.\r\nWe’d love to know if we hit our mark and how we can improve. To collect your thoughts, we made a 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:53:\"store_setup_survey_survey_q2_2022_share_your_thoughts\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Tell us how it’s going\";}}s:3:\"url\";s:52:\"https://automattic.survey.fm/store-setup-survey-2022\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-05-09 08:42:10\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:7;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:9;}}}s:17:\"wc-admin-wisepad3\";O:8:\"stdClass\":8:{s:4:\"slug\";s:17:\"wc-admin-wisepad3\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:74:\"Take your business on the go in Canada with WooCommerce In-Person Payments\";s:7:\"content\";s:275:\"Quickly create new orders, accept payment in person for orders placed online, and automatically sync your inventory – no matter where your business takes you. With WooCommerce In-Person Payments and the WisePad 3 card reader, you can bring the power of your store anywhere.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"wc-admin-wisepad3\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Grow my business offline\";}}s:3:\"url\";s:126:\"https://woocommerce.com/products/wisepad3-card-reader/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc-admin-wisepad3\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-06-15 10:00:28\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}}}s:47:\"woocommerce-payments-august-2022-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-payments-august-2022-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:51:\"Action required: Please update WooCommerce Payments\";s:7:\"content\";s:213:\"An updated secure version of WooCommerce Payments is available – please ensure that you’re using the latest patch version. For more information on what action you need to take, please review the article below.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Find out more\";}}s:3:\"url\";s:96:\"https://developer.woocommerce.com/2022/08/09/woocommerce-payments-3-9-4-4-5-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:9:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-08-09 14:44:17\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"3.9\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"4.5.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.1\";}}}s:46:\"woocommerce-payments-august-2022-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-payments-august-2022-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:51:\"WooCommerce Payments has been automatically updated\";s:7:\"content\";s:265:\"You’re now running the latest secure version of WooCommerce Payments. We’ve worked with the WordPress Plugins team to deploy a security update to stores running WooCommerce Payments (version 3.9 to 4.5). For further information, please review the article below.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Find out more\";}}s:3:\"url\";s:96:\"https://developer.woocommerce.com/2022/08/09/woocommerce-payments-3-9-4-4-5-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-08-09 14:41:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:47:\"woocommerce-payments-august-2022-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.3\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.1\";}}}}}s:33:\"googlelistings_signals2022_hasGLA\";O:8:\"stdClass\":8:{s:4:\"slug\";s:33:\"googlelistings_signals2022_hasGLA\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:41:\"Show off your products with Ads on Google\";s:7:\"content\";s:331:\"You’re ready to grow with ads. Google optimizes for performance across your products; you only pay for results. If you’re new to Google, you can earn up to $500 in ad credits (T&amp;Cs apply). <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">Contact support</a> if you need guidance with Google Listings &amp; Ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:39:\"googlelistings_signals2022_hasGLA_click\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:29:\"Connect Google Listings & Ads\";}}s:3:\"url\";s:38:\"admin.php?page=wc-admin&path=marketing\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-09-12 07:23:39\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2022-10-12 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google-listings-and-ads\";}}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:330;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:76;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:38;}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:3700;s:9:\"operation\";s:1:\">\";}}}s:32:\"googlelistings_signals2022_noGLA\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"googlelistings_signals2022_noGLA\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:41:\"Show off your products with Ads on Google\";s:7:\"content\";s:331:\"You’re ready to grow with ads. Google optimizes for performance across your products; you only pay for results. If you’re new to Google, you can earn up to $500 in ad credits (T&amp;Cs apply). <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">Contact support</a> if you need guidance with Google Listings &amp; Ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:32:\"googlelistings_signals2022_noGLA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:29:\"Connect Google Listings & Ads\";}}s:3:\"url\";s:144:\"https://woocommerce.com/products/google-listings-and-ads/?utm_medium=product&utm_source=inbox_note&utm_campaign=googlelistings_signals2022_noGLA\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-09-12 07:27:46\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2022-10-12 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google-listings-and-ads\";}}}}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:330;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:76;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:38;}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:3700;s:9:\"operation\";s:1:\">\";}}}s:5:\"fa_IR\";a:60:{s:21:\"wayflyer_bnpl_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:21:\"wayflyer_bnpl_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:48:\"Grow your business with funding through Wayflyer\";s:7:\"content\";s:261:\"Fast, flexible financing to boost cash flow and help your business grow – one fee, no interest rates, penalties, equity, or personal guarantees. Based on your store’s performance, Wayflyer provides funding and analytical insights to invest in your business.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"wayflyer_bnpl_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Level up with funding\";}}s:3:\"url\";s:110:\"https://woo.com/products/wayflyer/?utm_source=inbox_note&utm_medium=product&utm_campaign=wayflyer_bnpl_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-17 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-18 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"BE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IE\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NL\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"GB\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-affirm\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}}}}}}s:35:\"wc_shipping_mobile_app_usps_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:94:\"Print and manage your shipping labels with WooCommerce Shipping and the WooCommerce Mobile App\";s:7:\"content\";s:202:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woo.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Shipping\";}}s:3:\"url\";s:127:\"https://woo.com/woocommerce-shipping/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc_shipping_mobile_app_usps_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-shipping-usps\";}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}}s:20:\"woocommerce-services\";O:8:\"stdClass\":8:{s:4:\"slug\";s:20:\"woocommerce-services\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"WooCommerce Shipping & Tax\";s:7:\"content\";s:251:\"WooCommerce Shipping & Tax helps get your store \"ready to sell\" as quickly as possible. You create your products. We take care of tax calculation, payment processing, and shipping label printing! Learn more about the extension that you just installed.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:84:\"https://docs.woocommerce.com/document/woocommerce-shipping-and-tax/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:17:25\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:459:\"That’s huge! You’re well on your way to building a successful online store — now it’s time to think about how you’ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woo.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:122:\"https://woo.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:177:\"It’s crucial to get your store’s checkout as smooth as possible to avoid losing sales. Let’s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:136:\"https://woo.com/posts/optimizing-woocommerce-checkout?utm_source=inbox_note&utm_medium=product&utm_campaign=optimizing-the-checkout-flow\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:49\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Payments setup - let us know what you think\";s:7:\"content\";s:146:\"Congrats on enabling WooCommerce Payments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:39:\"https://automattic.survey.fm/wc-pay-new\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:13\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:50\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:114:\"https://woo.com/products/google-listings-and-ads?utm_source=inbox_note&utm_medium=product&utm_campaign=get-started\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:722:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site’s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woo.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woo.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:30:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:31:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:434:\"Heads up! There’s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woo.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:33:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:350:\"Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br /><br />Start using our <a href=\"https://woo.com/products/woocommerce-paypal-payments/\" target=\"_blank\">latest PayPal today</a> to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:34:30\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:574:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br /><br />Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br /><br />For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:129:\"https://woo.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:59:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:38;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}i:39;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.5.10\";}i:40;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.7\";}i:41;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.3\";}i:42;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.3\";}i:43;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.5\";}i:44;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.4\";}i:45;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.4\";}i:46;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.5\";}i:47;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.6\";}i:48;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.4\";}i:49;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.5\";}i:50;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.5\";}i:51;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.4\";}i:52;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.3\";}i:53;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.5\";}i:54;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.3\";}i:55;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:56;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.5\";}i:57;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.3\";}i:58;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.4\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:129:\"https://woo.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:32:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:42\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:129:\"https://woo.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:18\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:129:\"https://woo.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:54\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:19:\"habit-moment-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"habit-moment-survey\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"We’re all ears! Share your experience so far with WooCommerce\";s:7:\"content\";s:136:\"We’d love your input to shape the future of WooCommerce together. Feel free to share any feedback, ideas or suggestions that you have.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:45:\"https://automattic.survey.fm/store-management\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:37:30\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:30;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:0;}}}s:42:\"woocommerce-core-paypal-march-2022-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:383:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy PayPal Standard security updates for stores running WooCommerce (version 3.5 to 6.3). It’s recommended to disable PayPal Standard, and use <a href=\"https://woo.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal Payments</a> to accept PayPal.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-core-paypal-march-2022-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:44:57\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:3:\"5.5\";}i:1;a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}}}}}}}s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:237:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy security updates related to PayPal Standard payment gateway for stores running WooCommerce (version 3.5 to 6.3).\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:45:04\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}s:24:\"pinterest_03_2022_update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"pinterest_03_2022_update\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"Your Pinterest for WooCommerce plugin is out of date!\";s:7:\"content\";s:262:\"Update to the latest version of Pinterest for WooCommerce to continue using this plugin and keep your store connected with Pinterest. To update, visit <strong>Plugins &gt; Installed Plugins</strong>, and click on “update now” under Pinterest for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"pinterest_03_2022_update\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"Update Instructions\";}}s:3:\"url\";s:140:\"https://woo.com/document/pinterest-for-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=pinterest_03_2022_update#section-3\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-23 00:00:39\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"pinterest-for-woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"1.0.8\";}}}s:33:\"store_setup_survey_survey_q2_2022\";O:8:\"stdClass\":8:{s:4:\"slug\";s:33:\"store_setup_survey_survey_q2_2022\";s:4:\"type\";s:6:\"survey\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:30:\"How is your store setup going?\";s:7:\"content\";s:232:\"Our goal is to make sure you have all the right tools to start setting up your store in the smoothest way possible.\r\nWe’d love to know if we hit our mark and how we can improve. To collect your thoughts, we made a 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:53:\"store_setup_survey_survey_q2_2022_share_your_thoughts\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Tell us how it’s going\";}}s:3:\"url\";s:52:\"https://automattic.survey.fm/store-setup-survey-2022\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-05-09 08:42:10\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:7;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:9;}}}s:47:\"woocommerce-payments-august-2022-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-payments-august-2022-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:51:\"Action required: Please update WooCommerce Payments\";s:7:\"content\";s:213:\"An updated secure version of WooCommerce Payments is available – please ensure that you’re using the latest patch version. For more information on what action you need to take, please review the article below.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Find out more\";}}s:3:\"url\";s:96:\"https://developer.woocommerce.com/2022/08/09/woocommerce-payments-3-9-4-4-5-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:9:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-08-09 14:44:17\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"3.9\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"4.5.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.1\";}}}s:46:\"woocommerce-payments-august-2022-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-payments-august-2022-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:51:\"WooCommerce Payments has been automatically updated\";s:7:\"content\";s:265:\"You’re now running the latest secure version of WooCommerce Payments. We’ve worked with the WordPress Plugins team to deploy a security update to stores running WooCommerce Payments (version 3.9 to 4.5). For further information, please review the article below.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Find out more\";}}s:3:\"url\";s:96:\"https://developer.woocommerce.com/2022/08/09/woocommerce-payments-3-9-4-4-5-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-08-09 14:41:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:47:\"woocommerce-payments-august-2022-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.3\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.1\";}}}}}s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:58:\"Security vulnerability patched in WooCommerce Eway Gateway\";s:7:\"content\";s:323:\"In response to a potential vulnerability identified in WooCommerce Eway Gateway versions 3.1.0 to 3.5.0, we’ve worked to deploy security fixes and have released an updated version.\r\nNo external exploits have been detected, but we recommend you update to your latest supported version 3.1.26, 3.2.3, 3.3.1, 3.4.6, or 3.5.1\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:62:\"needs-update-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:63:\"needs-update-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.1.26\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"3.5.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"3.1.0\";}}}s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Eway Gateway has been automatically updated\";s:7:\"content\";s:280:\"Your store is now running the latest secure version of WooCommerce Eway Gateway. We worked with the WordPress Plugins team to deploy a software update to stores running WooCommerce Eway Gateway (versions 3.1.0 to 3.5.0) in response to a security vulnerability that was discovered.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"updated-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"See all updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"updated-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:5:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.1.26\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.3\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}}}}}s:31:\"ecomm-wc-navigation-survey-2023\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"ecomm-wc-navigation-survey-2023\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:39:\"Navigating WooCommerce on WordPress.com\";s:7:\"content\";s:166:\"We are improving the WooCommerce navigation on WordPress.com and would love your help to make it better! Please share your experience with us in this 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:32:\"share-navigation-survey-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:58:\"https://automattic.survey.fm/new-ecommerce-plan-navigation\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-01-16 09:53:44\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:12:\"is_ecommerce\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:180;}}}s:39:\"woopay-beta-merchantrecruitment-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"woopay-beta-merchantrecruitment-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:319:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> —and we’re inviting you to be one of the first to try it. \r\n<br><br>\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br><br>\r\n<b>Get started in seconds.</b>\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:48:\"woopay-beta-merchantrecruitment-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:147:\"https://woo.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:27\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:42:\"woocommerce-wcpay-march-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-wcpay-march-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:57:\"Action required: Security update for WooCommerce Payments\";s:7:\"content\";s:296:\"<strong>Your store requires a security update for WooCommerce Payments</strong>. Please update to the latest version of WooCommerce Payments immediately to address a potential vulnerability discovered on March 22. For more information on how to update, visit this WooCommerce Developer Blog Post.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:49:\"woocommerce-wcpay-march-2023-update-needed-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"See Blog Post\";}}s:3:\"url\";s:122:\"https://developer.woocommerce.com/2023/03/23/critical-vulnerability-detected-in-woocommerce-payments-what-you-need-to-know\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"woocommerce-wcpay-march-2023-update-needed-dismiss-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:11:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-03-22 20:25:44\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"4.8.0\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"5.6.1\";}}}s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:52:\"Accept in-person contactless payments on your iPhone\";s:7:\"content\";s:230:\"Tap to Pay on iPhone and WooCommerce Payments is quick, secure, and simple to set up — no extra terminals or card readers are needed. Accept contactless debit and credit cards, Apple Pay, and other NFC digital wallets in person.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:20:\"Simplify my payments\";}}s:3:\"url\";s:135:\"https://woo.com/products/woocommerce-payments/?utm_source=inbox_note&utm_medium=product&utm_campaign=tap_to_pay_iphone_q2_2023_no_wcpay\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-03 23:59:47\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:68:\"Action required: Security update of WooCommerce Pre-Orders extension\";s:7:\"content\";s:220:\"<strong>Your store requires a security update for the WooCommerce Pre-Orders extension</strong>. Please update the WooCommerce Pre-Orders extension immediately to address a potential vulnerability discovered on April 11.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:18:\"extension-settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:15:\"update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-12 22:16:37\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:22:\"woocommerce-pre-orders\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.0.0\";}}}s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:321:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> — and you’re invited to try it. \r\n<br /><br />\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br /><br />\r\n<b>Update WooCommerce Payments</b> to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:52:\"woopay-beta-merchantrecruitment-update-WCPay-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:55:\"woopay-beta-merchantrecruitment-update-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:361:\"Thanks for previously trying WooPay, the<b> express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>. No action is required on your part.\r\n<br /><br />\r\nYou can now <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Documentation\";}}s:3:\"url\";s:170:\"https://woo.com/document/woopay-merchant-documentation/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:23\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:44:\"woopay-beta-existingmerchants-update-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woopay-beta-existingmerchants-update-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:368:\"Thanks for previously trying WooPay, the <b>express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>.\r\n<br /><br />\r\n\r\nUpdate to the latest WooCommerce Payments version to <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:50:\"woopay-beta-existingmerchants-update-WCPay-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:45:\"woopay-beta-merchantrecruitment-short-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woopay-beta-merchantrecruitment-short-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woopay-beta-merchantrecruitment-short-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:64:\"woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:153:\"https://woo.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:36\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.bluebeautifly.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://indianrivernatural.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://fouroaksproducts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:14:\"https://acb.la\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://www.sweetpotatoplant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://www.gocaseyourself.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://laugun.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://nebraskadaybyday.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://vintagemarche727.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://kohai.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://gracegaze.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://aliensmeaning.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://myheritagegardens.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://shopmoresport.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://oladino.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://frogjumpstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cagedthundermma.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/mcelwainelementary\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://mgco.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://500gp.io/pay\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://waterglassslimes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://antiqueful.shop/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://deeperkidmin.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/cyspringsboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://houseofminifigs.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2273.temp.domains/~dream