<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

/**
 * Configuration for shortcode: us_gallery
 */

$misc = us_config( 'elements_misc' );
$design_options_params = us_config( 'elements_design_options' );

// Get Media Category terms for selection
$media_category_terms = array();
if ( us_is_elm_editing_page() ) {
	$terms_args = array(
		'taxonomy' => 'us_media_category',
		'get' => 'all',
		'number' => 15,
	);
	if ( $terms = get_terms( $terms_args ) AND ! is_wp_error( $terms ) ) {
		foreach ( $terms as $term_object ) {
			$media_category_terms[ $term_object->term_id ] = $term_object->name;
		}
	}
}

// Image Source options
$source_options = array(
	'ids' => __( 'Selected Images', 'us' ),
	// 'cf|us_tile_additional_image' => __( 'Custom appearance in Grid', 'us' ) . ': ' . us_translate( 'Images' ),
);

// Order options for Media
$orderby_options = array(
	'date' => __( 'Date of upload', 'us' ),
	'modified' => __( 'Date of update', 'us' ),
	'post__in' => __( 'Order of selected images', 'us' ),
	'rand' => us_translate( 'Random' ),
	'title' => us_translate( 'Title' ),
);

// General
$general_params = array(

	// Images source
	'source' => array(
		'title' => us_translate( 'Show' ),
		'type' => 'select',
		'options' => apply_filters( 'us_gallery_source_options', $source_options ),
		'std' => 'ids',
		'admin_label' => TRUE,
		'usb_preview' => TRUE,
	),
	'ids' => array(
		'type' => 'upload',
		'is_multiple' => TRUE,
		'extension' => 'png,jpg,jpeg,gif,svg',
		'std' => '',
		// 'show_if' => array( 'source', '=', 'ids' ),
		'classes' => 'for_above',
		'usb_preview' => TRUE,
	),

	// Media Categories
	'include_us_media_category' => array(
		'title' => sprintf( __( 'Show Images by %s', 'us' ), __( 'Media Categories', 'us' ) ),
		// Show checkboxes, if terms are 15 or less, if not - show autocomplete
		// Note: checkboxes data for Visual Composer and USBuilder are displayed differently
		'type' => ( count( $media_category_terms ) > 15 ? 'autocomplete' : 'checkboxes' ),
		'options_prepared_for_wpb' => TRUE,
		'settings' => array(
			'nonce_name' => 'us_ajax_get_taxonomies_autocomplete',
			'action' => 'us_get_taxonomies_autocomplete',
			'slug' => 'us_media_category',
		),
		'is_multiple' => TRUE,
		'cols' => 1, // for correct UI in WPBakery
		'options' => $media_category_terms,
		'std' => '',
		'place_if' => (bool) $media_category_terms,
		'usb_preview' => TRUE,
	),
	'exclude_us_media_category' => array(
		'title' => sprintf( __( 'Exclude Images by %s', 'us' ), __( 'Media Categories', 'us' ) ),
		// Show checkboxes, if terms are 15 or less, if not - show autocomplete
		// Note: checkboxes data for Visual Composer and USBuilder are displayed differently
		'type' => ( count( $media_category_terms ) > 15 ? 'autocomplete' : 'checkboxes' ),
		'options_prepared_for_wpb' => TRUE,
		'settings' => array(
			'nonce_name' => 'us_ajax_get_taxonomies_autocomplete',
			'action' => 'us_get_taxonomies_autocomplete',
			'slug' => 'us_media_category',
		),
		'is_multiple' => TRUE,
		'cols' => 1, // for correct UI in WPBakery
		'options' => $media_category_terms,
		'std' => '',
		'place_if' => (bool) $media_category_terms,
		'usb_preview' => TRUE,
	),

	// Order
	'orderby' => array(
		'title' => __( 'Order by', 'us' ),
		'type' => 'select',
		'options' => apply_filters( 'us_gallery_orderby_options', $orderby_options ),
		'std' => 'date',
		'usb_preview' => TRUE,
	),
	'order_invert' => array(
		'type' => 'switch',
		'switch_text' => __( 'Invert order', 'us' ),
		'std' => 0,
		'classes' => 'for_above',
		'show_if' => array( 'orderby', '!=', array( 'post__in', 'rand' ) ),
		'usb_preview' => TRUE,
	),

	// Quantity
	'show_all' => array(
		'title' => __( 'Quantity', 'us' ),
		'type' => 'switch',
		'switch_text' => __( 'Show All Images', 'us' ),
		'std' => 0,
		'usb_preview' => TRUE,
	),
	'quantity' => array(
		'type' => 'slider',
		'options' => array(
			'' => array(
				'min' => 1,
				'max' => 30,
			),
		),
		'std' => '12',
		'show_if' => array( 'show_all', '=', 0 ),
		'classes' => 'for_above',
		'usb_preview' => TRUE,
	),

	// No results
	'no_items_action'=> array(
		'title' => __( 'Action when no images found', 'us' ),
		'type' => 'select',
		'options' => array(
			'message' => __( 'Show the message', 'us' ),
			'hide' => __( 'Hide this element', 'us' ),
		),
		'std' => 'message',
		'usb_preview' => TRUE,
	),
	'no_items_message' => array(
		'type' => 'text',
		'std' => us_translate( 'No results found.' ),
		'classes' => 'for_above',
		'show_if' => array( 'no_items_action', '=', 'message' ),
		'usb_preview' => array(
			'elm' => '.w-gallery-no-results',
			'attr' => 'html',
		),
	),
);

// Appearance
$appearance_params = array(
	'layout' => array(
		'title' => __( 'Layout', 'us' ),
		'type' => 'imgradio',
		'preview_path' => '/admin/img/gallery/%s.png',
		'options' => array(
			'grid' => __( 'Regular Grid', 'us' ),
			'masonry' => __( 'Masonry', 'us' ),
			'metro_1' => 'METRO 1',
			'metro_2' => 'METRO 2',
			'metro_3' => 'METRO 3',
			'metro_4' => 'METRO 4',
			'mosaic_hor' => __( 'Mosaic', 'us' ),
		),
		'std' => 'grid',
		'admin_label' => TRUE,
		'group' => us_translate( 'Appearance' ),
		'usb_preview' => TRUE,
	),
	'columns' => array(
		'title' => us_translate( 'Columns' ),
		'type' => 'slider',
		'options' => array(
			'' => array(
				'min' => 1,
				'max' => 10,
			),
		),
		'std' => '4',
		'admin_label' => TRUE,
		'show_if' => array( 'layout', '=', array( 'grid', 'masonry' ) ),
		'group' => us_translate( 'Appearance' ),
		'usb_preview' => TRUE, // TODO: use 'css' => '--columns' for non-masonry
	),
	'items_height' => array(
		'title' => __( 'Height of Images', 'us' ),
		'type' => 'slider',
		'std' => '350px',
		'options' => array(
			'px' => array(
				'min' => 200,
				'max' => 600,
				'step' => 10,
			),
		),
		'show_if' => array( 'layout', '=', 'mosaic_hor' ),
		'group' => us_translate( 'Appearance' ),
		'usb_preview' => array(
			'css' => '--items-height',
		),
	),
	'items_gap' => array(
		'title' => __( 'Gap between Images', 'us' ),
		'type' => 'slider',
		'std' => '10px',
		'options' => array(
			'px' => array(
				'min' => 0,
				'max' => 50,
			),
			'rem' => array(
				'min' => 0.0,
				'max' => 3.0,
				'step' => 0.1,
			),
			'vmax' => array(
				'min' => 0.0,
				'max' => 3.0,
				'step' => 0.1,
			),
			'vmin' => array(
				'min' => 0.0,
				'max' => 3.0,
				'step' => 0.1,
			),
		),
		'group' => us_translate( 'Appearance' ),
		'usb_preview' => TRUE, // TODO: use 'css' => '--items-gap' for non-masonry
	),
	'items_ratio' => array(
		'title' => __( 'Image Aspect Ratio', 'us' ),
		'type' => 'select',
		'options' => array(
			'1x1' => '1:1 ' . __( 'square', 'us' ),
			'4x3' => '4:3 ' . __( 'landscape', 'us' ),
			'3x2' => '3:2 ' . __( 'landscape', 'us' ),
			'16x9' => '16:9 ' . __( 'landscape', 'us' ),
			'3x4' => '3:4 ' . __( 'portrait', 'us' ),
			'2x3' => '2:3 ' . __( 'portrait', 'us' ),
			'custom' => __( 'Custom', 'us' ),
		),
		'std' => '1x1',
		'show_if' => array( 'layout', '!=', array( 'masonry', 'mosaic_hor', 'mosaic_ver' ) ),
		'group' => us_translate( 'Appearance' ),
		'usb_preview' => array(
			'mod' => 'ratio',
		),
	),
	'items_ratio_width' => array(
		'description' => __( 'Examples:', 'us' ) . ' <span class="usof-example">21</span>, <span class="usof-example">1200</span>, <span class="usof-example">640px</span>',
		'type' => 'text',
		'std' => '21',
		'cols' => 2,
		'classes' => 'for_above',
		'show_if' => array( 'items_ratio', '=', 'custom' ),
		'group' => us_translate( 'Appearance' ),
		'usb_preview' => array(
			'css' => '--items-ratio-width',
		),
	),
	'items_ratio_height' => array(
		'description' => __( 'Examples:', 'us' ) . ' <span class="usof-example">9</span>, <span class="usof-example">750</span>, <span class="usof-example">380px</span>',
		'type' => 'text',
		'std' => '9',
		'cols' => 2,
		'classes' => 'for_above',
		'show_if' => array( 'items_ratio', '=', 'custom' ),
		'group' => us_translate( 'Appearance' ),
		'usb_preview' => array(
			'css' => '--items-ratio-height',
		),
	),
	'items_title' => array(
		'type' => 'switch',
		'switch_text' => __( 'Show Title of Images', 'us' ),
		'std' => 0,
		'group' => us_translate( 'Appearance' ),
		'usb_preview' => TRUE,
	),
	 'items_click_action' => array(
		 'title' => __( 'Action on Image click', 'us' ),
		 'type' => 'select',
		 'options' => array(
			 'none' => us_translate( 'None' ),
			 'popup_image' => __( 'Open Image in a popup', 'us' ),
			 'link' => __( 'Custom Link', 'us' ),
		 ),
		 'std' => 'none',
		 'group' => us_translate( 'Appearance' ),
		 'usb_preview' => TRUE,
	 ),
	 'items_link' => array(
		 'type' => 'link',
		 'dynamic_values' => TRUE,
		 'link_additional_values' => array(
			 'custom_field|us_attachment_link' => us_translate( 'Media File' ) . ': ' . __( 'Custom Link', 'us' ),
		 ),
		 'std' => '{"url":""}',
		 'classes' => 'for_above',
		 'show_if' => array( 'items_click_action', '=', 'link' ),
		 'group' => us_translate( 'Appearance' ),
		 'usb_preview' => TRUE,
	 ),
	'img_size' => array(
		'title' => __( 'Image Size', 'us' ),
		'description' => $misc['desc_img_sizes'],
		'type' => 'select',
		'options' => us_get_image_sizes_list(),
		'std' => 'large',
		'group' => us_translate( 'Appearance' ),
		'usb_preview' => TRUE,
	),
);

return array(
	'title' => us_translate( 'Gallery' ),
	'category' => __( 'Grid', 'us' ),
	'icon' => 'fas fa-th-large',
	'params' => us_set_params_weight(
		$general_params,
		$appearance_params,
		$design_options_params
	),
	'usb_init_js' => '$elm.filter( \'.type_masonry\' ).wMasonryGallery();',
);
