/**
 * UpSolution Element: Gallery
 * Used for regular WordPress gallery design improvement
 */
jQuery( function( $ ) {
	$( '.w-gallery.action_popup_image .w-gallery-list' ).each( function( _, list ) {
		var $list = $( list );

		$us.getScript( $us.templateDirectoryUri + '/common/js/vendor/magnific-popup.js', function() {
			$( 'a.w-gallery-item-link', $list ).magnificPopup( {
				type: 'image',
				gallery: {
					enabled: true,
					navigateByImgClick: true,
					preload: [0, 1],
					tPrev: $us.langOptions.magnificPopup.tPrev, // Alt text on left arrow
					tNext: $us.langOptions.magnificPopup.tNext, // Alt text on right arrow
					tCounter: $us.langOptions.magnificPopup.tCounter // Markup for "1 of 7" counter
				},
				removalDelay: 300,
				mainClass: 'mfp-fade',
				fixedContentPos: true
			} );
		}.bind( this ) );
	} );

	// Applying isotope to gallery
	$.fn.wMasonryGallery = function() {
		return this.each( function() {
			var $container = $( '.w-gallery-list', this ),
				isotopeOptions = {
					layoutMode: 'masonry',
					isOriginLeft: ! $( 'body' ).hasClass( 'rtl' )
				};
			if ( $container.parents( '.w-tabs-section-content-h' ).length ) {
				isotopeOptions.transitionDuration = 0;
			}
			$us.getScript( $us.templateDirectoryUri + '/common/js/vendor/isotope.js', function() {
				$container.imagesLoaded( function() {
					$container.isotope( isotopeOptions );
					$container.isotope();
				} );
				$us.$canvas.on( 'contentChange', function() {
					$container.imagesLoaded( function() {
						$container.isotope();
					} );
				} );
			} );

		} );
	}

	$( '.w-gallery.type_masonry' ).wMasonryGallery();

} );
